/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.security.authorization;

import java.util.Optional;
import javax.inject.Named;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.ComponentAccessController;
import org.silverpeas.core.security.authorization.DefaultInstanceAccessControlExtension;

@Named
@Service
public class CommunityInstanceAccessControlExtension
extends DefaultInstanceAccessControlExtension {
    static final String CAN_ANONYMOUS_ACCESS_INSTANCE = "CommunityCanAnonymousAccessInstance";

    protected boolean mustUserBeComponentInstanceAdminIfManagerOfParentSpace(ComponentAccessController.DataManager dataManager, User user, SilverpeasComponentInstance componentInstance) {
        return dataManager.getManageableSpaceIds(user.getId()).contains(componentInstance.getSpaceId().replace("WA", ""));
    }

    protected boolean canAnonymousAccessInstance(AccessControlContext context) {
        return Optional.ofNullable((Boolean)context.get(CAN_ANONYMOUS_ACCESS_INSTANCE, Boolean.class)).orElse(false);
    }
}

