/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.notification.user;

import java.util.Collection;
import java.util.Collections;
import org.silverpeas.components.community.model.CommunityOfUsers;
import org.silverpeas.components.community.notification.user.AbstractCommunityUserNotificationBuilder;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.template.SilverpeasTemplate;

public class MembershipRequestValidationUserNotificationBuilder
extends AbstractCommunityUserNotificationBuilder {
    private User requester;
    private boolean accepted;
    private String message;

    protected MembershipRequestValidationUserNotificationBuilder(CommunityOfUsers resource) {
        super(resource);
    }

    public static MembershipRequestValidationUserNotificationBuilder about(CommunityOfUsers community) {
        return new MembershipRequestValidationUserNotificationBuilder(community);
    }

    public MembershipRequestValidationUserNotificationBuilder validating(User requester, boolean accept) {
        this.requester = requester;
        this.accepted = accept;
        return this;
    }

    public MembershipRequestValidationUserNotificationBuilder withMessage(String message) {
        this.message = message;
        return this;
    }

    protected String getBundleSubjectKey() {
        return this.accepted ? "community.join.request.validate.accept.notif.subject" : "community.join.request.validate.refuse.notif.subject";
    }

    protected String getTemplateFileName() {
        return "communityMembershipRequestValidation";
    }

    protected Collection<String> getUserIdsToNotify() {
        return Collections.singletonList(this.requester.getId());
    }

    protected void perform(CommunityOfUsers resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().setOriginalExtraMessage(this.message);
    }

    @Override
    protected void performTemplateData(String language, CommunityOfUsers resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        template.setAttribute("accepted", (Object)this.accepted);
    }
}

