/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.model;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.silverpeas.components.community.model.CommunityMembership;
import org.silverpeas.components.community.model.CommunityOfUsers;
import org.silverpeas.components.community.model.MembershipStatus;
import org.silverpeas.components.community.repository.CommunityMembershipRepository;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.SilverpeasList;

public class CommunityMembershipsProvider {
    private final CommunityOfUsers community;
    private final CommunityMembershipRepository repository;
    private final CommunityMembershipRepository.CommunityMembershipsTable memberships;

    static CommunityMembershipsProvider getProvider(CommunityOfUsers community) {
        return new CommunityMembershipsProvider(community);
    }

    private CommunityMembershipsProvider(CommunityOfUsers community) {
        this.community = community;
        this.repository = (CommunityMembershipRepository)ServiceProvider.getService(CommunityMembershipRepository.class, (Annotation[])new Annotation[0]);
        this.memberships = this.repository.getMembershipsTable(this.community);
    }

    public boolean isEmpty() {
        return this.memberships.isEmpty();
    }

    public Optional<CommunityMembership> get(@Nonnull String membershipId) {
        Objects.requireNonNull(membershipId);
        return Optional.ofNullable((CommunityMembership)this.repository.getById(membershipId));
    }

    public Optional<CommunityMembership> get(@Nullable User user) {
        return user == null ? Optional.empty() : this.memberships.getByUser(user);
    }

    public SilverpeasList<CommunityMembership> getPending(@Nullable PaginationPage page) {
        return this.memberships.getPending(page);
    }

    public SilverpeasList<CommunityMembership> getInRange(@Nonnull PaginationPage page) {
        Objects.requireNonNull(page);
        this.synchronize();
        return this.memberships.getMembers(page);
    }

    public SilverpeasList<CommunityMembership> getHistory(@Nonnull PaginationPage page) {
        Objects.requireNonNull(page);
        this.synchronize();
        return this.memberships.getAll(page);
    }

    private void synchronize() {
        List<CommunityMembership> actualMemberships = this.memberships.getAllMembers();
        Set<String> usersPlayingRole = this.community.getCommunitySpace().getAllUsers();
        Transaction.performInOne(() -> {
            usersPlayingRole.stream().filter(u -> actualMemberships.stream().filter(m -> m.getStatus().isMember() || m.getStatus().isPending()).noneMatch(m -> m.getUser().getId().equals(u))).map(User::getById).map(u -> CommunityMembership.asMember(u, this.community)).forEach(CommunityMembership::save);
            actualMemberships.stream().filter(m -> m.getStatus().isMember()).filter(m -> !usersPlayingRole.contains(m.getUser().getId())).forEach(CommunityMembership::delete);
            actualMemberships.stream().filter(m -> m.getStatus().isPending()).filter(m -> usersPlayingRole.contains(m.getUser().getId())).forEach(m -> {
                m.setStatus(MembershipStatus.COMMITTED);
                m.save();
            });
            return null;
        });
    }
}

