/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.document.bundlor.DocumentBundlor;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.Nullable;

public class BundledTypesRegistry {
    public static BundledTypesRegistry NOOP = BundledTypesRegistry.from(EmptyNodeState.EMPTY_NODE);
    private final Map<String, DocumentBundlor> bundlors;

    public BundledTypesRegistry(Map<String, DocumentBundlor> bundlors) {
        this.bundlors = ImmutableMap.copyOf(bundlors);
    }

    public static BundledTypesRegistry from(NodeState configParentState) {
        HashMap bundlors = Maps.newHashMap();
        for (ChildNodeEntry e : configParentState.getChildNodeEntries()) {
            NodeState config = e.getNodeState();
            if (config.getBoolean("disabled")) continue;
            bundlors.put(e.getName(), DocumentBundlor.from(config));
        }
        return new BundledTypesRegistry(bundlors);
    }

    @Nullable
    public DocumentBundlor getBundlor(NodeState state) {
        if (BundledTypesRegistry.isVersionedNode(state)) {
            return this.getBundlorForVersionedNode(state);
        }
        for (String mixin : BundledTypesRegistry.getMixinNames(state, "jcr:mixinTypes")) {
            DocumentBundlor bundlor = this.bundlors.get(mixin);
            if (bundlor == null) continue;
            return bundlor;
        }
        return this.bundlors.get(BundledTypesRegistry.getPrimaryTypeName(state, "jcr:primaryType"));
    }

    private DocumentBundlor getBundlorForVersionedNode(NodeState state) {
        for (String mixin : BundledTypesRegistry.getMixinNames(state, "jcr:frozenMixinTypes")) {
            DocumentBundlor bundlor = this.bundlors.get(mixin);
            if (bundlor == null) continue;
            return bundlor;
        }
        return this.bundlors.get(BundledTypesRegistry.getPrimaryTypeName(state, "jcr:frozenPrimaryType"));
    }

    Map<String, DocumentBundlor> getBundlors() {
        return this.bundlors;
    }

    private static boolean isVersionedNode(NodeState state) {
        return "nt:frozenNode".equals(BundledTypesRegistry.getPrimaryTypeName(state, "jcr:primaryType"));
    }

    private static String getPrimaryTypeName(NodeState nodeState, String typePropName) {
        PropertyState ps = nodeState.getProperty(typePropName);
        return ps == null ? "nt:base" : (String)ps.getValue(Type.NAME);
    }

    private static Iterable<String> getMixinNames(NodeState nodeState, String typePropName) {
        PropertyState ps = nodeState.getProperty(typePropName);
        return ps == null ? Collections.emptyList() : (Iterable)ps.getValue(Type.NAMES);
    }

    public static BundledTypesRegistryBuilder builder() {
        return new BundledTypesRegistryBuilder(EmptyNodeState.EMPTY_NODE.builder());
    }

    public static class BundledTypesRegistryBuilder {
        private final NodeBuilder builder;

        public BundledTypesRegistryBuilder(NodeBuilder builder) {
            this.builder = builder;
        }

        public TypeBuilder forType(String typeName) {
            NodeBuilder child = this.builder.child(typeName);
            child.setProperty("jcr:primaryType", (Object)"oak:Unstructured", Type.NAME);
            return new TypeBuilder(this, child);
        }

        public TypeBuilder forType(String typeName, String ... includes) {
            TypeBuilder typeBuilder = this.forType(typeName);
            for (String include : includes) {
                typeBuilder.include(include);
            }
            return typeBuilder;
        }

        public BundledTypesRegistry buildRegistry() {
            return BundledTypesRegistry.from(this.builder.getNodeState());
        }

        public NodeState build() {
            return this.builder.getNodeState();
        }

        public static class TypeBuilder {
            private final BundledTypesRegistryBuilder parent;
            private final NodeBuilder typeBuilder;
            private final Set<String> patterns = Sets.newHashSet();

            private TypeBuilder(BundledTypesRegistryBuilder parent, NodeBuilder typeBuilder) {
                this.parent = parent;
                this.typeBuilder = typeBuilder;
            }

            public TypeBuilder include(String pattern) {
                this.patterns.add(pattern);
                return this;
            }

            public BundledTypesRegistry buildRegistry() {
                this.setupPatternProp();
                return this.parent.buildRegistry();
            }

            public BundledTypesRegistryBuilder registry() {
                this.setupPatternProp();
                return this.parent;
            }

            public NodeState build() {
                this.setupPatternProp();
                return this.parent.build();
            }

            private void setupPatternProp() {
                this.typeBuilder.setProperty(PropertyStates.createProperty((String)"pattern", this.patterns, (Type)Type.STRINGS));
            }
        }
    }
}

