/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamePathRev
implements CacheValue,
Comparable<NamePathRev> {
    private static final Logger LOG = LoggerFactory.getLogger(NamePathRev.class);
    @NotNull
    private final String name;
    @NotNull
    private final Path path;
    @NotNull
    private final RevisionVector revision;

    public NamePathRev(@NotNull String name, @NotNull Path path, @NotNull RevisionVector revision) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.path = (Path)Preconditions.checkNotNull((Object)path);
        this.revision = (RevisionVector)Preconditions.checkNotNull((Object)revision);
    }

    @NotNull
    public Path getPath() {
        return this.path;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public RevisionVector getRevision() {
        return this.revision;
    }

    public int getMemory() {
        long size = 24L + (long)this.path.getMemory() + (long)StringUtils.estimateMemoryUsage((String)this.name) + (long)this.revision.getMemory();
        if (size > Integer.MAX_VALUE) {
            LOG.debug("Estimated memory footprint larger than Integer.MAX_VALUE: {}.", (Object)size);
            size = Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public int compareTo(@NotNull NamePathRev other) {
        if (this == other) {
            return 0;
        }
        int compare = this.name.compareTo(other.name);
        if (compare != 0) {
            return compare;
        }
        compare = this.path.compareTo(other.path);
        if (compare != 0) {
            return compare;
        }
        return this.revision.compareTo(other.revision);
    }

    public int hashCode() {
        int h = 17;
        h = 37 * h + this.name.hashCode();
        h = 37 * h + this.path.hashCode();
        h = 37 * h + this.revision.hashCode();
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NamePathRev) {
            NamePathRev other = (NamePathRev)obj;
            return this.revision.equals(other.revision) && this.name.equals(other.name) && this.path.equals(other.path);
        }
        return false;
    }

    public String toString() {
        int dim = this.revision.getDimensions();
        int len = this.path.length() + this.name.length();
        StringBuilder sb = new StringBuilder(len + (Revision.REV_STRING_APPROX_SIZE + 1) * dim);
        sb.append(this.name);
        this.path.toStringBuilder(sb).append('@');
        this.revision.toStringBuilder(sb);
        return sb.toString();
    }
}

