/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeEditor
implements Editor {
    private final Collection<? extends Editor> editors;

    @Nullable
    public static Editor compose(@NotNull Collection<? extends Editor> editors) {
        Preconditions.checkNotNull(editors);
        switch (editors.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return editors.iterator().next();
            }
        }
        return new CompositeEditor(editors);
    }

    public CompositeEditor(Collection<? extends Editor> editors) {
        this.editors = editors;
    }

    public CompositeEditor(Editor ... editors) {
        this(Arrays.asList(editors));
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.enter(before, after);
        }
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.leave(before, after);
        }
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.propertyAdded(after);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.propertyChanged(before, after);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.propertyDeleted(before);
        }
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        ArrayList list = Lists.newArrayListWithCapacity((int)this.editors.size());
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeAdded(name, after);
            if (child == null) continue;
            list.add(child);
        }
        return CompositeEditor.compose(list);
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        ArrayList list = Lists.newArrayListWithCapacity((int)this.editors.size());
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeChanged(name, before, after);
            if (child == null) continue;
            list.add(child);
        }
        return CompositeEditor.compose(list);
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        ArrayList list = Lists.newArrayListWithCapacity((int)this.editors.size());
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeDeleted(name, before);
            if (child == null) continue;
            list.add(child);
        }
        return CompositeEditor.compose(list);
    }
}

