/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.AbstractCacheStats;
import org.jetbrains.annotations.NotNull;

public class SegmentCacheStats
extends AbstractCacheStats {
    @NotNull
    private final Supplier<Long> maximumWeight;
    @NotNull
    private final Supplier<Long> elementCount;
    @NotNull
    final Supplier<Long> currentWeight;
    @NotNull
    final AtomicLong loadSuccessCount = new AtomicLong();
    @NotNull
    final AtomicInteger loadExceptionCount = new AtomicInteger();
    @NotNull
    final AtomicLong loadTime = new AtomicLong();
    @NotNull
    final Supplier<Long> evictionCount;
    @NotNull
    final AtomicLong hitCount = new AtomicLong();
    @NotNull
    final AtomicLong missCount = new AtomicLong();

    public SegmentCacheStats(@NotNull String name, @NotNull Supplier<Long> maximumWeight, @NotNull Supplier<Long> elementCount, @NotNull Supplier<Long> currentWeight, @NotNull Supplier<Long> evictionCount) {
        super(name);
        this.maximumWeight = maximumWeight;
        this.elementCount = (Supplier)Preconditions.checkNotNull(elementCount);
        this.currentWeight = (Supplier)Preconditions.checkNotNull(currentWeight);
        this.evictionCount = evictionCount;
    }

    protected CacheStats getCurrentStats() {
        return new CacheStats(this.hitCount.get(), this.missCount.get(), this.loadSuccessCount.get(), (long)this.loadExceptionCount.get(), this.loadTime.get(), this.evictionCount.get().longValue());
    }

    public long getElementCount() {
        return this.elementCount.get();
    }

    public long getMaxTotalWeight() {
        return this.maximumWeight.get();
    }

    public long estimateCurrentWeight() {
        return this.currentWeight.get();
    }
}

