/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.osgi;

import java.io.File;
import java.util.HashMap;
import java.util.Objects;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.segment.file.tar.TarPersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class TarPersistenceService {
    private volatile Registration registration;

    @Activate
    void activate(BundleContext bundleContext, Configuration configuration) {
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(bundleContext);
        String storageDirectory = configuration.storage_directory();
        File directory = new File(storageDirectory);
        TarPersistence tarPersistence = new TarPersistence(directory);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("service.pid", String.format("%s(%s)", TarPersistence.class.getName(), storageDirectory));
        if (!Objects.equals(configuration.role(), "")) {
            properties.put("role", configuration.role());
        }
        this.registration = whiteboard.register(SegmentNodeStorePersistence.class, (Object)tarPersistence, properties);
    }

    @Deactivate
    void deactivate() {
        this.registration.unregister();
    }

    @ObjectClassDefinition(name="Oak TAR segment persistence service", description="Apache Jackrabbit Oak SegmentPersistence implementationused to configure a TAR persistence.")
    public static @interface Configuration {
        @AttributeDefinition(name="Storage Directory", description="Path on the file system where this TAR persistence stores its files.")
        public String storage_directory();

        @AttributeDefinition(name="Role", description="The role of this persistence. It should be unique and may be used to filter services in order to create services composed of multiple persistence instances. E.g. a SplitPersistence composed of a TAR persistence and an Azure persistence.")
        public String role() default "";
    }
}

