/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.plugins.value.jcr.PartialValueFactory;
import org.apache.jackrabbit.oak.security.user.GroupImpl;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.SystemUserImpl;
import org.apache.jackrabbit.oak.security.user.UserImpl;
import org.apache.jackrabbit.oak.security.user.UserProvider;
import org.apache.jackrabbit.oak.security.user.Utils;
import org.apache.jackrabbit.oak.security.user.monitor.UserMonitor;
import org.apache.jackrabbit.oak.security.user.query.UserQueryManager;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipProvider;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipService;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.DefaultAuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.GroupAction;
import org.apache.jackrabbit.oak.spi.security.user.action.UserAction;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagerImpl
implements UserManager {
    private static final Logger log = LoggerFactory.getLogger(UserManagerImpl.class);
    private final Root root;
    private final PartialValueFactory valueFactory;
    private final NamePathMapper namePathMapper;
    private final SecurityProvider securityProvider;
    private final UserProvider userProvider;
    private final MembershipProvider membershipProvider;
    private final ConfigurationParameters config;
    private final AuthorizableActionProvider actionProvider;
    private final UserMonitor monitor;
    private UserQueryManager queryManager;
    private ReadOnlyNodeTypeManager ntMgr;
    private final DynamicMembershipService dynamicMembership;
    private DynamicMembershipProvider dynamicMembershipProvider;

    public UserManagerImpl(@NotNull Root root, @NotNull PartialValueFactory valueFactory, @NotNull SecurityProvider securityProvider, @NotNull UserMonitor monitor, @NotNull DynamicMembershipService dynamicMembershipService) {
        this.root = root;
        this.valueFactory = valueFactory;
        this.namePathMapper = valueFactory.getNamePathMapper();
        this.securityProvider = securityProvider;
        this.monitor = monitor;
        UserConfiguration uc = (UserConfiguration)securityProvider.getConfiguration(UserConfiguration.class);
        this.config = uc.getParameters();
        this.userProvider = new UserProvider(root, this.config);
        this.membershipProvider = new MembershipProvider(root, this.config);
        this.dynamicMembership = dynamicMembershipService;
        this.actionProvider = UserManagerImpl.getActionProvider(this.config);
    }

    @NotNull
    private static AuthorizableActionProvider getActionProvider(@NotNull ConfigurationParameters config) {
        AuthorizableActionProvider actionProvider = (AuthorizableActionProvider)config.getConfigValue("authorizableActionProvider", null, AuthorizableActionProvider.class);
        if (actionProvider == null) {
            actionProvider = new DefaultAuthorizableActionProvider(config);
        }
        return actionProvider;
    }

    @Nullable
    public Authorizable getAuthorizable(@NotNull String id) throws RepositoryException {
        Tree tree = Strings.isNullOrEmpty((String)id) ? null : this.userProvider.getAuthorizable(id);
        return this.getAuthorizable(tree);
    }

    @Nullable
    public <T extends Authorizable> T getAuthorizable(@NotNull String id, @NotNull Class<T> authorizableClass) throws RepositoryException {
        return (T)UserUtil.castAuthorizable((Authorizable)this.getAuthorizable(id), authorizableClass);
    }

    @Nullable
    public Authorizable getAuthorizable(@NotNull Principal principal) throws RepositoryException {
        return principal == null ? null : this.getAuthorizable(this.userProvider.getAuthorizableByPrincipal(principal));
    }

    @Nullable
    public Authorizable getAuthorizableByPath(@NotNull String path) throws RepositoryException {
        String oakPath = this.namePathMapper.getOakPath(path);
        if (oakPath == null) {
            throw new RepositoryException("Invalid path " + path);
        }
        return this.getAuthorizableByOakPath(oakPath);
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull String relPath, @Nullable String value) throws RepositoryException {
        return this.findAuthorizables(relPath, value, 3);
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull String relPath, @Nullable String value, int searchType) throws RepositoryException {
        return this.getQueryManager().findAuthorizables(relPath, value, AuthorizableType.getType((int)searchType));
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull Query query) throws RepositoryException {
        return this.getQueryManager().findAuthorizables(query);
    }

    @NotNull
    public User createUser(@NotNull String userID, @Nullable String password) throws RepositoryException {
        PrincipalImpl principal = new PrincipalImpl(userID);
        return this.createUser(userID, password, (Principal)principal, null);
    }

    @NotNull
    public User createUser(@NotNull String userID, @Nullable String password, @NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        this.checkValidId(userID);
        this.checkValidPrincipal(principal, false);
        if (intermediatePath != null) {
            intermediatePath = this.namePathMapper.getOakPath(intermediatePath);
        }
        Tree userTree = this.userProvider.createUser(userID, intermediatePath);
        this.setPrincipal(userTree, principal);
        if (password != null) {
            this.setPassword(userTree, userID, password, false);
        }
        UserImpl user = new UserImpl(userID, userTree, this);
        this.onCreate(user, password);
        log.debug("User created: {}", (Object)userID);
        return user;
    }

    @NotNull
    public User createSystemUser(@NotNull String userID, @Nullable String intermediatePath) throws RepositoryException {
        this.checkValidId(userID);
        PrincipalImpl principal = new PrincipalImpl(userID);
        this.checkValidPrincipal((Principal)principal, false);
        Tree userTree = this.userProvider.createSystemUser(userID, intermediatePath);
        this.setPrincipal(userTree, (Principal)principal);
        SystemUserImpl user = new SystemUserImpl(userID, userTree, this);
        this.onCreate(user);
        log.debug("System user created: {}", (Object)userID);
        return user;
    }

    @NotNull
    public Group createGroup(@NotNull String groupId) throws RepositoryException {
        PrincipalImpl principal = new PrincipalImpl(groupId);
        return this.createGroup(groupId, (Principal)principal, null);
    }

    @NotNull
    public Group createGroup(@NotNull Principal principal) throws RepositoryException {
        return this.createGroup(principal, null);
    }

    @NotNull
    public Group createGroup(@NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        return this.createGroup(principal.getName(), principal, intermediatePath);
    }

    @NotNull
    public Group createGroup(@NotNull String groupID, @NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        this.checkValidId(groupID);
        this.checkValidPrincipal(principal, true);
        if (intermediatePath != null) {
            intermediatePath = this.namePathMapper.getOakPath(intermediatePath);
        }
        Tree groupTree = this.userProvider.createGroup(groupID, intermediatePath);
        this.setPrincipal(groupTree, principal);
        GroupImpl group = new GroupImpl(groupID, groupTree, this);
        this.onCreate(group);
        log.debug("Group created: {}", (Object)groupID);
        return group;
    }

    public boolean isAutoSave() {
        return false;
    }

    public void autoSave(boolean enable) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("Session#save() is always required.");
    }

    void onCreate(@NotNull User user, @Nullable String password) throws RepositoryException {
        if (!user.isSystemUser()) {
            for (AuthorizableAction action : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
                action.onCreate(user, password, this.root, this.namePathMapper);
            }
        } else {
            log.warn("onCreate(User,String) called for system user. Use onCreate(User) instead.");
        }
    }

    void onCreate(@NotNull User systemUser) throws RepositoryException {
        Preconditions.checkArgument((boolean)systemUser.isSystemUser());
        for (AuthorizableAction action : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
            action.onCreate(systemUser, this.root, this.namePathMapper);
        }
    }

    void onCreate(@NotNull Group group) throws RepositoryException {
        for (AuthorizableAction action : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
            action.onCreate(group, this.root, this.namePathMapper);
        }
    }

    void onRemove(@NotNull Authorizable authorizable) throws RepositoryException {
        for (AuthorizableAction action : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
            action.onRemove(authorizable, this.root, this.namePathMapper);
        }
    }

    void onPasswordChange(@NotNull User user, @NotNull String password) throws RepositoryException {
        for (AuthorizableAction action : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
            action.onPasswordChange(user, password, this.root, this.namePathMapper);
        }
    }

    void onDisable(@NotNull User user, @Nullable String disableReason) throws RepositoryException {
        for (UserAction action : this.filterUserActions()) {
            action.onDisable(user, disableReason, this.root, this.namePathMapper);
        }
    }

    void onImpersonation(@NotNull User user, @NotNull Principal principal, boolean granting) throws RepositoryException {
        for (UserAction action : this.filterUserActions()) {
            if (granting) {
                action.onGrantImpersonation(user, principal, this.root, this.namePathMapper);
                continue;
            }
            action.onRevokeImpersonation(user, principal, this.root, this.namePathMapper);
        }
    }

    void onGroupUpdate(@NotNull Group group, boolean isRemove, @NotNull Authorizable member) throws RepositoryException {
        for (GroupAction action : this.filterGroupActions()) {
            if (isRemove) {
                action.onMemberRemoved(group, member, this.root, this.namePathMapper);
                continue;
            }
            action.onMemberAdded(group, member, this.root, this.namePathMapper);
        }
    }

    void onGroupUpdate(@NotNull Group group, boolean isRemove, boolean isContentId, @NotNull Set<String> memberIds, @NotNull Set<String> failedIds) throws RepositoryException {
        for (GroupAction action : this.filterGroupActions()) {
            if (isRemove) {
                action.onMembersRemoved(group, memberIds, failedIds, this.root, this.namePathMapper);
                continue;
            }
            if (isContentId) {
                action.onMembersAddedContentId(group, memberIds, failedIds, this.root, this.namePathMapper);
                continue;
            }
            action.onMembersAdded(group, memberIds, failedIds, this.root, this.namePathMapper);
        }
    }

    @Nullable
    public Authorizable getAuthorizable(@Nullable Tree tree) throws RepositoryException {
        if (tree == null || !tree.exists()) {
            return null;
        }
        String id = UserUtil.getAuthorizableId((Tree)tree);
        if (id == null) {
            return null;
        }
        if (UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.USER)) {
            if (UserUtil.isSystemUser((Tree)tree)) {
                return new SystemUserImpl(id, tree, this);
            }
            return new UserImpl(id, tree, this);
        }
        return new GroupImpl(id, tree, this);
    }

    @Nullable
    Authorizable getAuthorizableByOakPath(@NotNull String oakPath) throws RepositoryException {
        return this.getAuthorizable(this.userProvider.getAuthorizableByPath(oakPath));
    }

    @NotNull
    NamePathMapper getNamePathMapper() {
        return this.namePathMapper;
    }

    @NotNull
    PartialValueFactory getPartialValueFactory() {
        return this.valueFactory;
    }

    @NotNull
    ReadOnlyNodeTypeManager getNodeTypeManager() {
        if (this.ntMgr == null) {
            this.ntMgr = ReadOnlyNodeTypeManager.getInstance(this.root, NamePathMapper.DEFAULT);
        }
        return this.ntMgr;
    }

    @NotNull
    MembershipProvider getMembershipProvider() {
        return this.membershipProvider;
    }

    @NotNull
    DynamicMembershipProvider getDynamicMembershipProvider() {
        if (this.dynamicMembershipProvider == null) {
            this.dynamicMembershipProvider = this.dynamicMembership.getDynamicMembershipProvider(this.root, (UserManager)this, this.namePathMapper);
        }
        return this.dynamicMembershipProvider;
    }

    @NotNull
    PrincipalManager getPrincipalManager() {
        return ((PrincipalConfiguration)this.securityProvider.getConfiguration(PrincipalConfiguration.class)).getPrincipalManager(this.root, this.namePathMapper);
    }

    @NotNull
    UserMonitor getMonitor() {
        return this.monitor;
    }

    @NotNull
    ConfigurationParameters getConfig() {
        return this.config;
    }

    private void checkValidId(@Nullable String id) throws RepositoryException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Invalid ID " + id);
        }
        if (this.getAuthorizable(id) != null) {
            throw new AuthorizableExistsException("Authorizable with ID " + id + " already exists");
        }
    }

    void checkValidPrincipal(@Nullable Principal principal, boolean isGroup) throws RepositoryException {
        if (principal == null || Strings.isNullOrEmpty((String)principal.getName())) {
            throw new IllegalArgumentException("Principal may not be null and must have a valid name.");
        }
        if (!isGroup && "everyone".equals(principal.getName())) {
            throw new IllegalArgumentException("'everyone' is a reserved group principal name.");
        }
        if (this.getAuthorizable(principal) != null) {
            throw new AuthorizableExistsException("Authorizable with principal " + principal.getName() + " already exists.");
        }
    }

    void setPrincipal(@NotNull Tree authorizableTree, @NotNull Principal principal) {
        authorizableTree.setProperty("rep:principalName", (Object)principal.getName());
    }

    void setPassword(@NotNull Tree userTree, @NotNull String userId, @NotNull String password, boolean isImport) throws RepositoryException {
        String pwHash;
        if (!isImport || PasswordUtil.isPlainTextPassword((String)password)) {
            try {
                pwHash = PasswordUtil.buildPasswordHash((String)password, (ConfigurationParameters)this.config);
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                throw new RepositoryException((Throwable)e);
            }
        } else {
            pwHash = password;
        }
        userTree.setProperty("rep:password", (Object)pwHash);
        if (Utils.canHavePasswordExpired(userId, this.config) && this.setPasswordLastModified(userTree, isImport)) {
            Tree pwdTree = TreeUtil.getOrAddChild((Tree)userTree, (String)"rep:pwd", (String)"rep:Password");
            pwdTree.setProperty("rep:passwordLastModified", (Object)System.currentTimeMillis(), Type.LONG);
        }
    }

    private boolean setPasswordLastModified(@NotNull Tree userTree, boolean isImport) {
        if (this.forceInitialPasswordChangeEnabled()) {
            return !isImport && userTree.getStatus() != Tree.Status.NEW;
        }
        if (this.passwordExpiryEnabled()) {
            return !isImport || userTree.getStatus() == Tree.Status.NEW;
        }
        return false;
    }

    private boolean passwordExpiryEnabled() {
        return (Integer)this.config.getConfigValue("passwordMaxAge", (Object)0) > 0;
    }

    private boolean forceInitialPasswordChangeEnabled() {
        return (Boolean)this.config.getConfigValue("initialPasswordChange", (Object)false);
    }

    @NotNull
    private UserQueryManager getQueryManager() {
        if (this.queryManager == null) {
            this.queryManager = new UserQueryManager(this, this.namePathMapper, this.config, this.root);
        }
        return this.queryManager;
    }

    @NotNull
    private Iterable<GroupAction> filterGroupActions() {
        return Iterables.filter((Iterable)this.actionProvider.getAuthorizableActions(this.securityProvider), GroupAction.class);
    }

    @NotNull
    private Iterable<UserAction> filterUserActions() {
        return Iterables.filter((Iterable)this.actionProvider.getAuthorizableActions(this.securityProvider), UserAction.class);
    }
}

