/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.jetbrains.annotations.NotNull;

class TreeBasedPrincipal
extends PrincipalImpl
implements ItemBasedPrincipal {
    private final String path;
    private final NamePathMapper pathMapper;

    TreeBasedPrincipal(@NotNull String principalName, @NotNull Tree tree, @NotNull NamePathMapper pathMapper) {
        this(principalName, tree.getPath(), pathMapper);
    }

    TreeBasedPrincipal(@NotNull String principalName, @NotNull String oakPath, @NotNull NamePathMapper pathMapper) {
        super(principalName);
        this.pathMapper = pathMapper;
        this.path = oakPath;
    }

    @NotNull
    String getOakPath() throws RepositoryException {
        return this.path;
    }

    @NotNull
    NamePathMapper getNamePathMapper() {
        return this.pathMapper;
    }

    @NotNull
    public String getPath() throws RepositoryException {
        return this.pathMapper.getJcrPath(this.path);
    }
}

