/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.progress;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.index.NodeTraversalCallback;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProgressTrackingEditor
implements Editor,
NodeTraversalCallback.PathSource {
    private final Editor editor;
    private final NodeTraversalCallback traversalCallback;
    private final ProgressTrackingEditor parent;
    private final String name;

    public ProgressTrackingEditor(Editor editor, String name, NodeTraversalCallback traversalCallback) {
        this.editor = editor;
        this.name = name;
        this.traversalCallback = traversalCallback;
        this.parent = null;
    }

    private ProgressTrackingEditor(Editor editor, String name, NodeTraversalCallback callback, ProgressTrackingEditor parent) {
        this.editor = editor;
        this.name = name;
        this.traversalCallback = callback;
        this.parent = parent;
    }

    @Nullable
    public static Editor wrap(@Nullable Editor editor, NodeTraversalCallback onProgress) {
        if (editor != null && !(editor instanceof ProgressTrackingEditor)) {
            return new ProgressTrackingEditor(editor, "/", onProgress);
        }
        return editor;
    }

    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        this.traversalCallback.traversedNode(this);
        this.editor.enter(before, after);
    }

    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        this.editor.leave(before, after);
    }

    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.editor.propertyAdded(after);
    }

    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        this.editor.propertyChanged(before, after);
    }

    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        this.editor.propertyDeleted(before);
    }

    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        return this.createChildEditor(this.editor.childNodeAdded(name, after), name);
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return this.createChildEditor(this.editor.childNodeChanged(name, before, after), name);
    }

    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        return this.createChildEditor(this.editor.childNodeDeleted(name, before), name);
    }

    @Override
    public String getPath() {
        if (this.parent == null) {
            return "/";
        }
        StringBuilder sb = new StringBuilder(128);
        this.buildPath(sb);
        return sb.toString();
    }

    private void buildPath(@NotNull StringBuilder sb) {
        if (this.parent != null) {
            this.parent.buildPath(sb);
            sb.append('/').append(this.name);
        }
    }

    private ProgressTrackingEditor createChildEditor(Editor editor, String name) {
        if (editor == null) {
            return null;
        }
        return new ProgressTrackingEditor(editor, name, this.traversalCallback, this);
    }
}

