/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexUtils {
    private IndexUtils() {
    }

    public static NodeBuilder getOrCreateOakIndex(NodeBuilder root) {
        NodeBuilder index;
        if (!root.hasChildNode("oak:index")) {
            index = root.child("oak:index");
            index.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        } else {
            index = root.child("oak:index");
        }
        return index;
    }

    public static NodeBuilder createIndexDefinition(@NotNull NodeBuilder index, @NotNull String indexDefName, boolean reindex, boolean unique, @NotNull Collection<String> propertyNames, @Nullable Collection<String> declaringNodeTypeNames) {
        NodeBuilder entry = index.child(indexDefName).setProperty("jcr:primaryType", (Object)"oak:QueryIndexDefinition", Type.NAME).setProperty("type", (Object)"property").setProperty("reindex", (Object)reindex);
        if (unique) {
            entry.setProperty("unique", (Object)unique);
        }
        entry.setProperty(PropertyStates.createProperty((String)"propertyNames", propertyNames, (Type)Type.NAMES));
        if (declaringNodeTypeNames != null && !declaringNodeTypeNames.isEmpty()) {
            entry.setProperty(PropertyStates.createProperty((String)"declaringNodeTypes", declaringNodeTypeNames, (Type)Type.NAMES));
        }
        return entry;
    }

    public static Tree createIndexDefinition(@NotNull Tree indexNode, @NotNull String indexDefName, boolean unique, @NotNull String[] propertyNames, String ... declaringNodeTypeNames) throws RepositoryException {
        return IndexUtils.createIndexDefinition(indexNode, indexDefName, unique, (Collection<String>)ImmutableList.copyOf((Object[])propertyNames), (Collection<String>)ImmutableList.copyOf((Object[])declaringNodeTypeNames), "property", null);
    }

    public static Tree createIndexDefinition(@NotNull Tree indexNode, @NotNull String indexDefName, boolean unique, @NotNull Collection<String> propertyNames, @Nullable Collection<String> declaringNodeTypeNames, @NotNull String propertyIndexType, @Nullable Map<String, String> properties) throws RepositoryException {
        Tree entry = TreeUtil.getOrAddChild((Tree)indexNode, (String)indexDefName, (String)"oak:QueryIndexDefinition");
        entry.setProperty("type", (Object)propertyIndexType);
        entry.setProperty("reindex", (Object)true);
        if (unique) {
            entry.setProperty("unique", (Object)true);
        }
        if (declaringNodeTypeNames != null && declaringNodeTypeNames.size() > 0) {
            entry.setProperty("declaringNodeTypes", declaringNodeTypeNames, Type.NAMES);
        }
        entry.setProperty("propertyNames", propertyNames, Type.NAMES);
        if (properties != null) {
            for (String k : properties.keySet()) {
                entry.setProperty(k, (Object)properties.get(k));
            }
        }
        return entry;
    }

    public static void createReferenceIndex(@NotNull NodeBuilder index) {
        index.child("reference").setProperty("jcr:primaryType", (Object)"oak:QueryIndexDefinition", Type.NAME).setProperty("type", (Object)"reference").setProperty("info", (Object)"Oak index for reference lookup.");
    }

    public static boolean isIndexNodeType(NodeState state) {
        PropertyState ps = state.getProperty("jcr:primaryType");
        return ps != null && ((String)ps.getValue(Type.STRING)).equals("oak:QueryIndexDefinition");
    }

    public static boolean isIndexNodeType(NodeState state, String typeIn) {
        if (!IndexUtils.isIndexNodeType(state)) {
            return false;
        }
        PropertyState type = state.getProperty("type");
        return type != null && !type.isArray() && ((String)type.getValue(Type.STRING)).equals(typeIn);
    }

    public static NodeBuilder createIndexDefinition(@NotNull NodeBuilder indexNode, @NotNull String indexDefName, boolean unique, @NotNull Iterable<String> propertyNames, @Nullable String[] declaringNodeTypeNames, @NotNull String propertyIndexType, Map<String, String> properties) throws RepositoryException {
        NodeBuilder entry = indexNode.child(indexDefName).setProperty("jcr:primaryType", (Object)"oak:QueryIndexDefinition", Type.NAME).setProperty("type", (Object)propertyIndexType).setProperty("reindex", (Object)false);
        if (unique) {
            entry.setProperty("unique", (Object)unique);
        }
        entry.setProperty(PropertyStates.createProperty((String)"propertyNames", propertyNames, (Type)Type.NAMES));
        if (declaringNodeTypeNames != null && declaringNodeTypeNames.length > 0) {
            entry.setProperty(PropertyStates.createProperty((String)"declaringNodeTypes", (Object)declaringNodeTypeNames, (Type)Type.NAMES));
        }
        if (properties != null) {
            for (String k : properties.keySet()) {
                entry.setProperty(k, (Object)properties.get(k));
            }
        }
        return entry;
    }

    @Nullable
    public static String getAsyncLaneName(NodeState idxState, String indexPath) {
        return IndexUtils.getAsyncLaneName(idxState, indexPath, idxState.getProperty("async"));
    }

    @Nullable
    public static String getAsyncLaneName(NodeState idxState, String indexPath, PropertyState async) {
        if (async != null) {
            HashSet asyncNames = Sets.newHashSet((Iterable)((Iterable)async.getValue(Type.STRINGS)));
            asyncNames.remove("nrt");
            asyncNames.remove("sync");
            Preconditions.checkArgument((!asyncNames.isEmpty() ? 1 : 0) != 0, (String)"No valid async name found for index [%s], definition %s", (Object)indexPath, (Object)idxState);
            return (String)Iterables.getOnlyElement((Iterable)asyncNames);
        }
        return null;
    }

    @NotNull
    public static String getCaller(@Nullable String[] ignoredJavaPackages) {
        StackTraceElement[] callStack;
        if (ignoredJavaPackages == null || ignoredJavaPackages.length == 0) {
            return "(<function not configured>)";
        }
        for (StackTraceElement stackFrame : callStack = Thread.currentThread().getStackTrace()) {
            String classAndMethod = stackFrame.getClassName() + "." + stackFrame.getMethodName();
            if (!Stream.of(ignoredJavaPackages).noneMatch(classAndMethod::startsWith)) continue;
            return classAndMethod;
        }
        return "(internal)";
    }
}

