/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.cancel;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.segment.file.cancel.Cancellation;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;

class TimeoutCanceller
extends Canceller {
    private final Canceller parent;
    private final String reason;
    private final long expiration;

    TimeoutCanceller(Canceller parent, String reason, long duration, TimeUnit unit) {
        this.parent = parent;
        this.reason = reason;
        this.expiration = System.currentTimeMillis() + unit.toMillis(duration);
    }

    @Override
    public Cancellation check() {
        if (System.currentTimeMillis() > this.expiration) {
            return new Cancellation(true, this.reason);
        }
        return this.parent.check();
    }
}

