/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class NotifyingFutureTask
extends FutureTask<Void> {
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private volatile Runnable onComplete;
    private static final Runnable NOP = new Runnable(){

        @Override
        public void run() {
        }
    };

    public NotifyingFutureTask(Callable<Void> callable) {
        super(callable);
    }

    public NotifyingFutureTask(Runnable task) {
        super(task, null);
    }

    public void onComplete(Runnable onComplete) {
        this.onComplete = onComplete;
        if (this.isDone()) {
            this.run(onComplete);
        }
    }

    @Override
    protected void done() {
        this.run(this.onComplete);
    }

    private void run(Runnable onComplete) {
        if (onComplete != null && this.completed.compareAndSet(false, true)) {
            onComplete.run();
        }
    }

    public static NotifyingFutureTask completed() {
        NotifyingFutureTask f = new NotifyingFutureTask(NOP);
        f.run();
        return f;
    }
}

