/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.adapters;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ZonedDateTimeAdapter
extends XmlAdapter<String, ZonedDateTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_DATE_TIME;
    private static final DateTimeFormatter OUTPUT_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendInstant(3).toFormatter();

    public ZonedDateTime unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = null;
        try {
            zonedDateTime = ZonedDateTime.parse(v, FORMATTER);
        }
        catch (DateTimeException e) {
            LocalDateTime dt = LocalDateTime.parse(v, FORMATTER);
            zonedDateTime = dt.atZone(ZoneId.systemDefault());
        }
        return zonedDateTime;
    }

    public String marshal(ZonedDateTime v) throws Exception {
        if (v == null) {
            return null;
        }
        return OUTPUT_FORMATTER.format(v);
    }
}

