/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalorganizer.socialnetwork;

import java.util.Date;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.personalorganizer.model.Schedulable;
import org.silverpeas.core.socialnetwork.model.AbstractSocialInformation;
import org.silverpeas.core.socialnetwork.model.SocialInformationType;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.URLUtil;

public class SocialInformationEvent
extends AbstractSocialInformation {
    private String classification = "public";
    private Schedulable schedulable = null;

    public SocialInformationEvent(Schedulable schedulable) {
        this(schedulable, true);
    }

    public SocialInformationEvent(Schedulable schedulable, boolean isMyEvent) {
        super(new ResourceReference(schedulable.getId(), schedulable.getName()));
        this.schedulable = schedulable;
        this.classification = schedulable.getClassification().getString();
        if (schedulable.getEndDate().after(new Date())) {
            this.setType(SocialInformationType.EVENT.toString());
        } else {
            this.setType(SocialInformationType.LASTEVENT.toString());
        }
        this.setUpdated(isMyEvent);
    }

    public String getIcon() {
        if ("private".equals(this.classification)) {
            return SocialInformationType.EVENT + "_private.gif";
        }
        return SocialInformationType.EVENT + "_public.gif";
    }

    public String getTitle() {
        return this.schedulable.getName();
    }

    public String getDescription() {
        return this.schedulable.getDescription();
    }

    public String getAuthor() {
        return this.schedulable.getDelegatorId();
    }

    public String getUrl() {
        if (this.isUpdated()) {
            return URLUtil.getURL((String)"agenda", null, null) + "SelectDay?Day=" + DateUtil.getInputDate((Date)this.getDate(), (String)"FR");
        }
        return URLUtil.getURL((String)"agenda", null, null) + "ViewOtherAgenda?Id=" + this.getAuthor();
    }

    public Date getDate() {
        return this.schedulable.getStartDate();
    }
}

