/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.model;

import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.admin.user.model.User;

public class ValidatorsList
extends ArrayList<String> {
    private int validationType;

    public ValidatorsList(int validationType) {
        this.validationType = validationType;
    }

    public ValidatorsList(List<String> userIds) {
        this.addAll(userIds);
    }

    public boolean isTargetedValidation() {
        return this.validationType == 1 || this.validationType == 2;
    }

    public boolean isClassicValidation() {
        return this.validationType == 0;
    }

    public boolean isCollegiateValidation() {
        return this.validationType == 3;
    }

    public int getValidationType() {
        return this.validationType;
    }

    public String[] getUserIds() {
        return this.toArray(new String[0]);
    }

    public boolean isAtLeastOnceValidatorActive() {
        return !this.isEmpty();
    }

    public boolean isAtLeastOnceTargetedValidatorActive() {
        return this.isTargetedValidation() && this.isAtLeastOnceValidatorActive();
    }

    public boolean isValidationOperational() {
        return this.isAtLeastOnceValidatorActive();
    }

    public String getValidatorNames() {
        StringBuilder validatorNames = new StringBuilder();
        for (String valId : this) {
            if (validatorNames.length() > 0) {
                validatorNames.append(", ");
            }
            validatorNames.append(User.getById((String)valId).getDisplayedName());
        }
        return validatorNames.toString();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

