/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.components.datawarning.DataWarningException;
import org.silverpeas.components.datawarning.model.DataWarning;
import org.silverpeas.components.datawarning.model.DataWarningDataManager;
import org.silverpeas.components.datawarning.model.DataWarningGroup;
import org.silverpeas.components.datawarning.model.DataWarningQuery;
import org.silverpeas.components.datawarning.model.DataWarningQueryResult;
import org.silverpeas.components.datawarning.model.DataWarningResult;
import org.silverpeas.components.datawarning.model.DataWarningScheduler;
import org.silverpeas.components.datawarning.model.DataWarningUser;
import org.silverpeas.components.datawarning.service.DataWarningSchedulerTable;
import org.silverpeas.kernel.logging.SilverLogger;

public final class DataWarningEngine {
    private final String componentId;
    private final DataWarningDataManager dataManager = new DataWarningDataManager();
    private DataWarning dataWarning = null;
    private DataWarningScheduler dataScheduler = null;
    private Map<Integer, DataWarningQuery> dataWarningQueries = null;

    public DataWarningEngine(String cid) throws DataWarningException {
        this.componentId = cid;
        this.init();
    }

    public void init() throws DataWarningException {
        this.dataWarning = this.dataManager.getDataWarning(this.componentId);
        this.dataScheduler = this.dataManager.getDataWarningScheduler(this.componentId);
        Collection<DataWarningQuery> queries = this.dataManager.getDataWarningQueries(this.componentId);
        this.dataWarningQueries = Collections.synchronizedMap(new HashMap());
        for (DataWarningQuery query : queries) {
            this.dataWarningQueries.put(query.getType(), query);
        }
    }

    public DataWarningResult run() {
        DataWarningResult valret = null;
        switch (this.dataWarning.getAnalysisType()) {
            case 0: {
                valret = this.executeInconditionalQuery();
                break;
            }
            case 1: {
                valret = this.triggerAnalysisQuery();
                break;
            }
        }
        return valret;
    }

    private DataWarningResult triggerAnalysisQuery() {
        DataWarningQueryResult theResult = null;
        DataWarningQuery theQuery = null;
        DataWarningResult valret = new DataWarningResult(true);
        valret.setTriggerQuery(this.getDataWarningQuery(1));
        valret.computeTriggerResult(this.dataWarning);
        if (valret.getTriggerEnabled() && !(theQuery = this.getDataWarningQuery(0)).getQuery().isEmpty()) {
            theResult = theQuery.executeQuery(this.dataWarning);
        }
        valret.setDataQuery(theQuery);
        valret.setQueryResult(theResult);
        return valret;
    }

    private DataWarningResult executeInconditionalQuery() {
        DataWarningResult valret = new DataWarningResult(false);
        DataWarningQuery theQuery = this.getDataWarningQuery(0);
        DataWarningQueryResult theResult = theQuery.executeQuery(this.dataWarning);
        valret.setDataQuery(theQuery);
        valret.setQueryResult(theResult);
        return valret;
    }

    public void updateDataWarning(DataWarning dw) throws DataWarningException {
        if (this.dataWarning.getAnalysisType() != dw.getAnalysisType()) {
            this.stopScheduler();
            this.deleteDataQueries();
            switch (dw.getAnalysisType()) {
                case 0: {
                    this.createDataWarningQuery(0);
                    break;
                }
                case 1: {
                    this.createDataWarningQuery(0);
                    this.createDataWarningQuery(1);
                    break;
                }
            }
        }
        this.dataManager.updateDataWarning(dw);
        this.dataWarning = this.dataManager.getDataWarning(this.componentId);
        this.restartSchedulerIfNeeded();
    }

    public DataWarning getDataWarning() {
        return this.dataWarning;
    }

    public DataWarning getDataWarningWritable() {
        return this.dataWarning.copy();
    }

    private void createDataWarningQuery(int queryType) throws DataWarningException {
        DataWarningQuery dwq = new DataWarningQuery();
        dwq.setInstanceId(this.componentId);
        dwq.setType(queryType);
        this.dataManager.createDataWarningQuery(dwq);
        this.dataWarningQueries.put(queryType, dwq);
        this.restartSchedulerIfNeeded();
    }

    private void deleteDataQueries() throws DataWarningException {
        this.dataManager.deleteDataWarningQuery(this.componentId);
        this.restartSchedulerIfNeeded();
    }

    public void updateDataWarningQuery(DataWarningQuery dwq) throws DataWarningException {
        this.dataManager.updateDataWarningQuery(dwq);
        this.dataWarningQueries.put(dwq.getType(), dwq);
        this.restartSchedulerIfNeeded();
    }

    public DataWarningQuery getDataWarningQuery(int queryType) {
        return this.dataWarningQueries.get(queryType);
    }

    public void updateDataWarningScheduler(DataWarningScheduler dws) throws DataWarningException {
        dws.setWakeUp(0L);
        this.dataManager.updateDataWarningScheduler(dws);
        this.dataScheduler = this.dataManager.getDataWarningScheduler(this.componentId);
        this.restartSchedulerIfNeeded();
    }

    public void updateSchedulerWakeUp(long nextTime) {
        try {
            this.dataScheduler = this.dataManager.getDataWarningScheduler(this.componentId);
            this.dataScheduler.setWakeUp(nextTime);
            this.dataManager.updateDataWarningScheduler(this.dataScheduler);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public DataWarningScheduler getDataWarningScheduler() {
        return this.dataScheduler;
    }

    public void restartSchedulerIfNeeded() {
        if (this.dataScheduler.getSchedulerState() == 1) {
            DataWarningSchedulerTable.removeScheduler(this.componentId);
            DataWarningSchedulerTable.addScheduler(this.componentId);
        }
    }

    public void startScheduler() throws DataWarningException {
        this.dataScheduler.setSchedulerState(1);
        this.updateDataWarningScheduler(this.dataScheduler);
        DataWarningSchedulerTable.addScheduler(this.componentId);
    }

    public void stopScheduler() throws DataWarningException {
        DataWarningSchedulerTable.removeScheduler(this.componentId);
        this.dataScheduler.setSchedulerState(0);
        this.updateDataWarningScheduler(this.dataScheduler);
    }

    public void createDataWarningGroup(DataWarningGroup dwg) throws DataWarningException {
        this.dataManager.createDataWarningGroup(dwg);
        this.restartSchedulerIfNeeded();
    }

    public void deleteDataWarningGroup(int groupId) throws DataWarningException {
        this.dataManager.deleteDataWarningGroup(this.componentId, groupId);
        this.restartSchedulerIfNeeded();
    }

    public void deleteDataWarningGroups() throws DataWarningException {
        this.dataManager.deleteDataWarningGroups(this.componentId);
        this.restartSchedulerIfNeeded();
    }

    public void updateDataWarningGroup(DataWarningGroup dwg) throws DataWarningException {
        this.dataManager.updateDataWarningGroup(dwg);
        this.restartSchedulerIfNeeded();
    }

    public Collection<DataWarningGroup> getDataWarningGroups() throws DataWarningException {
        return this.dataManager.getDataWarningGroups(this.componentId);
    }

    public DataWarningGroup getDataWarningGroup(int groupId) throws DataWarningException {
        return this.dataManager.getDataWarningGroup(this.componentId, groupId);
    }

    public void createDataWarningUser(DataWarningUser dwu) throws DataWarningException {
        this.dataManager.createDataWarningUser(dwu);
        this.restartSchedulerIfNeeded();
    }

    public void deleteDataWarningUser(DataWarningUser dwu) throws DataWarningException {
        this.dataManager.deleteDataWarningUser(dwu.getInstanceId(), dwu.getUserId());
        this.restartSchedulerIfNeeded();
    }

    public void deleteDataWarningUsers() throws DataWarningException {
        this.dataManager.deleteDataWarningUsers(this.componentId);
        this.restartSchedulerIfNeeded();
    }

    public void updateDataWarningUser(DataWarningUser dwu) throws DataWarningException {
        this.dataManager.updateDataWarningUser(dwu);
        this.restartSchedulerIfNeeded();
    }

    public Collection<DataWarningUser> getDataWarningUsers() throws DataWarningException {
        return this.dataManager.getDataWarningUsers(this.componentId);
    }

    public DataWarningUser getDataWarningUser(String userId) throws DataWarningException {
        return this.dataManager.getDataWarningUser(this.componentId, userId);
    }
}

