/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.sort;

import org.gradle.internal.classpath.Instrumented;

public final class StringSizeEstimator {
    private static final int OBJ_HEADER;
    private static final int ARR_HEADER;
    private static final int INT_FIELDS = 12;
    private static final int OBJ_REF;
    private static final int OBJ_OVERHEAD;
    private static final boolean IS_64_BIT_JVM;

    private StringSizeEstimator() {
    }

    public static long estimatedSizeOf(String s) {
        return s.length() * 2 + OBJ_OVERHEAD;
    }

    static {
        boolean is64Bit = true;
        String arch = Instrumented.systemProperty((String)"sun.arch.data.model", (String)"org.apache.jackrabbit.oak.commons.sort.StringSizeEstimator");
        if (arch != null && arch.indexOf("32") != -1) {
            is64Bit = false;
        }
        OBJ_HEADER = (IS_64_BIT_JVM = is64Bit) ? 16 : 8;
        ARR_HEADER = IS_64_BIT_JVM ? 24 : 12;
        OBJ_REF = IS_64_BIT_JVM ? 8 : 4;
        OBJ_OVERHEAD = OBJ_HEADER + 12 + OBJ_REF + ARR_HEADER;
    }
}

