/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.organizationchart.model;

import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.components.organizationchart.model.OrganizationalRole;
import org.silverpeas.components.organizationchart.model.PersonCategory;

public class OrganizationalPerson
implements Comparable<OrganizationalPerson> {
    private int id;
    private int parentId;
    private String name;
    private String fonction;
    private String description;
    private String service;
    private String silverpeasAccount;
    private String firstName;
    private String lastName;
    private Map<String, String> detail;
    private boolean visibleOnCenter = false;
    private OrganizationalRole visibleCenterRole = null;
    private boolean visibleOnRight = false;
    private OrganizationalRole visibleRightRole = null;
    private boolean visibleOnLeft = false;
    private OrganizationalRole visibleLeftRole = null;
    private PersonCategory visibleCategory = null;

    public OrganizationalPerson(int id, int parentId, String name, String fonction, String description, String service, String silverpeasAccount) {
        this.id = id;
        this.parentId = parentId;
        this.name = name;
        this.fonction = fonction;
        this.description = description;
        this.service = service;
        this.setSilverpeasAccount(silverpeasAccount);
        this.parentId = -1;
    }

    public String toString() {
        return "cn = " + this.name + ", service = " + this.service + ", fonction = " + this.fonction;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public String getService() {
        return this.service;
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public String getName() {
        return this.name;
    }

    public String getFonction() {
        return this.fonction;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDetail(Map<String, String> detail) {
        this.detail = detail;
    }

    public Map<String, String> getDetail() {
        return this.detail;
    }

    public boolean isVisibleOnCenter() {
        return this.visibleOnCenter;
    }

    public void setVisibleOnCenter(boolean visibleOnCenter) {
        this.visibleOnCenter = visibleOnCenter;
    }

    public boolean isVisibleOnRight() {
        return this.visibleOnRight;
    }

    public void setVisibleOnRight(boolean visibleOnRight) {
        this.visibleOnRight = visibleOnRight;
    }

    public boolean isVisibleOnLeft() {
        return this.visibleOnLeft;
    }

    public void setVisibleOnLeft(boolean visibleOnLeft) {
        this.visibleOnLeft = visibleOnLeft;
    }

    public PersonCategory getVisibleCategory() {
        return this.visibleCategory;
    }

    public void setVisibleCategory(PersonCategory visibleCategory) {
        this.visibleCategory = visibleCategory;
    }

    public OrganizationalRole getVisibleCenterRole() {
        return this.visibleCenterRole;
    }

    public void setVisibleCenterRole(OrganizationalRole visibleCenterRole) {
        this.visibleCenterRole = visibleCenterRole;
    }

    public OrganizationalRole getVisibleRightRole() {
        return this.visibleRightRole;
    }

    public void setVisibleRightRole(OrganizationalRole visibleRightRole) {
        this.visibleRightRole = visibleRightRole;
    }

    public OrganizationalRole getVisibleLeftRole() {
        return this.visibleLeftRole;
    }

    public void setVisibleLeftRole(OrganizationalRole visibleLeftRole) {
        this.visibleLeftRole = visibleLeftRole;
    }

    public void setSilverpeasAccount(String silverpeasAccount) {
        this.silverpeasAccount = silverpeasAccount;
    }

    public String getSilverpeasAccount() {
        return this.silverpeasAccount;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public int compareTo(OrganizationalPerson other) {
        int compare = this.lastName.compareToIgnoreCase(other.getLastName());
        if (compare != 0) {
            return compare;
        }
        return this.firstName.compareToIgnoreCase(other.getFirstName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrganizationalPerson)) {
            return false;
        }
        OrganizationalPerson that = (OrganizationalPerson)o;
        if (this.id != that.id) {
            return false;
        }
        return this.parentId == that.parentId;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getId()).append(this.getParentId()).toHashCode();
    }
}

