/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.service;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import org.silverpeas.components.forums.model.Forum;
import org.silverpeas.components.forums.model.ForumPK;
import org.silverpeas.components.forums.service.ForumService;
import org.silverpeas.core.contribution.ContributionLocatorByLocalIdAndType;
import org.silverpeas.core.contribution.model.ContributionIdentifier;

@Named
public class ForumsContributionLocator
implements ContributionLocatorByLocalIdAndType {
    private static final List<String> HANDLED_TYPES = Collections.singletonList("Forum");

    public boolean isContributionLocatorOfType(String type) {
        return HANDLED_TYPES.contains(type);
    }

    public Optional<ContributionIdentifier> getContributionIdentifierFromLocalIdAndType(String localId, String type) {
        if ("Forum".equals(type)) {
            ForumService service = ForumService.get();
            String instanceId = service.getForumInstanceId(Integer.parseInt(localId));
            return Optional.ofNullable(service.getForum(new ForumPK(instanceId, localId))).map(Forum::getIdentifier);
        }
        return Optional.empty();
    }
}

