/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.model;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.mailinglist.service.model.MessageIndexer;
import org.silverpeas.components.mailinglist.service.model.MessageService;
import org.silverpeas.components.mailinglist.service.model.beans.Activity;
import org.silverpeas.components.mailinglist.service.model.beans.MailingList;
import org.silverpeas.components.mailinglist.service.model.beans.MailingListActivity;
import org.silverpeas.components.mailinglist.service.model.beans.Message;
import org.silverpeas.components.mailinglist.service.model.dao.MessageDao;
import org.silverpeas.components.mailinglist.service.util.OrderBy;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.personalorganizer.model.ToDoHeader;
import org.silverpeas.core.personalorganizer.service.CalendarRuntimeException;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Transactional
public class MessageServiceImpl
implements MessageService {
    @Inject
    private MessageDao messageDao;
    private int elementsPerPage = 10;
    @Inject
    private SilverpeasCalendar calendar;
    private static final int MSG_PER_ACTIVITY = 5;

    public int getElementsPerPage() {
        return this.elementsPerPage;
    }

    @Override
    public void setElementsPerPage(int elementsPerPage) {
        this.elementsPerPage = elementsPerPage;
    }

    public MessageDao getMessageDao() {
        return this.messageDao;
    }

    @Override
    public String saveMessage(Message message) {
        if (message == null) {
            return null;
        }
        String id = message.getId();
        if (id == null) {
            id = this.messageDao.saveMessage(message);
            MessageIndexer.indexMessage(message);
        } else {
            this.messageDao.updateMessage(message);
        }
        return id;
    }

    @Override
    public Message getMessage(String id) {
        return this.messageDao.findMessageById(id);
    }

    @Override
    public List<Message> listMessages(MailingList mailingList, int pageNumber, OrderBy orderBy) {
        return this.messageDao.listAllMessagesOfMailingList(mailingList.getComponentId(), pageNumber, this.elementsPerPage, orderBy);
    }

    @Override
    public List<Message> listDisplayableMessages(MailingList mailingList, int month, int year, int pageNumber, OrderBy orderBy) {
        return this.messageDao.listDisplayableMessagesOfMailingList(mailingList.getComponentId(), month, year, pageNumber, this.elementsPerPage, orderBy);
    }

    @Override
    public List<Message> listUnmoderatedeMessages(MailingList mailingList, int pageNumber, OrderBy orderBy) {
        return this.messageDao.listUnmoderatedMessagesOfMailingList(mailingList.getComponentId(), pageNumber, this.elementsPerPage, orderBy);
    }

    @Override
    public int getNumberOfPagesForUnmoderatedMessages(MailingList mailingList) {
        long nbElements = this.messageDao.listTotalNumberOfUnmoderatedMessages(mailingList.getComponentId());
        return this.getNumberOfPages(nbElements);
    }

    @Override
    public int getNumberOfPagesForDisplayableMessages(MailingList mailingList) {
        long nbElements = this.messageDao.listTotalNumberOfDisplayableMessages(mailingList.getComponentId());
        return this.getNumberOfPages(nbElements);
    }

    @Override
    public int getNumberOfPagesForAllMessages(MailingList mailingList) {
        long nbElements = this.messageDao.listTotalNumberOfMessages(mailingList.getComponentId());
        return this.getNumberOfPages(nbElements);
    }

    private int getNumberOfPages(long nbElements) {
        int nbPages = (int)(nbElements / (long)this.elementsPerPage);
        if (nbElements % (long)this.elementsPerPage != 0L) {
            ++nbPages;
        }
        return nbPages;
    }

    @Override
    public MailingListActivity getActivity(MailingList mailingList) {
        if (mailingList == null) {
            return null;
        }
        List<Message> messages = this.messageDao.listActivityMessages(mailingList.getComponentId(), 5, new OrderBy("sentDate", false));
        List<Activity> activities = this.messageDao.listActivity(mailingList.getComponentId());
        Collections.sort(activities);
        return new MailingListActivity(messages, activities);
    }

    @Override
    public void deleteMessage(String id) {
        Message message = this.messageDao.findMessageById(id);
        if (message != null) {
            this.messageDao.deleteMessage(message);
            MessageIndexer.unindexMessage(message);
            try {
                SilverpeasList todos = this.getCalendar().getOrganizerToDos(message.getComponentId());
                if (todos != null && !todos.isEmpty()) {
                    for (ToDoHeader todo : todos) {
                        if (!id.equalsIgnoreCase(todo.getDescription())) continue;
                        todo.setCompletedDate(new Date());
                        todo.setPercentCompleted(100);
                        this.getCalendar().updateToDo(todo);
                        return;
                    }
                }
            }
            catch (CalendarRuntimeException ex) {
                SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void moderateMessage(String id) {
        Message message = this.messageDao.findMessageById(id);
        if (message != null) {
            message.setModerated(true);
            this.messageDao.updateMessage(message);
            MessageIndexer.indexMessage(message);
        }
        try {
            SilverpeasList todos;
            if (message != null && (todos = this.getCalendar().getOrganizerToDos(message.getComponentId())) != null && !todos.isEmpty()) {
                for (ToDoHeader todo : todos) {
                    if (!id.equalsIgnoreCase(todo.getDescription())) continue;
                    todo.setCompletedDate(new Date());
                    todo.setPercentCompleted(100);
                    this.getCalendar().updateToDo(todo);
                    return;
                }
            }
        }
        catch (CalendarRuntimeException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public List<Message> listDisplayableMessages(MailingList mailingList, int number, OrderBy orderBy) {
        return this.messageDao.listDisplayableMessagesOfMailingList(mailingList.getComponentId(), -1, -1, 0, number, orderBy);
    }

    public SilverpeasCalendar getCalendar() {
        return this.calendar;
    }

    @Override
    public long getTotalNumberOfMessages(MailingList mailingList) {
        return this.messageDao.listTotalNumberOfMessages(mailingList.getComponentId());
    }
}

