/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.rdfa;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.rootdev.javardfa.Constants;
import net.rootdev.javardfa.Resolver;
import net.rootdev.javardfa.Setting;
import org.apache.commons.validator.routines.UrlValidator;
import org.odftoolkit.odfdom.pkg.rdfa.EvalContext;
import org.odftoolkit.odfdom.pkg.rdfa.URIExtractor;
import org.odftoolkit.odfdom.pkg.rdfa.Util;

class URIExtractorImpl
implements URIExtractor {
    private Set<Setting> settings;
    private final Resolver resolver;
    private Map<String, String> xmlnsMap = Collections.EMPTY_MAP;
    private boolean isForSAX;
    private UrlValidator urlValidator;

    public URIExtractorImpl(Resolver resolver, boolean isForSAX) {
        this.resolver = resolver;
        this.isForSAX = isForSAX;
        this.urlValidator = new UrlValidator();
    }

    @Override
    public void setForSAX(boolean isForSAX) {
        this.isForSAX = isForSAX;
    }

    @Override
    public void setSettings(Set<Setting> settings) {
        this.settings = settings;
    }

    @Override
    public String getURI(StartElement element, Attribute attr, EvalContext context) {
        QName attrName = attr.getName();
        if (Util.qNameEquals(attrName, Constants.about)) {
            return this.expandSafeCURIE(element, attr.getValue(), context);
        }
        if (Util.qNameEquals(attrName, Constants.datatype)) {
            return this.expandCURIE(element, attr.getValue(), context);
        }
        throw new RuntimeException("Unexpected attribute: " + attr);
    }

    private boolean isValidURI(String uri) {
        return this.urlValidator.isValid(uri);
    }

    @Override
    public List<String> getURIs(StartElement element, Attribute attr, EvalContext context) {
        LinkedList<String> uris = new LinkedList<String>();
        String[] curies = attr.getValue().split("\\s+");
        boolean permitReserved = Util.qNameEquals(Constants.rel, attr.getName()) || Util.qNameEquals(Constants.rev, attr.getName());
        for (String curie : curies) {
            if (Constants.SpecialRels.contains(curie.toLowerCase())) {
                if (!permitReserved) continue;
                uris.add("http://www.w3.org/1999/xhtml/vocab#" + curie.toLowerCase());
                continue;
            }
            String uri = this.expandCURIE(element, curie, context);
            if (uri == null) continue;
            uris.add(uri);
        }
        return uris;
    }

    @Override
    public String expandCURIE(StartElement element, String value, EvalContext context) {
        if (value.startsWith("_:")) {
            if (!this.settings.contains(Setting.ManualNamespaces)) {
                return value;
            }
            if (element.getNamespaceURI("_") == null) {
                return value;
            }
        }
        if (this.settings.contains(Setting.FormMode) && value.startsWith("?")) {
            return value;
        }
        int offset = value.indexOf(":") + 1;
        if (offset == 0) {
            return null;
        }
        String prefix = value.substring(0, offset - 1);
        if ("xml".equals(prefix) || "xmlns".equals(prefix)) {
            return null;
        }
        String namespaceURI = null;
        if (prefix.length() == 0) {
            namespaceURI = "http://www.w3.org/1999/xhtml/vocab#";
        } else {
            namespaceURI = element.getNamespaceURI(prefix);
            if (this.isForSAX) {
                if (namespaceURI != null) {
                    if (this.xmlnsMap == Collections.EMPTY_MAP) {
                        this.xmlnsMap = new HashMap<String, String>();
                    }
                    this.xmlnsMap.put(prefix, namespaceURI);
                }
            } else if (namespaceURI == null) {
                namespaceURI = this.xmlnsMap.get(prefix);
            }
        }
        if (namespaceURI == null) {
            return null;
        }
        return namespaceURI + value.substring(offset);
    }

    @Override
    public String expandSafeCURIE(StartElement element, String value, EvalContext context) {
        if (value.startsWith("[") && value.endsWith("]")) {
            return this.expandCURIE(element, value.substring(1, value.length() - 1), context);
        }
        if (value.length() == 0) {
            return context.getBase();
        }
        if (this.settings.contains(Setting.FormMode) && value.startsWith("?")) {
            return value;
        }
        return this.resolver.resolve(context.getBase(), value);
    }

    @Override
    public String resolveURI(String uri, EvalContext context) {
        return this.resolver.resolve(context.getBase(), uri);
    }

    public String getNamespaceURI(String prefix) {
        if (this.xmlnsMap.containsKey(prefix)) {
            return this.xmlnsMap.get(prefix);
        }
        return null;
    }

    @Override
    public void setNamespaceURI(String prefix, String namespaceURI) {
        if (this.xmlnsMap == Collections.EMPTY_MAP) {
            this.xmlnsMap = new HashMap<String, String>();
        }
        this.xmlnsMap.put(prefix, namespaceURI);
    }
}

