/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text.list;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractListContainer
implements ListContainer {
    @Override
    public List addList() {
        return new List(this);
    }

    @Override
    public List addList(ListDecorator decorator) {
        return new List(this, decorator);
    }

    @Override
    public void clearList() {
        OdfElement containerElement = this.getListContainerElement();
        Node child = this.getListContainerElement().getFirstChild();
        while (child != null) {
            if (child instanceof TextListElement) {
                Node tmp = child;
                child = child.getNextSibling();
                containerElement.removeChild(tmp);
                continue;
            }
            child = child.getNextSibling();
        }
    }

    @Override
    public Iterator<List> getListIterator() {
        return new SimpleListIterator(this);
    }

    @Override
    public boolean removeList(List list) {
        OdfElement containerElement = this.getListContainerElement();
        OdfFileDom ownerDocument = (OdfFileDom)containerElement.getOwnerDocument();
        Document doc = (Document)ownerDocument.getDocument();
        for (Node child = containerElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof TextListElement)) continue;
            TextListElement listElement1 = (TextListElement)child;
            String id1 = listElement1.getXmlIdAttribute();
            TextListElement listElement2 = list.getOdfElement();
            String id2 = listElement2.getXmlIdAttribute();
            if (listElement1 != listElement2 && (id1 == null || id2 == null || !id1.equals(id2))) continue;
            doc.removeElementLinkedResource((OdfElement)listElement1);
            containerElement.removeChild(child);
            return true;
        }
        return false;
    }

    private static class SimpleListIterator
    implements Iterator<List> {
        private java.util.List<List> allLists;
        private int index;
        private List currentList;

        public SimpleListIterator(ListContainer container) {
            this.allLists = this.getLists(container.getListContainerElement().getChildNodes());
        }

        @Override
        public boolean hasNext() {
            return this.index < this.allLists.size();
        }

        @Override
        public List next() {
            if (this.hasNext()) {
                this.currentList = this.allLists.get(this.index);
                ++this.index;
                return this.currentList;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentList == null) {
                throw new IllegalStateException();
            }
            this.allLists.remove(this.currentList);
            this.currentList = null;
        }

        private java.util.List<List> getLists(NodeList nodes) {
            LinkedList<List> lists = new LinkedList<List>();
            int numberOfNodes = nodes.getLength();
            for (int i = 0; i < numberOfNodes; ++i) {
                Node node = nodes.item(i);
                lists.addAll(this.getLists(node));
            }
            return lists;
        }

        private java.util.List<List> getLists(Node node) {
            LinkedList<List> lists = new LinkedList<List>();
            if (node instanceof TextListElement) {
                TextListElement textListElement = (TextListElement)node;
                List list = new List(textListElement);
                lists.add(list);
            } else {
                NodeList childNodes = node.getChildNodes();
                lists.addAll(this.getLists(childNodes));
            }
            return lists;
        }
    }
}

