/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import javax.transaction.Transactional;
import org.apache.commons.fileupload.FileItem;
import org.apache.ecs.Element;
import org.apache.ecs.html.BR;
import org.apache.ecs.xhtml.div;
import org.silverpeas.components.formsonline.FormsOnlineComponentSettings;
import org.silverpeas.components.formsonline.model.FormDetail;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.model.FormInstanceValidation;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.components.formsonline.model.FormInstanceValidations;
import org.silverpeas.components.formsonline.model.FormPK;
import org.silverpeas.components.formsonline.model.FormsOnlineDAO;
import org.silverpeas.components.formsonline.model.FormsOnlineDAOJdbc;
import org.silverpeas.components.formsonline.model.FormsOnlineException;
import org.silverpeas.components.formsonline.model.FormsOnlineService;
import org.silverpeas.components.formsonline.model.RequestPK;
import org.silverpeas.components.formsonline.model.RequestValidationCriteria;
import org.silverpeas.components.formsonline.model.RequestsByStatus;
import org.silverpeas.components.formsonline.model.RequestsFilter;
import org.silverpeas.components.formsonline.notification.FormsOnlineCanceledRequestUserNotification;
import org.silverpeas.components.formsonline.notification.FormsOnlinePendingValidationRequestUserNotification;
import org.silverpeas.components.formsonline.notification.FormsOnlineProcessedRequestFollowingUserNotification;
import org.silverpeas.components.formsonline.notification.FormsOnlineProcessedRequestOtherValidatorsUserNotification;
import org.silverpeas.components.formsonline.notification.FormsOnlineProcessedRequestUserNotification;
import org.silverpeas.components.formsonline.notification.FormsOnlineValidationRequestUserNotification;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentMailAttachedFile;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.ContributionValidation;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateImpl;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.html.PermalinkRegistry;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.mail.MailAddress;
import org.silverpeas.core.mail.MailContent;
import org.silverpeas.core.mail.MailSending;
import org.silverpeas.core.notification.message.MessageNotifier;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.security.authorization.ForbiddenRuntimeException;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Named(value="formsOnlineService")
public class DefaultFormsOnlineService
implements FormsOnlineService,
Initialization {
    private static final String IN_COMPONENT_MSG_PART = " in component ";
    @Inject
    private OrganizationController organizationController;

    public void init() {
        PermalinkRegistry.get().addUrlPart("Form");
    }

    @Override
    public List<FormDetail> getAllForms(String appId, String userId, boolean withSendInfo) throws FormsOnlineException {
        String orderBy = this.organizationController.getComponentParameterValue(appId, "displaySort");
        orderBy = StringUtil.isDefined((String)orderBy) ? orderBy : "name asc";
        List<FormDetail> forms = this.getDAO().findAllForms(appId, orderBy);
        Map<Integer, Integer> numbersOfRequests = this.getDAO().getNumberOfRequestsByForm(appId);
        for (FormDetail form : forms) {
            Integer numberOfRequests = numbersOfRequests.get(form.getId());
            if (numberOfRequests != null) {
                form.setNbRequests(numberOfRequests);
            }
            if (!withSendInfo) continue;
            form.setSendable(this.isSender(form.getPK(), userId));
        }
        return forms;
    }

    private boolean isSender(FormPK pk, String userId) throws FormsOnlineException {
        return this.isInLists(userId, this.getSendersAsUsers(pk), this.getSendersAsGroups(pk));
    }

    private List<User> getSendersAsUsers(FormPK pk) throws FormsOnlineException {
        List<String> userIds = this.getDAO().getSendersAsUsers(pk);
        Object[] details = this.organizationController.getUserDetails(userIds.toArray(new String[0]));
        return CollectionUtil.asList((Object[])details);
    }

    private List<Group> getSendersAsGroups(FormPK pk) throws FormsOnlineException {
        List<String> groupIds = this.getDAO().getSendersAsGroups(pk);
        Object[] groups = this.organizationController.getGroups(groupIds.toArray(new String[0]));
        return CollectionUtil.asList((Object[])groups);
    }

    private List<User> getReceiversAsUsers(FormPK pk, String rightType) throws FormsOnlineException {
        List<String> userIds = this.getDAO().getReceiversAsUsers(pk, rightType);
        Object[] details = this.organizationController.getUserDetails(userIds.toArray(new String[0]));
        return CollectionUtil.asList((Object[])details);
    }

    private List<Group> getReceiversAsGroups(FormPK pk, String rightType) throws FormsOnlineException {
        List<String> groupIds = this.getDAO().getReceiversAsGroups(pk, rightType);
        Object[] groups = this.organizationController.getGroups(groupIds.toArray(new String[0]));
        return CollectionUtil.asList((Object[])groups);
    }

    private boolean isValidator(FormPK pk, String userId, String rightType) throws FormsOnlineException {
        return this.isInLists(userId, this.getReceiversAsUsers(pk, rightType), this.getReceiversAsGroups(pk, rightType));
    }

    private boolean isInLists(String userId, List<? extends User> users, List<Group> groups) {
        boolean inList = this.isInList(userId, users);
        if (!inList) {
            for (Group group : groups) {
                inList = group != null && this.isInList(userId, group.getAllUsers());
                if (!inList) continue;
                return true;
            }
        }
        return inList;
    }

    private boolean isInList(String userId, List<? extends User> users) {
        for (User user : users) {
            if (user == null || !user.getId().equals(userId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FormDetail loadForm(FormPK pk) throws FormsOnlineException {
        FormDetail form = this.getDAO().getForm(pk);
        this.setSendersAndReceivers(form);
        return form;
    }

    @Override
    @Transactional
    public FormDetail saveForm(FormDetail form, Map<String, Pair<List<String>, List<String>>> userAndGroupIdsByRightTypes) throws FormsOnlineException {
        FormDetail theForm = form;
        boolean deleteAfterRequestExchange = theForm.isDeleteAfterRequestExchange();
        if (deleteAfterRequestExchange) {
            theForm.setHierarchicalValidation(false);
        } else if (Optional.of(form.getState()).filter(s -> s.equals(1)).filter(s -> userAndGroupIdsByRightTypes.entrySet().stream().filter(e -> ((String)e.getKey()).equals("R")).map(Map.Entry::getValue).anyMatch(p -> ((List)p.getFirst()).isEmpty() && ((List)p.getSecond()).isEmpty())).isPresent()) {
            throw new FormsOnlineException(MessageFormat.format("published form {0} must have final validators", new Object[]{form.getPK()}), new String[0]);
        }
        if (theForm.getId() == -1) {
            theForm = this.getDAO().createForm(theForm);
        } else {
            this.getDAO().updateForm(theForm);
        }
        Map<String, Pair<List<String>, List<String>>> filteredRights = userAndGroupIdsByRightTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (FormDetail.ALL_RECEIVER_TYPES.contains(e.getKey()) && deleteAfterRequestExchange) {
                return Pair.of(Collections.emptyList(), Collections.emptyList());
            }
            return (Pair)e.getValue();
        }));
        this.getDAO().updateSenders(theForm.getPK(), filteredRights);
        this.getDAO().updateReceivers(theForm.getPK(), filteredRights);
        this.setSendersAndReceivers(theForm);
        this.index(theForm);
        return theForm;
    }

    @Override
    @Transactional
    public boolean deleteForm(FormPK pk) throws FormsOnlineException {
        SilverpeasList<FormInstance> requests = this.getDAO().getAllRequests(pk);
        boolean reallyDeleteForm = true;
        for (FormInstance request : requests) {
            try {
                FormsOnlineService.get().deleteRequest(request.getPK());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Unable to delete request #" + request.getId() + IN_COMPONENT_MSG_PART + request.getComponentInstanceId(), (Throwable)e);
                reallyDeleteForm = false;
            }
        }
        if (reallyDeleteForm) {
            this.getDAO().deleteForm(pk);
            this.removeIndex(pk);
        }
        return reallyDeleteForm;
    }

    @Override
    @Transactional
    public void publishForm(FormPK pk) throws FormsOnlineException {
        FormDetail form = this.loadForm(pk);
        form.setState(1);
        this.checkFormData(form);
        this.getDAO().updateForm(form);
        this.index(form);
    }

    private void checkFormData(FormDetail form) throws FormsOnlineException {
        if (form.isPublished() && !form.isDeleteAfterRequestExchange() && !form.isFinalValidation()) {
            throw new FormsOnlineException(MessageFormat.format("published form {0} must have final validators", new Object[]{form.getPK()}), new String[0]);
        }
    }

    @Override
    @Transactional
    public void unpublishForm(FormPK pk) throws FormsOnlineException {
        FormDetail form = this.getDAO().getForm(pk);
        form.setState(2);
        this.getDAO().updateForm(form);
        this.index(form);
    }

    @Override
    public List<FormDetail> getAvailableFormsToSend(Collection<String> appIds, String userId, String orderBy) throws FormsOnlineException {
        String[] userGroupIds = this.organizationController.getAllGroupIdsOfUser(userId);
        return this.getDAO().getUserAvailableForms(appIds, userId, userGroupIds, orderBy);
    }

    @Override
    public RequestsByStatus getAllUserRequests(String appId, String userId, PaginationPage paginationPage) throws FormsOnlineException {
        RequestsByStatus requests = new RequestsByStatus(paginationPage);
        List<FormDetail> forms = this.getAllForms(appId, userId, false);
        for (FormDetail form : forms) {
            this.setSendersAndReceivers(form);
            for (RequestsByStatus.MergeRuleByStates rule : RequestsByStatus.MERGING_RULES_BY_STATES) {
                List<Integer> states = rule.getStates();
                BiConsumer<RequestsByStatus, SilverpeasList<FormInstance>> merge = rule.getMerger();
                SilverpeasList<FormInstance> result = this.getDAO().getSentFormInstances(form.getPK(), userId, states, paginationPage);
                merge.accept(requests, (SilverpeasList<FormInstance>)((SilverpeasList)result.stream().map(l -> {
                    l.setForm(form);
                    return l;
                }).collect(SilverpeasList.collector(result))));
            }
        }
        return requests;
    }

    @Override
    public RequestsByStatus getValidatorRequests(RequestsFilter filter, String validatorId, PaginationPage paginationPage) throws FormsOnlineException {
        Map<String, Set<FormInstanceValidationType>> possibleValidatorValidationTypesByFormId = this.getValidatorFormIdsWithValidationTypes(filter.getComponentId(), validatorId, filter.getFormIds());
        List<FormDetail> availableForms = this.getDAO().getForms(possibleValidatorValidationTypesByFormId.keySet());
        Map<String, Set<FormInstanceValidationType>> possibleValidationTypesByFormId = this.getDAO().getPossibleValidationTypesByFormId(possibleValidatorValidationTypesByFormId.keySet());
        RequestsByStatus requests = new RequestsByStatus(paginationPage);
        MemoizedSupplier managedDomainUsersSupplier = new MemoizedSupplier(() -> {
            String userDomainId = User.getById((String)validatorId).getDomainId();
            User[] users = OrganizationController.get().getAllUsersInDomain(userDomainId);
            Set<String> userIds = Stream.of(users).map(User::getId).collect(Collectors.toSet());
            HierarchicalValidatorCacheManager hvManager = HierarchicalValidatorCacheManager.get();
            hvManager.cacheHierarchicalValidatorsOf(userIds);
            return userIds.stream().map(u -> Pair.of((Object)u, (Object)hvManager.getHierarchicalValidatorOf((String)u))).filter(p -> validatorId.equals(p.getSecond())).map(Pair::getFirst).collect(Collectors.toSet());
        });
        for (FormDetail form : availableForms) {
            this.setSendersAndReceivers(form);
            for (RequestsByStatus.ValidationMergeRuleByStates rule : RequestsByStatus.VALIDATION_MERGING_RULES_BY_STATES) {
                RequestValidationCriteria validationCriteria;
                List<Integer> states = rule.getStates().stream().filter(s -> filter.getState() < 0 || filter.getState() == s.intValue()).collect(Collectors.toList());
                if (states.isEmpty()) continue;
                BiConsumer<RequestsByStatus, SilverpeasList<FormInstance>> merge = rule.getMerger();
                if (!filter.isAllRequests()) {
                    validationCriteria = RequestValidationCriteria.withValidatorId(validatorId, (MemoizedSupplier<Set<String>>)managedDomainUsersSupplier);
                    String formId = form.getPK().getId();
                    Set<FormInstanceValidationType> possibleFormValidationTypes = possibleValidationTypesByFormId.get(formId);
                    Set<FormInstanceValidationType> possibleValidatorValidationTypes = possibleValidatorValidationTypesByFormId.get(formId);
                    rule.getValidationCriteriaConfigurer().accept((Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>)Pair.of(possibleFormValidationTypes, possibleValidatorValidationTypes), validationCriteria);
                } else {
                    validationCriteria = null;
                }
                Optional<FormInstanceValidationType> pendingValidationTypeFilter = filter.getPendingValidationType();
                SilverpeasList<FormInstance> result = this.getDAO().getReceivedRequests(form, states, validationCriteria, Optional.ofNullable(paginationPage).filter(p -> pendingValidationTypeFilter.isEmpty()).orElse(null));
                Stream<FormInstance> resultStream = result.stream().map(l -> {
                    l.setForm(form);
                    return l;
                });
                resultStream = this.filterOnValidationType(resultStream, pendingValidationTypeFilter);
                merge.accept(requests, (SilverpeasList<FormInstance>)((SilverpeasList)resultStream.collect(SilverpeasList.collector(result))));
            }
        }
        return requests;
    }

    private Stream<FormInstance> filterOnValidationType(Stream<FormInstance> resultStream, Optional<FormInstanceValidationType> pendingValidationTypeFilter) {
        if (pendingValidationTypeFilter.isPresent()) {
            resultStream = resultStream.filter(r -> {
                FormInstanceValidationType type = (FormInstanceValidationType)((Object)((Object)pendingValidationTypeFilter.get()));
                Set<FormInstanceValidationType> possibleTypes = r.getForm().getPossibleRequestValidations().keySet();
                if (!possibleTypes.contains((Object)type)) {
                    return false;
                }
                Optional<FormInstanceValidationType> previousType = possibleTypes.stream().filter(t -> t.ordinal() < type.ordinal()).reduce((a, b) -> b);
                return previousType.map(p -> r.getValidations().getValidationOfType((FormInstanceValidationType)((Object)((Object)p))).filter(ContributionValidation::isValidated).isPresent() && r.getValidations().getValidationOfType(type).isEmpty()).orElseGet(() -> r.getValidations().isEmpty());
            });
        }
        return resultStream;
    }

    @Override
    public Map<String, Set<FormInstanceValidationType>> getValidatorFormIdsWithValidationTypes(String appId, String validatorId, Collection<String> formIds) throws FormsOnlineException {
        String[] userGroupIds = this.organizationController.getAllGroupIdsOfUser(validatorId);
        Map<String, Set<FormInstanceValidationType>> result = this.getDAO().getValidatorFormIdsWithValidationTypes(appId, validatorId, userGroupIds, formIds);
        String orderBy = this.organizationController.getComponentParameterValue(appId, "displaySort");
        orderBy = StringUtil.isDefined((String)orderBy) ? orderBy : "name asc";
        List<FormDetail> forms = this.getDAO().findAllForms(appId, orderBy);
        HierarchicalValidatorCacheManager hvManager = new HierarchicalValidatorCacheManager();
        for (FormDetail form : forms) {
            if (!form.isHierarchicalValidation() || !CollectionUtil.isEmpty(formIds) && !formIds.contains(form.getPK().getId())) continue;
            SilverpeasList<FormInstance> requests = this.getDAO().getAllRequests(form.getPK());
            Set<String> creatorIds = requests.stream().map(FormInstance::getCreatorId).collect(Collectors.toSet());
            hvManager.cacheHierarchicalValidatorsOf(creatorIds);
            creatorIds.stream().map(hvManager::getHierarchicalValidatorOf).filter(validatorId::equals).findFirst().ifPresent(b -> result.computeIfAbsent(Integer.toString(form.getId()), s -> new TreeSet()).add(FormInstanceValidationType.HIERARCHICAL));
        }
        return result;
    }

    @Override
    public FormInstance loadRequest(RequestPK pk, String userId) throws FormsOnlineException {
        return this.loadRequest(pk, userId, false);
    }

    @Override
    public FormInstance loadRequest(RequestPK pk, String userId, boolean editionMode) throws FormsOnlineException {
        FormInstance request = this.getDAO().getRequest(pk);
        FormDetail form = this.loadForm(request.getFormPK());
        request.setForm(form);
        String xmlFormName = form.getXmlFormName();
        String xmlFormShortName = xmlFormName.substring(xmlFormName.indexOf(47) + 1, xmlFormName.indexOf(46));
        try {
            this.getPublicationTemplateManager().addDynamicPublicationTemplate(pk.getInstanceId() + ":" + xmlFormShortName, xmlFormName);
            PublicationTemplateImpl pubTemplate = (PublicationTemplateImpl)this.getPublicationTemplateManager().getPublicationTemplate(pk.getInstanceId() + ":" + xmlFormShortName, xmlFormName);
            Form customForm = editionMode ? pubTemplate.getUpdateForm() : pubTemplate.getViewForm();
            RecordSet recordSet = pubTemplate.getRecordSet();
            DataRecord data = recordSet.getRecord(pk.getId());
            customForm.setData(data);
            request.setFormWithData(customForm);
        }
        catch (FormException | PublicationTemplateException e) {
            throw new FormsOnlineException("Can't load content of request #" + request.getId() + IN_COMPONENT_MSG_PART + pk.getInstanceId(), e);
        }
        this.setRequestStateAndValidationData(form, request, userId);
        return request;
    }

    private void setRequestStateAndValidationData(FormDetail form, FormInstance request, String userId) throws FormsOnlineException {
        if (request.canBeValidated()) {
            List<FormInstanceValidation> schema = request.getValidationsSchema();
            for (FormInstanceValidation validation : schema) {
                if (!validation.isPendingValidation()) continue;
                boolean validationEnabled = validation.getValidationType().isHierarchical() ? request.isHierarchicalValidator(userId) : (validation.getValidationType().isIntermediate() ? this.isValidator(form.getPK(), userId, "I") : this.isValidator(form.getPK(), userId, "R"));
                request.setValidationEnabled(validationEnabled);
                break;
            }
            if (request.getState() == 1 && request.isValidationEnabled()) {
                request.setState(2);
                this.getDAO().saveRequestState(request);
            }
        }
    }

    @Override
    @Transactional
    public void saveRequest(FormPK pk, String userId, List<FileItem> items, boolean draft) throws FormsOnlineException {
        FormInstance request;
        String requestId = FileUploadUtil.getParameter(items, (String)"Id");
        if (StringUtil.isNotDefined((String)requestId)) {
            request = this.createRequest(pk, userId, items, draft);
        } else {
            request = this.loadRequest(new RequestPK(requestId, pk.getInstanceId()), userId);
            this.updateRequest(request, items, draft);
        }
        if (!draft) {
            this.notifyReceivers(request);
        }
    }

    private FormInstance createRequest(FormPK pk, String userId, List<FileItem> items, boolean draft) throws FormsOnlineException {
        FormInstance request = new FormInstance();
        request.setCreatorId(userId);
        request.setFormId(Integer.parseInt(pk.getId()));
        request.setInstanceId(pk.getInstanceId());
        if (draft) {
            request.setState(0);
        } else {
            request.setState(1);
        }
        request = this.getDAO().saveRequest(request);
        FormDetail formDetail = this.loadForm(pk);
        request.setForm(formDetail);
        try {
            PublicationTemplate pub = this.getPublicationTemplate(request);
            RecordSet set = pub.getRecordSet();
            Form form = pub.getUpdateForm();
            DataRecord data = set.getEmptyRecord();
            data.setId(String.valueOf(request.getId()));
            PagesContext aContext = new PagesContext("dummy", "0", UserDetail.getById((String)userId).getUserPreferences().getLanguage(), false, pk.getInstanceId(), userId);
            aContext.setObjectId(String.valueOf(request.getId()));
            form.update(items, data, aContext);
            set.save(data);
        }
        catch (Exception e) {
            throw new FormsOnlineException("Can't create content of request #" + request.getId() + IN_COMPONENT_MSG_PART + pk.getInstanceId(), e);
        }
        return request;
    }

    private void updateRequest(FormInstance request, List<FileItem> items, boolean draft) throws FormsOnlineException {
        FormDetail formDetail = request.getForm();
        if (draft) {
            request.setState(0);
        } else {
            request.setState(1);
        }
        request = this.getDAO().saveRequest(request);
        request.setForm(formDetail);
        try {
            PublicationTemplate pub = this.getPublicationTemplate(request);
            RecordSet set = pub.getRecordSet();
            Form form = pub.getUpdateForm();
            DataRecord data = set.getRecord(request.getId());
            PagesContext aContext = new PagesContext("dummy", "0", UserDetail.getById((String)request.getCreatorId()).getUserPreferences().getLanguage(), false, request.getComponentInstanceId(), request.getCreatorId());
            aContext.setObjectId(String.valueOf(request.getId()));
            form.update(items, data, aContext);
            set.save(data);
        }
        catch (Exception e) {
            throw new FormsOnlineException("Can't update content of request #" + request.getId() + IN_COMPONENT_MSG_PART + request.getComponentInstanceId(), e);
        }
    }

    @Override
    @Transactional
    public void saveNextRequestValidationStep(RequestPK pk, String validatorId, String decision, String comment, boolean follower) throws FormsOnlineException {
        FormInstance request = this.getDAO().getRequest(pk);
        FormDetail form = this.loadForm(new FormPK(request.getFormId(), pk.getInstanceId()));
        request.setForm(form);
        FormInstanceValidation validation = request.getPendingValidation();
        if (validation.getValidationType().isHierarchical() && !request.isHierarchicalValidator(validatorId) || validation.getValidationType().isIntermediate() && !form.isIntermediateValidator(validatorId) || validation.getValidationType().isFinal() && !form.isFinalValidator(validatorId)) {
            this.throwForbiddenException(validatorId + " can not validate the request " + request.getId());
        }
        if ("validate".equals(decision)) {
            if (validation.getValidationType().isFinal()) {
                request.setState(3);
            }
            validation.setStatus(ContributionStatus.VALIDATED);
        } else {
            request.setState(4);
            validation.setStatus(ContributionStatus.REFUSED);
            if (StringUtil.isNotDefined((String)comment)) {
                throw new FormsOnlineException("Missing a comment on the refused request", new String[0]);
            }
        }
        validation.setDate(Date.from(Instant.now()));
        validation.setValidator(User.getById((String)validatorId));
        validation.setComment(comment);
        validation.setFollower(follower);
        request.getValidations().add(validation);
        this.getDAO().saveRequest(request);
        this.notifyValidation(request);
    }

    private void notifyValidation(FormInstance request) {
        NotifAction action = request.getState() == 4 ? NotifAction.REFUSE : NotifAction.VALIDATE;
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new FormsOnlineValidationRequestUserNotification(request, action));
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new FormsOnlineProcessedRequestUserNotification(request, action));
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new FormsOnlineProcessedRequestFollowingUserNotification(request, action));
        if (StringUtil.getBooleanValue((String)this.organizationController.getComponentParameterValue(request.getComponentInstanceId(), "workgroup"))) {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new FormsOnlineProcessedRequestOtherValidatorsUserNotification(request, action));
        }
    }

    @Override
    @Transactional
    public void cancelRequest(RequestPK pk) throws FormsOnlineException {
        FormInstance request = this.getDAO().getRequest(pk);
        FormDetail form = this.loadForm(new FormPK(request.getFormId(), pk.getInstanceId()));
        request.setForm(form);
        User currentRequester = User.getCurrentRequester();
        if (!request.canBeCanceledBy(currentRequester)) {
            this.throwForbiddenException(currentRequester.getId() + " can not cancel the request " + request.getId());
        }
        request.setState(6);
        this.getDAO().saveRequestState(request);
        this.notifyCancellation(request);
    }

    private void notifyCancellation(FormInstance request) {
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new FormsOnlineCanceledRequestUserNotification(request));
    }

    @Override
    @Transactional
    public void deleteRequest(RequestPK pk) throws FormsOnlineException {
        try {
            FormInstance request = this.getDAO().getRequest(pk);
            FormDetail form = this.loadForm(new FormPK(request.getFormId(), pk.getInstanceId()));
            request.setForm(form);
            User currentRequester = User.getCurrentRequester();
            if (!request.canBeDeletedBy(currentRequester)) {
                this.throwForbiddenException(currentRequester.getId() + " can not delete the request " + request.getId());
            }
            PublicationTemplate pubTemplate = this.getPublicationTemplate(request);
            RecordSet set = pubTemplate.getRecordSet();
            DataRecord data = set.getRecord(pk.getId());
            set.delete(data.getId());
        }
        catch (Exception e) {
            throw new FormsOnlineException("Can't delete request #" + pk.getId() + IN_COMPONENT_MSG_PART + pk.getInstanceId(), e);
        }
        this.getDAO().deleteRequest(pk);
    }

    @Override
    @Transactional
    public void archiveRequest(RequestPK pk) throws FormsOnlineException {
        FormInstance request = this.getDAO().getRequest(pk);
        FormDetail form = this.loadForm(new FormPK(request.getFormId(), pk.getInstanceId()));
        request.setForm(form);
        User currentRequester = User.getCurrentRequester();
        if (!request.canBeArchivedBy(currentRequester)) {
            this.throwForbiddenException(currentRequester.getId() + " can not archive the request " + request.getId());
        }
        request.setState(5);
        this.getDAO().saveRequestState(request);
    }

    private void notifyReceivers(FormInstance request) throws FormsOnlineException {
        FormInstanceValidations validations = request.getValidations();
        if (validations.isEmpty()) {
            this.sendRequestByEmail(request);
        }
        if (!request.getForm().isDeleteAfterRequestExchange()) {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new FormsOnlinePendingValidationRequestUserNotification(request));
        }
    }

    private PublicationTemplate getPublicationTemplate(FormInstance request) throws FormsOnlineException, PublicationTemplateException {
        FormPK formPK = new FormPK(request.getFormId(), request.getPK().getInstanceId());
        FormDetail form = this.getDAO().getForm(formPK);
        String xmlFormName = form.getXmlFormName();
        String xmlFormShortName = xmlFormName.substring(xmlFormName.indexOf(47) + 1, xmlFormName.indexOf(46));
        return this.getPublicationTemplateManager().getPublicationTemplate(request.getPK().getInstanceId() + ":" + xmlFormShortName);
    }

    private void sendRequestByEmail(FormInstance request) throws FormsOnlineException {
        FormDetail form = request.getForm();
        Optional<String> requestExchangeReceiver = form.getRequestExchangeReceiver();
        if (requestExchangeReceiver.isPresent()) {
            Pair<String, List<SimpleDocument>> contents = this.prepareMailContents(request, form);
            String email = requestExchangeReceiver.get();
            try {
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)MailContent.getHtmlBodyPartFromHtmlContent((String)((String)contents.getFirst())));
                this.attachFilesToMail((Multipart)multipart, (List)contents.getSecond());
                User sender = User.getById((String)request.getCreatorId());
                MailSending.from((MailAddress)MailAddress.eMail((String)sender.getEmailAddress()).withName(sender.getDisplayedName())).to(MailAddress.eMail((String)email)).withSubject(form.getTitle()).withContent((Multipart)multipart).setReplyToRequired().send();
                LocalizationBundle messages = FormsOnlineComponentSettings.getMessagesIn(sender.getUserPreferences().getLanguage());
                if (form.isDeleteAfterRequestExchange()) {
                    String title = messages.getStringWithParams("formsOnline.request.exchange.senderCopy", new Object[]{form.getTitle()});
                    MailSending.from((MailAddress)MailAddress.eMail(null)).to(MailAddress.eMail((String)sender.getEmailAddress())).withSubject(title).withContent((Multipart)multipart).send();
                    MessageNotifier.addSuccess((String)messages.getStringWithParams("formsOnline.request.exchange.successAndSummary", new Object[]{form.getTitle()}), (Object[])new Object[0]);
                } else {
                    MessageNotifier.addSuccess((String)messages.getStringWithParams("formsOnline.request.exchange.success", new Object[]{form.getTitle()}), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                throw new FormsOnlineException("Can't send request #" + request.getPK().getId() + " to " + email, e);
            }
            if (form.isDeleteAfterRequestExchange()) {
                this.deleteRequest(request.getPK());
            }
        }
    }

    private Pair<String, List<SimpleDocument>> prepareMailContents(FormInstance request, FormDetail form) throws FormsOnlineException {
        try {
            div content = new div();
            ArrayList<SimpleDocument> docs = new ArrayList<SimpleDocument>();
            PublicationTemplate template = this.getPublicationTemplate(request);
            RecordSet recordSet = template.getRecordSet();
            FieldTemplate[] fields = template.getRecordTemplate().getFieldTemplates();
            DataRecord dataRecord = recordSet.getRecord(request.getId());
            Map values = dataRecord.getValues(I18NHelper.DEFAULT_LANGUAGE);
            for (FieldTemplate field : fields) {
                String value = (String)values.get(field.getFieldName());
                if (!StringUtil.isDefined((String)value)) continue;
                content.addElement(field.getLabel(I18NHelper.DEFAULT_LANGUAGE));
                content.addElement(" : ");
                content.addElement(value);
                content.addElement((Element)new BR());
                if (!field.getTypeName().equals("file")) continue;
                docs.addAll(this.getFiles(dataRecord, field, request.getComponentInstanceId()));
            }
            return Pair.of((Object)content.toString(), docs);
        }
        catch (Exception e) {
            throw new FormsOnlineException("Can't load form '" + form.getXmlFormName() + "'", e);
        }
    }

    private List<SimpleDocument> getFiles(DataRecord dataRecord, FieldTemplate field, String instanceId) throws FormException {
        ArrayList<SimpleDocument> docs = new ArrayList<SimpleDocument>();
        if (!field.isRepeatable()) {
            String docId = dataRecord.getField(field.getFieldName()).getValue();
            SimpleDocument doc = this.getDocument(docId, instanceId);
            if (doc != null) {
                docs.add(doc);
            }
        } else {
            int maxOccurrences = field.getMaximumNumberOfOccurrences();
            for (int occ = 0; occ < maxOccurrences; ++occ) {
                String docId;
                SimpleDocument doc;
                Field fieldOcc = dataRecord.getField(field.getFieldName(), occ);
                if (fieldOcc == null || fieldOcc.isNull() || (doc = this.getDocument(docId = fieldOcc.getValue(), instanceId)) == null) continue;
                docs.add(doc);
            }
        }
        return docs;
    }

    private SimpleDocument getDocument(String documentId, String instanceId) {
        return AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(documentId, instanceId), null);
    }

    private void attachFilesToMail(Multipart mp, List<SimpleDocument> listAttachedFiles) throws MessagingException {
        for (SimpleDocument attachment : listAttachedFiles) {
            mp.addBodyPart((BodyPart)new SimpleDocumentMailAttachedFile(attachment).toBodyPart());
        }
    }

    private void throwForbiddenException(String method) {
        throw new ForbiddenRuntimeException("User is not allowed to do the following operation: " + method);
    }

    private PublicationTemplateManager getPublicationTemplateManager() {
        return PublicationTemplateManager.getInstance();
    }

    private FormsOnlineDAO getDAO() {
        return new FormsOnlineDAOJdbc();
    }

    @Override
    public Optional<FormInstance> getContributionById(ContributionIdentifier contributionId) {
        return Optional.empty();
    }

    public SettingBundle getComponentSettings() {
        return null;
    }

    public LocalizationBundle getComponentMessages(String language) {
        return null;
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith("formsOnline");
    }

    private void index(FormDetail form) {
        IndexEntryKey key = this.getIndexEntryKey(form.getPK());
        if (form.isPublished()) {
            FullIndexEntry fie = new FullIndexEntry(key);
            fie.setTitle(form.getTitle());
            fie.setPreview(form.getDescription());
            fie.setCreationDate(form.getCreationDate());
            fie.setCreationUser(form.getCreatorId());
            IndexEngineProxy.addIndexEntry((FullIndexEntry)fie);
        } else {
            IndexEngineProxy.removeIndexEntry((IndexEntryKey)key);
        }
    }

    private void removeIndex(FormPK pk) {
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)this.getIndexEntryKey(pk));
    }

    private IndexEntryKey getIndexEntryKey(FormPK pk) {
        return new IndexEntryKey(pk.getInstanceId(), "FormOnline", pk.getId());
    }

    @Override
    public void index(String componentId) {
        try {
            List<FormDetail> forms = this.getAllForms(componentId, "useless", false);
            for (FormDetail form : forms) {
                this.index(form);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    private void setSendersAndReceivers(FormDetail form) throws FormsOnlineException {
        if (form != null) {
            FormPK pk = form.getPK();
            form.setSendersAsUsers(this.getSendersAsUsers(pk));
            form.setSendersAsGroups(this.getSendersAsGroups(pk));
            form.setIntermediateReceiversAsUsers(this.getReceiversAsUsers(pk, "I"));
            form.setIntermediateReceiversAsGroups(this.getReceiversAsGroups(pk, "I"));
            form.setReceiversAsUsers(this.getReceiversAsUsers(pk, "R"));
            form.setReceiversAsGroups(this.getReceiversAsGroups(pk, "R"));
        }
    }

    public static class HierarchicalValidatorCacheManager {
        private static final String CACHE_KEY = HierarchicalValidatorCacheManager.class.getName();
        private final Set<String> userIds = new HashSet<String>();
        private final Map<String, String> cache = new HashMap<String, String>();

        @NonNull
        public static HierarchicalValidatorCacheManager get() {
            HierarchicalValidatorCacheManager manager = (HierarchicalValidatorCacheManager)CacheAccessorProvider.getThreadCacheAccessor().getCache().computeIfAbsent((Object)CACHE_KEY, HierarchicalValidatorCacheManager.class, HierarchicalValidatorCacheManager::new);
            return Objects.requireNonNull(manager);
        }

        private HierarchicalValidatorCacheManager() {
        }

        public void cacheHierarchicalValidatorsOf(Set<String> userIds) {
            userIds.stream().filter(Predicate.not(this.cache::containsKey)).forEach(this.userIds::add);
        }

        public String getHierarchicalValidatorOf(String userId) {
            if (!this.userIds.isEmpty()) {
                UserFull.getByIds(this.userIds).forEach(u -> {
                    String id = u.getId();
                    this.userIds.remove(id);
                    this.cache.put(id, Optional.ofNullable(u.getValue("boss")).orElse(""));
                });
                this.userIds.forEach(i -> this.cache.put((String)i, ""));
                this.userIds.clear();
            }
            return this.cache.computeIfAbsent(userId, i -> Optional.ofNullable(UserFull.getById((String)i)).map(u -> u.getValue("boss")).orElse(""));
        }
    }
}

