/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.patch;

import edu.psu.swe.commons.jaxrs.patch.JsonPointer;
import edu.psu.swe.commons.jaxrs.patch.JsonPointerParseException;
import edu.psu.swe.commons.jaxrs.patch.PatchOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchUtil {
    private static final Logger log = LoggerFactory.getLogger(PatchUtil.class);

    public static List<PatchOperation> buildPatchOperationsForFields(Boolean currentValue, Boolean newValue, String patchPointerName) throws JsonPointerParseException {
        ArrayList<PatchOperation> patchOperations = new ArrayList<PatchOperation>();
        if (currentValue == null && newValue != null || currentValue != null && !currentValue.equals(newValue)) {
            JsonPointer jsonPointer = new JsonPointer(patchPointerName);
            patchOperations.add(PatchOperation.replace(jsonPointer, newValue));
            log.info("Updating {} to {}", (Object)patchPointerName, (Object)newValue);
        } else if (currentValue != null && newValue == null) {
            JsonPointer jsonPointer = new JsonPointer(patchPointerName);
            patchOperations.add(PatchOperation.remove(jsonPointer));
            log.info("Removing value {}", (Object)patchPointerName);
        }
        return patchOperations;
    }

    public static List<PatchOperation> buildPatchOperationsForFields(String currentValue, String newValue, String patchPointerName) throws JsonPointerParseException {
        ArrayList<PatchOperation> patchOperations = new ArrayList<PatchOperation>();
        if (currentValue == null && newValue != null || !currentValue.equals(newValue)) {
            JsonPointer jsonPointer = new JsonPointer(patchPointerName);
            patchOperations.add(PatchOperation.replace(jsonPointer, newValue));
            log.info("Updating {} to {}", (Object)patchPointerName, (Object)newValue);
        } else if (currentValue != null && newValue == null) {
            JsonPointer jsonPointer = new JsonPointer(patchPointerName);
            patchOperations.add(PatchOperation.remove(jsonPointer));
            log.info("Removing value {}", (Object)patchPointerName);
        }
        return patchOperations;
    }
}

