/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.ValueConverter;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ComparisonImpl;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;

public class InImpl
extends ConstraintImpl {
    private final DynamicOperandImpl operand1;
    private final List<StaticOperandImpl> operand2;

    public InImpl(DynamicOperandImpl operand1, List<StaticOperandImpl> operand2) {
        this.operand1 = operand1;
        this.operand2 = operand2;
    }

    public DynamicOperandImpl getOperand1() {
        return this.operand1;
    }

    public List<StaticOperandImpl> getOperand2() {
        return this.operand2;
    }

    @Override
    public ConstraintImpl simplify() {
        if (this.operand2.size() == 1) {
            return new ComparisonImpl(this.operand1, Operator.EQUAL, this.operand2.iterator().next());
        }
        HashSet set = Sets.newHashSet(this.operand2);
        if (set.size() == 1) {
            return new ComparisonImpl(this.operand1, Operator.EQUAL, (StaticOperandImpl)set.iterator().next());
        }
        if (set.size() != this.operand2.size()) {
            return new InImpl(this.operand1, Lists.newArrayList((Iterable)set));
        }
        return this;
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        PropertyExistenceImpl p = this.operand1.getPropertyExistence();
        if (p == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(p);
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return this.operand1.getSelectors();
    }

    @Override
    public boolean evaluate() {
        PropertyValue p1 = this.operand1.currentProperty();
        if (p1 == null) {
            return false;
        }
        for (StaticOperandImpl s : this.operand2) {
            PropertyValue p2 = s.currentValue();
            if (p2 == null || !PropertyValues.match((PropertyValue)p1, (PropertyValue)(p2 = this.convertValueToType(p2, p1)))) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.operand1).append(" in(");
        int i = 0;
        for (StaticOperandImpl s : this.operand2) {
            if (i++ > 0) {
                buff.append(", ");
            }
            buff.append(s);
        }
        buff.append(")");
        return buff.toString();
    }

    @Override
    public void restrict(FilterImpl f) {
        ArrayList<PropertyValue> list = new ArrayList<PropertyValue>();
        for (StaticOperandImpl s : this.operand2) {
            if (!ValueConverter.canConvert(s.getPropertyType(), this.operand1.getPropertyType())) {
                throw new IllegalArgumentException("Unsupported conversion from property type " + PropertyType.nameFromValue((int)s.getPropertyType()) + " to property type " + PropertyType.nameFromValue((int)this.operand1.getPropertyType()));
            }
            list.add(s.currentValue());
        }
        if (list != null) {
            this.operand1.restrictList(f, list);
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        for (StaticOperandImpl op : this.operand2) {
            if (op.currentValue() != null) continue;
            return;
        }
        if (this.operand1.canRestrictSelector(s)) {
            s.restrictSelector(this);
        }
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof InImpl) {
            return this.operand1.equals(((InImpl)that).operand1) && Sets.newHashSet(this.operand2).equals(Sets.newHashSet(((InImpl)that).operand2));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.operand1.hashCode();
    }

    @Override
    public AstElement copyOf() {
        return new InImpl(this.operand1.createCopy(), this.operand2);
    }
}

