/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.components.datawarning.service.DataWarningSchedulerImpl;
import org.silverpeas.kernel.logging.SilverLogger;

public class DataWarningSchedulerTable {
    private static final Map<String, DataWarningSchedulerImpl> schedulers = Collections.synchronizedMap(new HashMap());

    private DataWarningSchedulerTable() {
    }

    public static void addScheduler(String instanceId) {
        DataWarningSchedulerImpl theScheduler = DataWarningSchedulerTable.getScheduler(instanceId);
        if (theScheduler != null) {
            DataWarningSchedulerTable.removeScheduler(instanceId);
        } else {
            theScheduler = new DataWarningSchedulerImpl(instanceId);
        }
        schedulers.put(instanceId, theScheduler);
        theScheduler.start();
    }

    public static void removeScheduler(String instanceId) {
        try {
            DataWarningSchedulerImpl theScheduler = DataWarningSchedulerTable.getScheduler(instanceId);
            if (theScheduler != null) {
                theScheduler.stop();
                schedulers.remove(instanceId);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger(DataWarningSchedulerTable.class).error((Throwable)e);
        }
    }

    public static DataWarningSchedulerImpl getScheduler(String instanceId) {
        return schedulers.get(instanceId);
    }
}

