/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.proc;

import java.io.InputStream;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SegmentBlob
implements Blob {
    private final Proc.Backend backend;
    private final String segmentId;
    private final Proc.Backend.Segment segment;

    SegmentBlob(Proc.Backend backend, String segmentId, Proc.Backend.Segment segment) {
        this.backend = backend;
        this.segmentId = segmentId;
        this.segment = segment;
    }

    @NotNull
    public InputStream getNewStream() {
        return this.backend.getSegmentData(this.segmentId).orElseThrow(() -> new IllegalStateException("segment not found"));
    }

    public long length() {
        return this.segment.getLength();
    }

    @Nullable
    public String getReference() {
        return null;
    }

    @Nullable
    public String getContentIdentity() {
        return null;
    }
}

