/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.comment.model;

import java.util.Date;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.comment.model.CommentId;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public class Comment
implements SilverpeasContent {
    private static final long serialVersionUID = 3738544756345055840L;
    private static final SettingBundle settingBundle = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.comment.Comment");
    public static final String CONTRIBUTION_TYPE = "Comment";
    private final CommentId id;
    private final String resourceType;
    private final ResourceReference resource;
    private String message;
    private final Date creationDate;
    private Date updateDate;
    private final String authorId;

    public Comment(CommentId id, String authorId, String resourceType, ResourceReference resource, Date creationDate) {
        this.id = id;
        this.resourceType = resourceType;
        this.resource = resource;
        this.authorId = authorId;
        this.creationDate = creationDate;
        this.updateDate = creationDate;
    }

    public CommentId getIdentifier() {
        return this.id;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResourceReference getResourceReference() {
        return this.resource;
    }

    public String getCreatorId() {
        return this.authorId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getCreationDate() {
        return this.creationDate == null ? new Date() : new Date(this.creationDate.getTime());
    }

    public void setLastUpdateDate(Date modificationDate) {
        if (modificationDate != null) {
            this.updateDate = new Date(modificationDate.getTime());
        }
    }

    public Date getLastUpdateDate() {
        return this.updateDate;
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public User getCreator() {
        return User.getById((String)String.valueOf(this.authorId));
    }

    public String getId() {
        return this.id.getLocalId();
    }

    public String getComponentInstanceId() {
        return this.id.getComponentInstanceId();
    }

    public String getContributionType() {
        return CONTRIBUTION_TYPE;
    }

    public boolean canBeModifiedBy(User user) {
        return !user.isAnonymous() && !user.isAccessGuest() && (user.getId().equals(this.authorId) || settingBundle.getBoolean("AdminAllowedToUpdate", true) && user.isPlayingAdminRole(this.getComponentInstanceId()));
    }
}

