/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.HunspellStemFilter;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.IOUtils;

public class HunspellStemFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private static final String PARAM_DICTIONARY = "dictionary";
    private static final String PARAM_AFFIX = "affix";
    private static final String PARAM_RECURSION_CAP = "recursionCap";
    private static final String PARAM_IGNORE_CASE = "ignoreCase";
    private static final String PARAM_LONGEST_ONLY = "longestOnly";
    private final String dictionaryFiles;
    private final String affixFile;
    private final boolean ignoreCase;
    private final boolean longestOnly;
    private Dictionary dictionary;

    public HunspellStemFilterFactory(Map<String, String> args) {
        super(args);
        this.dictionaryFiles = this.require(args, PARAM_DICTIONARY);
        this.affixFile = this.get(args, PARAM_AFFIX);
        this.ignoreCase = this.getBoolean(args, PARAM_IGNORE_CASE, false);
        this.longestOnly = this.getBoolean(args, PARAM_LONGEST_ONLY, false);
        this.getBoolean(args, "strictAffixParsing", true);
        this.getInt(args, PARAM_RECURSION_CAP, 0);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String[] dicts = this.dictionaryFiles.split(",");
        InputStream affix = null;
        ArrayList<InputStream> dictionaries = new ArrayList<InputStream>();
        try {
            dictionaries = new ArrayList();
            for (String file : dicts) {
                dictionaries.add(loader.openResource(file));
            }
            affix = loader.openResource(this.affixFile);
            Path tempPath = Files.createTempDirectory(Dictionary.getDefaultTempDir(), "Hunspell", new FileAttribute[0]);
            try (FSDirectory tempDir = FSDirectory.open((Path)tempPath);){
                this.dictionary = new Dictionary((Directory)tempDir, "hunspell", affix, dictionaries, this.ignoreCase);
            }
            catch (Throwable throwable) {
                IOUtils.rm((Path[])new Path[]{tempPath});
                throw throwable;
            }
            IOUtils.rm((Path[])new Path[]{tempPath});
        }
        catch (ParseException e) {
            try {
                throw new IOException("Unable to load hunspell data! [dictionary=" + dictionaries + ",affix=" + this.affixFile + "]", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affix});
                IOUtils.closeWhileHandlingException(dictionaries);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affix});
        IOUtils.closeWhileHandlingException(dictionaries);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HunspellStemFilter(tokenStream, this.dictionary, true, this.longestOnly);
    }
}

