/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.navigation;

import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.dc.DcCreatorElement;
import org.odftoolkit.odfdom.dom.element.dc.DcDateElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextConditionalTextElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.element.text.TextUserFieldDeclElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextHeading;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextSpan;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.common.TextExtractor;
import org.odftoolkit.simple.common.field.ConditionField;
import org.odftoolkit.simple.common.field.Field;
import org.odftoolkit.simple.common.field.Fields;
import org.odftoolkit.simple.common.field.VariableField;
import org.odftoolkit.simple.common.navigation.FieldSelection;
import org.odftoolkit.simple.common.navigation.ImageSelection;
import org.odftoolkit.simple.common.navigation.InvalidNavigationException;
import org.odftoolkit.simple.common.navigation.Navigation;
import org.odftoolkit.simple.common.navigation.ParagraphSelection;
import org.odftoolkit.simple.common.navigation.Selection;
import org.odftoolkit.simple.common.navigation.TableSelection;
import org.odftoolkit.simple.common.navigation.TextDocumentSelection;
import org.odftoolkit.simple.common.navigation.TextNavigation;
import org.odftoolkit.simple.draw.Image;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.text.Paragraph;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextSelection
extends Selection {
    String mMatchedText;
    private OdfTextParagraph mParagraph;
    private OdfTextHeading mHeading;
    private int mIndexInContainer;
    private boolean mIsInserted;
    private boolean isSelectionReplaced = false;

    TextSelection(Navigation search, String text, OdfElement containerElement, int index) {
        this.search = search;
        this.mMatchedText = text;
        if (containerElement instanceof OdfTextParagraph) {
            this.mParagraph = (OdfTextParagraph)containerElement;
        } else if (containerElement instanceof OdfTextHeading) {
            this.mHeading = (OdfTextHeading)containerElement;
        }
        this.mIndexInContainer = index;
    }

    public TextNavigation getTextNavigation() {
        if (this.search instanceof TextNavigation) {
            return (TextNavigation)this.search;
        }
        return null;
    }

    public static TextSelection newTextSelection(Navigation search, String text, OdfElement containerElement, int index) {
        TextSelection selection = new TextSelection(search, text, containerElement, index);
        search.mDocument.getSelectionManager().registerItem(selection);
        return selection;
    }

    @Override
    public OdfElement getElement() {
        return this.getContainerElement();
    }

    public OdfElement getContainerElement() {
        if (this.mParagraph != null) {
            return this.mParagraph;
        }
        return this.mHeading;
    }

    @Override
    public int getIndex() {
        return this.mIndexInContainer;
    }

    public String getText() {
        return this.mMatchedText;
    }

    @Override
    public void cut() throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement container = this.getContainerElement();
        this.delete(this.mIndexInContainer, this.mMatchedText.length(), (Node)container);
        this.search.mDocument.getSelectionManager().refreshAfterCut(this);
        this.mMatchedText = "";
    }

    public void applyStyle(OdfStyleBase style) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        int leftLength = this.getText().length();
        int index = this.mIndexInContainer;
        this.appendStyle(index, leftLength, (Node)parentElement, style);
    }

    public void replaceWith(String newText) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        int leftLength = this.getText().length();
        int index = this.mIndexInContainer;
        this.delete(index, leftLength, (Node)parentElement);
        OdfTextSpan textSpan = new OdfTextSpan((OdfFileDom)parentElement.getOwnerDocument());
        textSpan.addContentWhitespace(newText);
        this.mIsInserted = false;
        this.insertOdfElement((OdfElement)textSpan, index, (Node)parentElement);
        this.optimize((Node)parentElement);
        int offset = newText.length() - leftLength;
        this.search.mDocument.getSelectionManager().refresh(this.getContainerElement(), offset, index + this.getText().length());
        this.mMatchedText = newText;
    }

    public Table replaceWith(Table newTable) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        TableSelection nextTableSelection = new TableSelection(this);
        return nextTableSelection.replaceWithTable(newTable);
    }

    public Image replaceWith(Image newImage) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        ImageSelection nextImageSelection = new ImageSelection(this);
        return nextImageSelection.replaceWithImage(newImage);
    }

    public Image replaceWith(URI imageUri) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        ImageSelection nextImageSelection = new ImageSelection(this);
        return nextImageSelection.replaceWithImage(imageUri);
    }

    public Field replaceWith(Field orgField) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        Field newfield = null;
        OdfElement parentElement = this.getContainerElement();
        Paragraph orgparagraph = Paragraph.getInstanceof((TextParagraphElementBase)parentElement);
        TextDocument document = (TextDocument)orgparagraph.getOwnerDocument();
        FieldSelection nextFieldSelection = new FieldSelection(this);
        Field.FieldType fieldType = orgField.getFieldType();
        switch (fieldType) {
            case DATE_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case FIXED_DATE_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case TIME_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case FIXED_TIME_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case PREVIOUS_PAGE_NUMBER_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case CURRENT_PAGE_NUMBER_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case NEXT_PAGE_NUMBER_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case PAGE_COUNT_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case TITLE_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case SUBJECT_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case AUTHOR_NAME_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case AUTHOR_INITIALS_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case CHAPTER_FIELD: {
                newfield = nextFieldSelection.replaceWithSimpleField(fieldType);
                break;
            }
            case SIMPLE_VARIABLE_FIELD: {
                VariableField SimpleVariableField = (VariableField)orgField;
                String simplefieldname = SimpleVariableField.getVariableName();
                VariableField simplefield = Fields.createSimpleVariableField(document, simplefieldname);
                nextFieldSelection.replaceWithVariableField(simplefield);
                newfield = simplefield;
                break;
            }
            case USER_VARIABLE_FIELD: {
                VariableField userVariableField = (VariableField)orgField;
                TextUserFieldDeclElement textUserFieldDeclElement = (TextUserFieldDeclElement)userVariableField.getOdfElement();
                String fieldname = userVariableField.getVariableName();
                String value = textUserFieldDeclElement.getOfficeStringValueAttribute();
                VariableField variableField = Fields.createUserVariableField(document, fieldname, value);
                nextFieldSelection.replaceWithVariableField(variableField);
                newfield = variableField;
                break;
            }
            case CONDITION_FIELD: {
                ConditionField conditionField = (ConditionField)orgField;
                TextConditionalTextElement textConditionalTextElement = (TextConditionalTextElement)conditionField.getOdfElement();
                String StringValueIfFalse = textConditionalTextElement.getTextStringValueIfFalseAttribute();
                String StringValueIfTrue = textConditionalTextElement.getTextStringValueIfTrueAttribute();
                String StringCondition = textConditionalTextElement.getTextConditionAttribute();
                boolean CurrentValue = textConditionalTextElement.getTextCurrentValueAttribute();
                ConditionField newdConditionField = nextFieldSelection.replaceWithConditionField(StringCondition, StringValueIfTrue, StringValueIfFalse);
                TextConditionalTextElement newTextConditionalTextElement = (TextConditionalTextElement)newdConditionField.getOdfElement();
                newTextConditionalTextElement.setTextCurrentValueAttribute(Boolean.valueOf(CurrentValue));
                newfield = newdConditionField;
                break;
            }
            case HIDDEN_TEXT_FIELD: {
                ConditionField conditionFieldHIDDEN = (ConditionField)orgField;
                TextConditionalTextElement textConditionalTextElementHIDDEN = (TextConditionalTextElement)conditionFieldHIDDEN.getOdfElement();
                String StringValueIfFalseHIDDEN = textConditionalTextElementHIDDEN.getTextStringValueIfFalseAttribute();
                String StringConditionHIDDEN = textConditionalTextElementHIDDEN.getTextConditionAttribute();
                boolean CurrentValueHIDDEN = textConditionalTextElementHIDDEN.getTextCurrentValueAttribute();
                ConditionField newdConditionFieldHIDDEN = nextFieldSelection.replaceWithHiddenTextField(StringConditionHIDDEN, StringValueIfFalseHIDDEN);
                TextConditionalTextElement newTextConditionalTextElementHIDDEN = (TextConditionalTextElement)newdConditionFieldHIDDEN.getOdfElement();
                newTextConditionalTextElementHIDDEN.setTextCurrentValueAttribute(Boolean.valueOf(CurrentValueHIDDEN));
                newfield = newdConditionFieldHIDDEN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Simple Java API for ODF doesn't support this type now.");
            }
        }
        return newfield;
    }

    public Paragraph replaceWith(Paragraph newParagraph) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        ParagraphSelection nextParagraphSelection = new ParagraphSelection(this);
        return nextParagraphSelection.replaceWithParagraph(newParagraph);
    }

    public void replaceWith(TextDocument newTextDocument) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        TextDocumentSelection nextTextDocumentSelection = new TextDocumentSelection(this);
        try {
            nextTextDocumentSelection.replaceWithTextDocument(newTextDocument);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TextSpanElement createSpanElement() throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        int leftLength = this.getText().length();
        int index = this.mIndexInContainer;
        this.delete(index, leftLength, (Node)parentElement);
        OdfTextSpan textSpan = new OdfTextSpan((OdfFileDom)parentElement.getOwnerDocument());
        textSpan.addContentWhitespace(this.getText());
        this.mIsInserted = false;
        this.insertOdfElement((OdfElement)textSpan, index, (Node)parentElement);
        this.optimize((Node)parentElement);
        return textSpan;
    }

    @Override
    public void pasteAtFrontOf(Selection positionItem) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        int indexOfNew = 0;
        OdfElement newElement = positionItem.getElement();
        if (positionItem instanceof TextSelection) {
            indexOfNew = ((TextSelection)positionItem).getIndex();
            newElement = ((TextSelection)positionItem).getContainerElement();
        }
        OdfTextSpan textSpan = this.getSpan((OdfFileDom)positionItem.getElement().getOwnerDocument());
        this.mIsInserted = false;
        this.insertOdfElement((OdfElement)textSpan, indexOfNew, (Node)newElement);
        this.adjustStyle((Node)newElement, textSpan, null);
        this.search.mDocument.getSelectionManager().refreshAfterPasteAtFrontOf(this, positionItem);
    }

    @Override
    public void pasteAtEndOf(Selection positionItem) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        int indexOfNew = 0;
        OdfElement newElement = positionItem.getElement();
        if (positionItem instanceof TextSelection) {
            indexOfNew = ((TextSelection)positionItem).getIndex() + ((TextSelection)positionItem).getText().length();
            newElement = ((TextSelection)positionItem).getContainerElement();
        }
        OdfTextSpan textSpan = this.getSpan((OdfFileDom)positionItem.getElement().getOwnerDocument());
        this.mIsInserted = false;
        this.insertOdfElement((OdfElement)textSpan, indexOfNew, (Node)newElement);
        this.adjustStyle((Node)newElement, textSpan, null);
        this.search.mDocument.getSelectionManager().refreshAfterPasteAtEndOf(this, positionItem);
    }

    public void setSelectionReplaced(boolean b) {
        this.isSelectionReplaced = b;
    }

    public boolean isSelectionReplaced() {
        return this.isSelectionReplaced;
    }

    public void addHref(URL url) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        int leftLength = this.getText().length();
        int index = this.mIndexInContainer;
        this.addHref(index, leftLength, (Node)parentElement, url.toString());
    }

    public void addComment(String content, String creator) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        OdfFileDom dom = (OdfFileDom)parentElement.getOwnerDocument();
        OfficeAnnotationElement annotationElement = (OfficeAnnotationElement)dom.newOdfElement(OfficeAnnotationElement.class);
        DcCreatorElement dcCreatorElement = annotationElement.newDcCreatorElement();
        if (creator == null) {
            creator = System.getProperty("user.name");
        }
        dcCreatorElement.setTextContent(creator);
        String dcDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
        DcDateElement dcDateElement = annotationElement.newDcDateElement();
        dcDateElement.setTextContent(dcDate);
        TextPElement notePElement = annotationElement.newTextPElement();
        TextSpanElement noteSpanElement = notePElement.newTextSpanElement();
        OdfOfficeAutomaticStyles styles = null;
        if (dom instanceof OdfContentDom) {
            styles = ((OdfContentDom)dom).getAutomaticStyles();
        } else if (dom instanceof OdfStylesDom) {
            styles = ((OdfStylesDom)dom).getAutomaticStyles();
        }
        OdfStyle textStyle = styles.newStyle(OdfStyleFamily.Text);
        StyleTextPropertiesElement styleTextPropertiesElement = textStyle.newStyleTextPropertiesElement(null);
        styleTextPropertiesElement.setStyleFontNameAttribute("Tahoma");
        styleTextPropertiesElement.setFoFontSizeAttribute("10pt");
        styleTextPropertiesElement.setStyleFontNameAsianAttribute("Lucida Sans Unicode");
        styleTextPropertiesElement.setStyleFontSizeAsianAttribute("12pt");
        noteSpanElement.setStyleName(textStyle.getStyleNameAttribute());
        noteSpanElement.setTextContent(content);
        this.insertOdfElement((OdfElement)annotationElement, this.mIndexInContainer, (Node)parentElement);
        int offset = content.length() + 1 + dcDate.length() + 1 + creator.length();
        this.search.mDocument.getSelectionManager().refresh(this.getContainerElement(), offset, this.getIndex());
    }

    public String toString() {
        return "[" + this.mMatchedText + "] started from " + this.mIndexInContainer + " in paragraph:" + TextExtractor.getText(this.getContainerElement());
    }

    @Override
    protected void refreshAfterFrontalDelete(Selection deleteItem) {
        if (deleteItem instanceof TextSelection) {
            this.mIndexInContainer -= ((TextSelection)deleteItem).getText().length();
        }
    }

    @Override
    protected void refreshAfterFrontalInsert(Selection pasteItem) {
        if (pasteItem instanceof TextSelection) {
            this.mIndexInContainer += ((TextSelection)pasteItem).getText().length();
        }
    }

    @Override
    protected void refresh(int offset) {
        this.mIndexInContainer += offset;
        if (this.mIndexInContainer < 0) {
            this.mIndexInContainer = 0;
        }
    }

    void cleanBreakProperty(Paragraph paragraph) {
        TextNavigation search = this.getTextNavigation();
        if (search == null) {
            throw new IllegalStateException("Navigation is null");
        }
        OdfStyleBase styleElement = paragraph.getStyleHandler().getStyleElementForRead();
        String name = styleElement.getAttribute("style:name");
        String newName = null;
        OdfElement modifiedStyleElement = search.getModifiedStyleElement((OdfElement)styleElement);
        if (modifiedStyleElement == null) {
            modifiedStyleElement = (OdfElement)styleElement.cloneNode(true);
            search.addModifiedStyleElement((OdfElement)styleElement, modifiedStyleElement);
            NodeList paragraphProperties = modifiedStyleElement.getElementsByTagName("style:paragraph-properties");
            if (paragraphProperties != null && paragraphProperties.getLength() > 0) {
                StyleParagraphPropertiesElement property = (StyleParagraphPropertiesElement)paragraphProperties.item(0);
                property.removeAttribute("fo:break-before");
                property.removeAttribute("fo:break-after");
                property.removeAttribute("style:page-number");
            }
            modifiedStyleElement.removeAttribute("style:master-page-name");
            newName = name + "-" + this.makeUniqueName();
            NamedNodeMap attributes = modifiedStyleElement.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node item = attributes.item(i);
                    String value = item.getNodeValue();
                    if (!name.equals(value)) continue;
                    item.setNodeValue(newName);
                    break;
                }
            }
            styleElement.getParentNode().appendChild((Node)modifiedStyleElement);
        } else {
            newName = modifiedStyleElement.getAttribute("style:name");
        }
        NamedNodeMap attributes = paragraph.getOdfElement().getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node item = attributes.item(i);
                String value = item.getNodeValue();
                if (!name.equals(value)) continue;
                item.setNodeValue(newName);
                break;
            }
        }
        this.getTextNavigation().setHandlePageBreak(true);
    }

    String makeUniqueName() {
        return String.format("p%06x", (int)(Math.random() * 1.6777215E7));
    }

    private OdfTextSpan getSpan(OdfFileDom ownerDoc) {
        OdfElement parentElement = this.getContainerElement();
        if (parentElement != null) {
            OdfElement copyParentNode = (OdfElement)parentElement.cloneNode(true);
            if (ownerDoc != parentElement.getOwnerDocument()) {
                copyParentNode = (OdfElement)ownerDoc.adoptNode((Node)copyParentNode);
            }
            OdfTextSpan textSpan = new OdfTextSpan(ownerDoc);
            int sIndex = this.mIndexInContainer;
            int eIndex = sIndex + this.mMatchedText.length();
            this.delete(eIndex, TextExtractor.getText(copyParentNode).length() - eIndex, (Node)copyParentNode);
            this.delete(0, sIndex, (Node)copyParentNode);
            this.optimize((Node)copyParentNode);
            for (Node childNode = copyParentNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                textSpan.appendChild(childNode.cloneNode(true));
            }
            if (copyParentNode instanceof OdfStylableElement) {
                this.applyTextStyleProperties(this.getTextStylePropertiesDeep((OdfStylableElement)copyParentNode), (OdfStylableElement)textSpan);
            }
            return textSpan;
        }
        return null;
    }

    private void optimize(Node pNode) {
        Node node = pNode.getFirstChild();
        while (node != null) {
            Node nextNode = node.getNextSibling();
            if (node instanceof OdfTextSpan) {
                if (TextExtractor.getText((OdfElement)((OdfTextSpan)node)).length() == 0) {
                    node.getParentNode().removeChild(node);
                } else {
                    this.optimize(node);
                }
            }
            node = nextNode;
        }
    }

    private void applyTextStyleProperties(Map<OdfStyleProperty, String> styleMap, OdfStylableElement toElement) {
        if (styleMap != null) {
            OdfStyle resultStyleElement = toElement.getAutomaticStyles().newStyle(OdfStyleFamily.Text);
            for (Map.Entry<OdfStyleProperty, String> entry : styleMap.entrySet()) {
                if (toElement.hasProperty(entry.getKey())) {
                    resultStyleElement.setProperty(entry.getKey(), toElement.getProperty(entry.getKey()));
                    continue;
                }
                resultStyleElement.setProperty(entry.getKey(), entry.getValue());
            }
            toElement.setStyleName(resultStyleElement.getStyleNameAttribute());
        }
    }

    private void insertOdfElement(OdfElement odfElement, int fromIndex, Node pNode) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex == 0 && this.mIsInserted) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex <= 0 && this.mIsInserted) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
                if (fromIndex != 0 && nodeLength < fromIndex) {
                    fromIndex -= nodeLength;
                    continue;
                }
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromIndex));
                node.setNodeValue(buffer.toString());
                Node nextNode = node.getNextSibling();
                Node parNode = node.getParentNode();
                Node newNode = node.cloneNode(true);
                newNode.setNodeValue(value.substring(fromIndex, value.length()));
                if (nextNode != null) {
                    parNode.insertBefore((Node)odfElement, nextNode);
                    parNode.insertBefore(newNode, nextNode);
                } else {
                    parNode.appendChild((Node)odfElement);
                    parNode.appendChild(newNode);
                }
                this.mIsInserted = true;
                return;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                try {
                    nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                }
                catch (Exception e) {
                    nodeLength = 1;
                }
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getLocalName().equals("line-break")) {
                nodeLength = 1;
                --fromIndex;
                continue;
            }
            if (node.getLocalName().equals("tab")) {
                nodeLength = 1;
                --fromIndex;
                continue;
            }
            nodeLength = TextExtractor.getText((OdfElement)node).length();
            this.insertOdfElement(odfElement, fromIndex, node);
            fromIndex -= nodeLength;
        }
    }

    private void adjustStyle(Node parentNode, OdfTextSpan textSpan, Map<OdfStyleProperty, String> styleMap) {
        if (parentNode instanceof OdfStylableElement) {
            OdfStylableElement pStyleNode = (OdfStylableElement)parentNode;
            if (styleMap == null) {
                styleMap = this.getTextStylePropertiesDeep(pStyleNode);
            }
            for (Node node = parentNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() == 3) {
                    if (node.getTextContent().length() <= 0) continue;
                    Node nextNode = node.getNextSibling();
                    OdfTextSpan span = new OdfTextSpan((OdfFileDom)node.getOwnerDocument());
                    span.appendChild(node);
                    if (nextNode != null) {
                        parentNode.insertBefore((Node)span, nextNode);
                    } else {
                        parentNode.appendChild((Node)span);
                    }
                    node = span;
                    this.applyTextStyleProperties(styleMap, (OdfStylableElement)node);
                    continue;
                }
                if (!(node instanceof OdfStylableElement) || node.equals(textSpan)) continue;
                Map<OdfStyleProperty, String> styles = this.getTextStylePropertiesDeep(pStyleNode);
                Map<OdfStyleProperty, String> styles1 = this.getTextStylePropertiesDeep((OdfStylableElement)node);
                if (styles == null) {
                    styles = styles1;
                } else if (styles1 != null) {
                    styles.putAll(styles1);
                }
                short comp = node.compareDocumentPosition((Node)textSpan);
                if ((comp & 0x10) > 0) {
                    this.adjustStyle(node, textSpan, styles);
                    continue;
                }
                this.applyTextStyleProperties(styles, (OdfStylableElement)node);
            }
            pStyleNode.removeAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name");
        }
    }

    private void delete(int fromIndex, int leftLength, Node pNode) {
        if (fromIndex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        Node node = pNode.getFirstChild();
        while (node != null) {
            if (fromIndex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : TextExtractor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromIndex) {
                fromIndex -= nodeLength;
            } else if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromIndex));
                int endLength = fromIndex + leftLength;
                int nextLength = value.length() - endLength;
                fromIndex = 0;
                if (nextLength >= 0) {
                    buffer.append(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    leftLength = endLength - value.length();
                }
                node.setNodeValue(buffer.toString());
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromIndex));
                    leftLength -= nodeLength - fromIndex;
                    fromIndex = 0;
                } else {
                    if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                        fromIndex = 0;
                        --leftLength;
                        Node nodeMerker = node.getNextSibling();
                        pNode.removeChild(node);
                        node = nodeMerker;
                        continue;
                    }
                    this.delete(fromIndex, leftLength, node);
                    int length = fromIndex + leftLength - nodeLength;
                    leftLength = length > 0 ? length : 0;
                    fromIndex = 0;
                }
            }
            node = node.getNextSibling();
        }
    }

    private void addHref(int fromIndex, int leftLength, Node pNode, String href) {
        if (fromIndex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : TextExtractor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromIndex) {
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                node.setNodeValue(value.substring(0, fromIndex));
                int endLength = fromIndex + leftLength;
                int nextLength = value.length() - endLength;
                Node nextNode = node.getNextSibling();
                Node parNode = node.getParentNode();
                TextAElement textLink = new TextAElement((OdfFileDom)node.getOwnerDocument());
                Node newNode = null;
                if (nextLength >= 0) {
                    textLink.setTextContent(value.substring(fromIndex, endLength));
                    newNode = node.cloneNode(true);
                    newNode.setNodeValue(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    textLink.setTextContent(value.substring(fromIndex, value.length()));
                    leftLength = endLength - value.length();
                }
                textLink.setXlinkTypeAttribute("simple");
                textLink.setXlinkHrefAttribute(href);
                if (nextNode != null) {
                    parNode.insertBefore((Node)textLink, nextNode);
                    if (newNode != null) {
                        parNode.insertBefore(newNode, nextNode);
                    }
                } else {
                    parNode.appendChild((Node)textLink);
                    if (newNode != null) {
                        parNode.appendChild(newNode);
                    }
                }
                fromIndex = 0;
                if (nextNode != null) {
                    node = nextNode;
                    continue;
                }
                node = textLink;
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromIndex));
                leftLength -= nodeLength - fromIndex;
                fromIndex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromIndex = 0;
                --leftLength;
                continue;
            }
            this.addHref(fromIndex, leftLength, node, href);
            int length = fromIndex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromIndex = 0;
        }
    }

    private Map<OdfStyleProperty, String> getTextStyleProperties(OdfStylableElement element) {
        String styleName = element.getStyleName();
        OdfStyle styleElement = element.getAutomaticStyles().getStyle(styleName, element.getStyleFamily());
        if (styleElement == null) {
            styleElement = element.getDocumentStyle();
        }
        if (styleElement != null) {
            if (styleElement.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties) == null && styleElement.getPropertiesElement(OdfStylePropertiesSet.TextProperties) == null) {
                styleElement = ((Document)((OdfFileDom)styleElement.getOwnerDocument()).getDocument()).getDocumentStyles().getDefaultStyle(styleElement.getFamily());
            }
            TreeMap<OdfStyleProperty, String> result = new TreeMap<OdfStyleProperty, String>();
            OdfStyleFamily family = OdfStyleFamily.Text;
            if (family != null) {
                for (OdfStyleProperty property : family.getProperties()) {
                    if (!styleElement.hasProperty(property)) continue;
                    result.put(property, styleElement.getProperty(property));
                }
            }
            return result;
        }
        return null;
    }

    private Map<OdfStyleProperty, String> getTextStylePropertiesDeep(OdfStylableElement element) {
        String styleName = element.getStyleName();
        OdfStyle styleElement = element.getAutomaticStyles().getStyle(styleName, element.getStyleFamily());
        if (styleElement == null) {
            styleElement = element.getDocumentStyle();
        }
        TreeMap<OdfStyleProperty, String> result = new TreeMap<OdfStyleProperty, String>();
        while (styleElement != null) {
            OdfStyleFamily family;
            if (styleElement.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties) == null && styleElement.getPropertiesElement(OdfStylePropertiesSet.TextProperties) == null) {
                styleElement = ((Document)((OdfFileDom)styleElement.getOwnerDocument()).getDocument()).getDocumentStyles().getDefaultStyle(styleElement.getFamily());
            }
            if ((family = OdfStyleFamily.Text) != null) {
                for (OdfStyleProperty property : family.getProperties()) {
                    if (!styleElement.hasProperty(property)) continue;
                    result.put(property, styleElement.getProperty(property));
                }
            }
            styleElement = styleElement.getParentStyle();
        }
        return result;
    }

    private boolean validate() {
        if (this.getContainerElement() == null) {
            return false;
        }
        OdfElement container = this.getContainerElement();
        if (container == null) {
            return false;
        }
        String content = TextExtractor.getText(container);
        return content.indexOf(this.mMatchedText, this.mIndexInContainer) == this.mIndexInContainer;
    }

    private void appendStyle(int fromIndex, int leftLength, Node pNode, OdfStyleBase style) {
        if (fromIndex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : TextExtractor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromIndex) {
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                node.setNodeValue(value.substring(0, fromIndex));
                int endLength = fromIndex + leftLength;
                int nextLength = value.length() - endLength;
                Node nextNode = node.getNextSibling();
                Node parNode = node.getParentNode();
                OdfTextSpan textSpan = new OdfTextSpan((OdfFileDom)node.getOwnerDocument());
                Node newNode = null;
                if (nextLength >= 0) {
                    textSpan.setTextContent(value.substring(fromIndex, endLength));
                    newNode = node.cloneNode(true);
                    newNode.setNodeValue(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    textSpan.setTextContent(value.substring(fromIndex, value.length()));
                    leftLength = endLength - value.length();
                }
                textSpan.setProperties(style.getStyleProperties());
                if (nextNode != null) {
                    parNode.insertBefore((Node)textSpan, nextNode);
                    if (newNode != null) {
                        parNode.insertBefore(newNode, nextNode);
                    }
                } else {
                    parNode.appendChild((Node)textSpan);
                    if (newNode != null) {
                        parNode.appendChild(newNode);
                    }
                }
                fromIndex = 0;
                if (nextNode != null) {
                    node = nextNode;
                    continue;
                }
                node = textSpan;
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromIndex));
                leftLength -= nodeLength - fromIndex;
                fromIndex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromIndex = 0;
                --leftLength;
                continue;
            }
            this.appendStyle(fromIndex, leftLength, node, style);
            int length = fromIndex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromIndex = 0;
        }
    }
}

