/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.blog.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.blog.BlogContentManager;
import org.silverpeas.components.blog.dao.PostDAO;
import org.silverpeas.components.blog.model.Archive;
import org.silverpeas.components.blog.model.BlogRuntimeException;
import org.silverpeas.components.blog.model.Category;
import org.silverpeas.components.blog.model.PostDetail;
import org.silverpeas.components.blog.notification.BlogUserSubscriptionNotification;
import org.silverpeas.components.blog.service.BlogFilters;
import org.silverpeas.components.blog.service.BlogService;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.comment.service.CommentService;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.dao.PublicationCriteria;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.html.PermalinkRegistry;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.search.SearchEngineProvider;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodeOrderComparator;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.pdc.subscription.service.PdcSubscriptionManager;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionService;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.subscription.service.ComponentSubscription;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Named(value="blogService")
public class DefaultBlogService
implements BlogService,
Initialization {
    private static final String MESSAGES_PATH = "org.silverpeas.blog.multilang.blogBundle";
    private static final String SETTINGS_PATH = "org.silverpeas.blog.settings.blogSettings";
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.blog.settings.blogSettings");
    private static final String POST = "post";
    private static final String USELESS = "useless";
    @Inject
    private CommentService commentService;
    @Inject
    private PdcManager pdcManager;
    @Inject
    private PdcSubscriptionManager pdcSubscriptionManager;
    @Inject
    private BlogContentManager blogContentManager;
    @Inject
    private NodeService nodeService;
    @Inject
    private PublicationService publicationService;

    public void init() {
        PermalinkRegistry.get().addUrlPart("Post");
    }

    @Override
    public Optional<PostDetail> getContributionById(ContributionIdentifier contributionId) {
        PublicationDetail publication = this.publicationService.getDetail(new PublicationPK(contributionId.getLocalId(), contributionId.getComponentInstanceId()));
        return publication == null ? Optional.empty() : this.toPosts(publication.getInstanceId(), List.of(publication)).stream().findFirst();
    }

    public SettingBundle getComponentSettings() {
        return settings;
    }

    public LocalizationBundle getComponentMessages(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith("blog");
    }

    private Map<String, Date> getEventDateIndexedByPost(Collection<String> pubIds) {
        try {
            return PostDAO.getEventDateIndexedByPost(pubIds);
        }
        catch (SQLException e) {
            throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)POST, pubIds), e);
        }
    }

    @Override
    @Transactional
    public String createPost(PostDetail post) {
        return this.createPost(post, null);
    }

    @Override
    @Transactional
    public String createPost(PostDetail post, PdcClassification classification) {
        String string;
        block10: {
            Connection con = this.openConnection();
            try {
                PublicationDetail pub = post.getPublication();
                pub.setStatus("Draft");
                PublicationPK pk = this.publicationService.createPublication(pub);
                PostDAO.create(con, pk.getId(), post.getDateEvent(), pk.getInstanceId());
                if (StringUtil.isDefined((String)post.getCategoryId())) {
                    this.setCategory(pk, post.getCategoryId());
                }
                WysiwygController.createUnindexedFileAndAttachment((String)"", (ResourceReference)new ResourceReference((WAPrimaryKey)pk), (String)pub.getCreatorId(), (String)pub.getLanguage());
                this.createSilverContent(con, pub, pub.getCreatorId());
                if (classification != null) {
                    classification.classifyContent((Contribution)pub);
                }
                string = pk.getId();
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnAdding((String)POST, (Object)post.getId()), e);
                }
            }
            con.close();
        }
        return string;
    }

    @Override
    public void sendSubscriptionsNotification(NodePK fatherPK, PostDetail post, Comment comment, String type, String senderId) {
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new BlogUserSubscriptionNotification(post, comment, type, senderId));
        try {
            PublicationPK pubPK = post.getPublication().getPK();
            int silverObjectId = this.getSilverObjectId(pubPK);
            List positions = this.pdcManager.getPositions(silverObjectId, pubPK.getInstanceId());
            if (positions != null) {
                for (ClassifyPosition position : positions) {
                    this.pdcSubscriptionManager.checkSubscriptions(position.getValues(), pubPK.getInstanceId(), silverObjectId);
                }
            }
        }
        catch (PdcException e) {
            SilverLogger.getLogger((Object)this).error("PdC subscriber notification failure", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void updatePost(PostDetail post, PdcClassification classification) {
        try (Connection con = this.openConnection();){
            PublicationPK pubPk = post.getPublication().getPK();
            PublicationDetail pub = post.getPublication();
            this.publicationService.removeAllFathers(pubPk);
            this.publicationService.setDetail(pub);
            if (StringUtil.isDefined((String)post.getCategoryId())) {
                this.setCategory(pubPk, post.getCategoryId());
            }
            PostDAO.update(con, pubPk.getId(), post.getDateEvent());
            WysiwygController.updateFileAndAttachment((String)post.getContent(), (String)pub.getInstanceId(), (String)pubPk.getId(), (String)pub.getUpdaterId(), (String)pub.getLanguage(), (boolean)false);
            if (classification != null) {
                classification.classifyContentOrClearClassificationIfEmpty((Contribution)pub, false);
            }
            if (pub.isValid()) {
                this.sendSubscriptionsNotification(new NodePK("0", pub.getPK().getSpaceId(), pub.getPK().getInstanceId()), post, null, "update", pub.getUpdaterId());
            }
        }
        catch (SQLException e) {
            throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnUpdate((String)POST, (Object)post.getId()), e);
        }
    }

    private void setCategory(PublicationPK pk, String categoryId) {
        NodePK nodePK = new NodePK(categoryId, pk.getInstanceId());
        this.publicationService.addFather(pk, nodePK);
    }

    @Override
    @Transactional
    public void deletePost(String instanceId, String postId) {
        try (Connection con = this.openConnection();){
            PublicationPK pubPK = new PublicationPK(postId, instanceId);
            this.publicationService.removeAllFathers(pubPK);
            PostDAO.delete(con, pubPK.getId());
            ResourceReference resourceReference = new ResourceReference(postId, instanceId);
            this.getCommentService().deleteAllCommentsOnResource(PostDetail.getResourceType(), resourceReference);
            WysiwygController.deleteFileAndAttachment((String)instanceId, (String)postId);
            this.publicationService.removePublication(pubPK);
            this.blogContentManager.deleteSilverContent(con, pubPK);
        }
        catch (Exception e) {
            throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnDeleting((String)POST, (Object)postId), e);
        }
    }

    private Connection openConnection() {
        Connection con;
        try {
            con = DBUtil.openConnection();
        }
        catch (SQLException e) {
            throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnOpeningConnectionTo((String)"datasource"), e);
        }
        return con;
    }

    @Nonnull
    private List<PostDetail> toPosts(String instanceId, Collection<PublicationDetail> publications) {
        if (!publications.isEmpty()) {
            Map<Location, Category> categoryByAllNodePKs = this.nodeService.getAllNodes(new NodePK(null, instanceId)).stream().collect(Collectors.toMap(n -> new Location(n.getId(), instanceId), Category::new));
            Collection pubIds = publications.stream().map(PublicationDetail::getPK).map(WAPrimaryKey::getId).collect(Collectors.toSet());
            Map<String, Category> allLocationsByPublicationIds = this.publicationService.getAllLocationsByPublicationIds(pubIds).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Category)((Object)((Object)categoryByAllNodePKs.get(((List)e.getValue()).get(0))))));
            Map<String, Date> eventDateByPost = this.getEventDateIndexedByPost(pubIds);
            Map<String, Integer> commentsByPubIds = this.getCommentService().getCommentCountIndexedByResource(PostDetail.getResourceType(), instanceId).entrySet().stream().collect(Collectors.toMap(e -> ((ResourceReference)e.getKey()).getLocalId(), Map.Entry::getValue));
            Date defaultDate = new Date();
            return publications.stream().map(p -> {
                String pubId = p.getPK().getId();
                Category cat = (Category)((Object)((Object)allLocationsByPublicationIds.get(pubId)));
                Date dateEvent = eventDateByPost.getOrDefault(pubId, defaultDate);
                int nbComments = commentsByPubIds.getOrDefault(pubId, 0);
                PostDetail post = new PostDetail((PublicationDetail)p, cat, nbComments, dateEvent);
                post.setCreatorName(p.getCreator().getDisplayedName());
                return post;
            }).collect(Collectors.toList());
        }
        return List.of();
    }

    @Override
    public Collection<PostDetail> getLastPosts(String instanceId, BlogFilters filters) {
        List<PostDetail> list;
        block8: {
            Connection con = this.openConnection();
            try {
                Collection<String> allPostIds = PostDAO.getAllPostIds(con, instanceId);
                Stream<PublicationDetail> publications = this.filterPublications(this.publicationService.getByIds(allPostIds).stream(), filters);
                list = this.toPosts(instanceId, publications.collect(Collectors.toList()));
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"all posts of blog", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public Collection<PostDetail> getAllPosts(String instanceId) {
        return this.getLastPosts(instanceId, new BlogFilters(true));
    }

    @Override
    public Collection<PostDetail> getLastValidPosts(String instanceId, BlogFilters filters) {
        List<PostDetail> list;
        block8: {
            Connection con = this.openConnection();
            try {
                Collection<String> allPostIds = PostDAO.getAllPostIds(con, instanceId);
                Stream<PublicationDetail> publications = this.publicationService.getByIds(allPostIds).stream().filter(p -> "Valid".equals(p.getStatus()));
                list = this.toPosts(instanceId, this.filterPublications(publications, filters).collect(Collectors.toList()));
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"All validated posts for blog", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public Collection<PostDetail> getPostsByCategory(String instanceId, String categoryId, BlogFilters filters) {
        List<PostDetail> list;
        block8: {
            Connection con = this.openConnection();
            try {
                Collection<String> allPostIds = PostDAO.getAllPostIds(con, instanceId);
                Map<String, PublicationDetail> categoryPublications = this.publicationService.getPublicationsByCriteria(PublicationCriteria.onComponentInstanceIds((String[])new String[]{instanceId}).onNodes(new String[]{categoryId})).stream().collect(Collectors.toMap(PublicationDetail::getId, p -> p));
                Stream<PublicationDetail> publications = allPostIds.stream().map(categoryPublications::get).filter(Objects::nonNull);
                list = this.toPosts(instanceId, this.filterPublications(publications, filters).collect(Collectors.toList()));
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"all posts in category", (Object)categoryId), e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public Collection<PostDetail> getPostsByEventDate(String instanceId, String date, BlogFilters filters) {
        return this.getPostsByArchive(instanceId, date, date, filters);
    }

    @Override
    public Collection<PostDetail> getPostsByArchive(String instanceId, String beginDate, String endDate, BlogFilters filters) {
        List<PostDetail> list;
        block8: {
            Connection con = this.openConnection();
            try {
                Collection<String> postIds = PostDAO.getPostInRange(con, instanceId, beginDate, endDate);
                List publications = this.publicationService.getByIds(postIds);
                list = this.toPosts(instanceId, this.filterPublications(publications.stream(), filters).collect(Collectors.toList()));
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"all posts archived between", (Object)(beginDate + " and " + endDate)), e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public Collection<PostDetail> getResultSearch(String instanceId, String word, String userId, BlogFilters filters) {
        List<PostDetail> list;
        block8: {
            QueryDescription query = new QueryDescription(word);
            query.setSearchingUser(userId);
            query.addComponent(instanceId);
            Connection con = this.openConnection();
            try {
                Set searchResult = SearchEngineProvider.getSearchEngine().search(query).getEntries().stream().map(IndexEntry::getObjectId).collect(Collectors.toSet());
                Collection searchedPostIds = PostDAO.getAllPostIds(con, instanceId).stream().filter(searchResult::contains).collect(Collectors.toList());
                List<PublicationDetail> publications = this.filterPublications(this.publicationService.getByIds(searchedPostIds).stream(), filters).collect(Collectors.toList());
                list = this.toPosts(instanceId, publications);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    @Transactional
    public void createCategory(Category category) {
        try {
            this.nodeService.createNode((NodeDetail)category, new NodeDetail());
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void updateCategory(Category category) {
        try {
            this.nodeService.setDetail((NodeDetail)category);
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void deleteCategory(String instanceId, String id) {
        try {
            NodePK nodePk = new NodePK(id, instanceId);
            Collection<PostDetail> posts = this.getPostsByCategory(instanceId, id, new BlogFilters(true));
            for (PostDetail post : posts) {
                this.publicationService.removeFather(post.getPublication().getPK(), nodePk);
            }
            this.nodeService.removeNode(nodePk);
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
    }

    @Override
    public Category getCategory(NodePK pk) {
        return new Category(this.nodeService.getDetail(pk));
    }

    @Override
    public Collection<NodeDetail> getAllCategories(String instanceId) {
        NodePK nodePK = new NodePK("0", instanceId);
        ArrayList<NodeDetail> result = new ArrayList<NodeDetail>(this.nodeService.getChildrenDetails(nodePK));
        result.sort((Comparator<NodeDetail>)new NodeOrderComparator());
        return result;
    }

    @Override
    public Collection<Archive> getAllArchives(String instanceId) {
        Collection collection;
        block8: {
            Connection con = this.openConnection();
            try {
                Calendar calendar = Calendar.getInstance(Locale.FRENCH);
                collection = PostDAO.getAllEventDates(con, instanceId).stream().map(d -> {
                    calendar.setTime((Date)d);
                    return this.createArchive(calendar);
                }).distinct().collect(Collectors.toList());
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"All archives of blog", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return collection;
    }

    private Archive createArchive(Calendar calendar) {
        Date beginDate = this.getMonthFirstDay(calendar);
        Date endDate = this.getMonthLastDay(calendar);
        Archive archive = new Archive(USELESS, DateUtil.date2SQLDate((Date)beginDate), DateUtil.date2SQLDate((Date)endDate));
        archive.setYear(Integer.toString(calendar.get(1)));
        archive.setMonthId(Integer.toString(calendar.get(2)));
        return archive;
    }

    @Override
    public void indexBlog(String componentId) {
        this.indexTopics(new NodePK(USELESS, componentId));
        this.indexPublications(componentId);
    }

    private void indexPublications(String componentId) {
        Collection pubs;
        try {
            pubs = this.publicationService.getAllPublications(componentId);
        }
        catch (Exception e) {
            throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"[INDEXING] all publications in blog", (Object)componentId), e);
        }
        if (pubs != null) {
            for (PublicationDetail pub : pubs) {
                try {
                    this.indexPublication(pub.getPK());
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnIndexing((String)"publication", (Object)pub.getPK().toString()), e);
                }
            }
        }
    }

    private void indexPublication(PublicationPK pubPK) {
        this.publicationService.createIndex(pubPK);
        this.indexExternalElementsOfPublication(pubPK);
    }

    private void indexTopics(NodePK nodePK) {
        Collection nodes = this.nodeService.getAllNodes(nodePK);
        if (nodes != null) {
            for (NodeDetail node : nodes) {
                if (node.getNodePK().isRoot() || node.getNodePK().isTrash()) continue;
                this.nodeService.createIndex(node);
            }
        }
    }

    @Override
    public boolean isSubscribed(String userId, String instanceId) {
        return this.getSubscribeService().existsSubscription((Subscription)new ComponentSubscription(userId, instanceId));
    }

    private void indexExternalElementsOfPublication(PublicationPK pubPK) {
        try {
            this.getCommentService().indexAllCommentsOnPublication(PostDetail.getResourceType(), new ResourceReference((WAPrimaryKey)pubPK));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Comment index failure for publication {0}", (Object[])new String[]{pubPK.toString()}, (Throwable)e);
        }
    }

    private Date getMonthFirstDay(Calendar calendar) {
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private Date getMonthLastDay(Calendar calendar) {
        int monthLastDay = calendar.getActualMaximum(5);
        calendar.set(5, monthLastDay);
        return calendar.getTime();
    }

    private void createSilverContent(Connection con, PublicationDetail pubDetail, String creatorId) {
        try {
            this.blogContentManager.createSilverContent(con, (Contribution)pubDetail, creatorId);
        }
        catch (ContentManagerException e) {
            throw new BlogRuntimeException(e);
        }
    }

    private void updateSilverContentVisibility(PublicationDetail pubDetail) {
        try {
            this.blogContentManager.updateSilverContentVisibility((Contribution)pubDetail);
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
    }

    @Override
    public void draftOutPost(PostDetail post) {
        PublicationDetail pub = post.getPublication();
        pub.setStatus("Valid");
        this.publicationService.setDetail(pub);
        if (pub.getStatus().equals("Valid")) {
            this.updateSilverContentVisibility(pub);
            this.sendSubscriptionsNotification(new NodePK("0", pub.getPK().getSpaceId(), pub.getPK().getInstanceId()), post, null, "create", pub.getUpdaterId());
        }
    }

    private Stream<PublicationDetail> filterPublications(Stream<PublicationDetail> pubs, BlogFilters filters) {
        Stream<PublicationDetail> stream = pubs.filter(filters.toPredicate());
        Optional<Integer> maxResult = filters.getMaxResult();
        if (maxResult.isPresent()) {
            stream = stream.limit(maxResult.get().intValue());
        }
        return stream;
    }

    private int createSilverContent(PublicationDetail pubDetail, String creatorId) {
        Connection con = null;
        try {
            con = this.openConnection();
            int n = this.blogContentManager.createSilverContent(con, (Contribution)pubDetail, creatorId);
            return n;
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private int getSilverObjectId(PublicationPK pubPK) {
        int silverObjectId;
        try {
            silverObjectId = this.blogContentManager.getSilverContentId(pubPK.getId(), pubPK.getInstanceId());
            if (silverObjectId == -1) {
                PublicationDetail pubDetail = this.publicationService.getDetail(pubPK);
                silverObjectId = this.createSilverContent(pubDetail, pubDetail.getCreatorId());
            }
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
        return silverObjectId;
    }

    private SubscriptionService getSubscribeService() {
        return SubscriptionServiceProvider.getSubscribeService();
    }

    protected CommentService getCommentService() {
        return this.commentService;
    }
}

