/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.aggregate;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.Nullable;

public class AggregateIndexPlan
implements QueryIndex.IndexPlan {
    private Filter filter;
    private boolean pathWithoutPlan;
    private final HashMap<String, QueryIndex.IndexPlan> basePlans = new HashMap();

    AggregateIndexPlan(Filter filter) {
        this.filter = filter;
    }

    void setPlan(String path, List<QueryIndex.IndexPlan> plans) {
        if (plans.size() == 0) {
            this.basePlans.put(path, null);
            this.pathWithoutPlan = true;
        } else {
            this.basePlans.put(path, plans.get(0));
        }
    }

    boolean containsPathWithoutPlan() {
        return this.pathWithoutPlan;
    }

    QueryIndex.IndexPlan getPlan(String path) {
        return this.basePlans.get(path);
    }

    Collection<QueryIndex.IndexPlan> getPlans() {
        return this.basePlans.values();
    }

    public double getCostPerExecution() {
        double cost = 0.0;
        for (QueryIndex.IndexPlan p : this.basePlans.values()) {
            if (p == null) continue;
            cost += p.getCostPerExecution();
        }
        return cost;
    }

    public double getCostPerEntry() {
        double costPerEntry = 0.0;
        long totalEntries = this.getEstimatedEntryCount();
        if (totalEntries == 0L) {
            return 0.0;
        }
        for (QueryIndex.IndexPlan p : this.basePlans.values()) {
            if (p == null) continue;
            costPerEntry += p.getCostPerEntry() * (double)p.getEstimatedEntryCount() / (double)totalEntries;
        }
        return costPerEntry;
    }

    public long getEstimatedEntryCount() {
        long totalEntries = 0L;
        for (QueryIndex.IndexPlan p : this.basePlans.values()) {
            if (p == null) continue;
            totalEntries += p.getEstimatedEntryCount();
        }
        return totalEntries;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean isDelayed() {
        for (QueryIndex.IndexPlan p : this.basePlans.values()) {
            if (p == null || !p.isDelayed()) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecated() {
        for (QueryIndex.IndexPlan p : this.basePlans.values()) {
            if (p == null || !p.isDeprecated()) continue;
            return true;
        }
        return false;
    }

    public boolean isFulltextIndex() {
        for (QueryIndex.IndexPlan p : this.basePlans.values()) {
            if (p == null || !p.isFulltextIndex()) continue;
            return true;
        }
        return false;
    }

    public boolean includesNodeData() {
        for (QueryIndex.IndexPlan p : this.basePlans.values()) {
            if (p == null || p.includesNodeData()) continue;
            return false;
        }
        return true;
    }

    public List<QueryIndex.OrderEntry> getSortOrder() {
        return null;
    }

    @Nullable
    public Filter.PropertyRestriction getPropertyRestriction() {
        return null;
    }

    public QueryIndex.IndexPlan copy() {
        return null;
    }

    public NodeState getDefinition() {
        return null;
    }

    public String getPathPrefix() {
        return null;
    }

    public boolean getSupportsPathRestriction() {
        return false;
    }

    @Nullable
    public Object getAttribute(String name) {
        return null;
    }

    public String getPlanName() {
        StringBuilder name = new StringBuilder();
        boolean first = true;
        for (QueryIndex.IndexPlan p : this.basePlans.values()) {
            if (!first) {
                name.append(",");
            } else {
                first = false;
            }
            name.append(p.getPlanName());
        }
        return name.toString();
    }
}

