/*
 * Generated by the Jasper component of Apache Tomcat
 * Version: JspC/ApacheTomcat9
 * Generated at: 2025-11-27 16:03:54 UTC
 * Note: The last modified time of this file was set to
 *       the last modified time of the source file after
 *       generation to assist with modification tracking.
 */
package org.apache.jsp.survey.jsp;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.ArrayList;
import java.lang.Math;
import java.net.URLEncoder;
import java.text.ParseException;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.kernel.util.StringUtil;
import org.silverpeas.core.util.MultiSilverpeasBundle;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.components.survey.control.SurveySessionController;
import org.silverpeas.components.survey.SurveyException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.questioncontainer.question.model.Question;
import org.silverpeas.core.questioncontainer.result.model.QuestionResult;
import org.silverpeas.core.questioncontainer.answer.model.Answer;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPane;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayLine;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayColumn;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellText;
import org.silverpeas.core.web.util.viewgenerator.html.board.Board;
import org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBar;
import org.silverpeas.core.web.util.viewgenerator.html.buttonpanes.ButtonPane;
import org.silverpeas.core.web.util.viewgenerator.html.buttons.Button;
import org.silverpeas.core.web.util.viewgenerator.html.iconpanes.IconPane;
import org.silverpeas.core.web.util.viewgenerator.html.icons.Icon;
import org.silverpeas.core.web.util.viewgenerator.html.tabs.TabbedPane;
import org.silverpeas.core.web.util.viewgenerator.html.operationpanes.OperationPane;
import org.silverpeas.core.web.util.viewgenerator.html.window.Window;
import org.silverpeas.core.web.util.viewgenerator.html.frame.Frame;
import org.silverpeas.core.questioncontainer.container.model.Comment;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerHeader;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerDetail;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerHeader;
import org.silverpeas.core.util.MultiSilverpeasBundle;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import java.text.ParseException;
import java.util.stream.Collectors;
import org.silverpeas.core.questioncontainer.result.model.Results;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.a;
import java.util.Optional;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.p;
import static org.silverpeas.core.questioncontainer.container.model.QuestionContainerHeader.*;
import static java.lang.String.format;
import static org.silverpeas.components.survey.control.DisplayResultView.*;
import org.silverpeas.components.survey.control.DisplayResultView;
import java.util.Objects;
import static org.silverpeas.components.survey.control.DisplayResultView.Constants.*;
import org.apache.ecs.xhtml.span;
import org.silverpeas.components.survey.web.AnswerPercentEntity;
import org.silverpeas.core.util.JSONCodec;
import static org.silverpeas.core.web.util.viewgenerator.html.JavascriptPluginInclusion.scriptContent;
import org.silverpeas.core.security.html.HtmlSanitizer;
import org.silverpeas.components.survey.web.AnswerEntity;

public final class surveyUpdate_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent,
                 org.apache.jasper.runtime.JspSourceImports {



TabbedPane displayTabs(SurveySessionController surveyScc, String surveyId, GraphicElementFactory gef, String action, String profile,
MultiSilverpeasBundle resources, boolean pollingStationMode, boolean participated) {
	TabbedPane tabbedPane = gef.getTabbedPane();
	String label = "";
	if (pollingStationMode) {
		label = resources.getString("PollingStation");
	} else {
		label = resources.getString("Survey");
  }
	boolean tabValid = action.equals("ViewCurrentQuestions") || action.equals("ViewResult") || action.equals("ViewSurvey");
	if (!participated) {
	 tabValid = action.equals("ViewCurrentQuestions") || action.equals("ViewSurvey");
	}

	tabbedPane.addTab(label, "surveyDetail.jsp?Action=ViewCurrentQuestions&Participated="+participated+"&SurveyId="+surveyId, tabValid, true);

  if (isContributor(profile) && !participated) {
      tabbedPane.addTab(resources.getString("survey.results"), "surveyDetail.jsp?Action=ViewResult&Participated="+participated+"&SurveyId="+surveyId, action.equals("ViewResult"), true);
  }
  if (surveyScc.isDisplayCommentsEnabled(profile, null)) {
    tabbedPane.addTab(resources.getString("survey.Comments"),"surveyDetail.jsp?Action=ViewComments&Participated=" + participated + "&SurveyId=" + surveyId, action.equals("ViewComments"), true);
  }

	return tabbedPane;
}

//Display the survey header
String displaySurveyHeader(QuestionContainerHeader surveyHeader, SurveySessionController surveyScc, MultiSilverpeasBundle resources, GraphicElementFactory gef) throws ParseException {
        String title = WebEncodeHelper.javaStringToHtmlString(surveyHeader.getTitle());
        String description = WebEncodeHelper.javaStringToHtmlParagraphe(surveyHeader.getDescription());
        String creationDate = resources.getOutputDate(surveyHeader.getCreationDate());
        String beginDate = "&nbsp;";
        if (surveyHeader.getBeginDate() != null)
            beginDate = resources.getOutputDate(surveyHeader.getBeginDate());
        String endDate = "";
        if (surveyHeader.getEndDate() != null)
            endDate = resources.getOutputDate(surveyHeader.getEndDate());
        int nbVoters = surveyHeader.getNbVoters();
        Board board = gef.getBoard();
        String r = "";
        r += board.printBefore();
        r += "<table border=\"0\" width=\"100%\">";
        r += "<tr><td class=\"textePetitBold\" nowrap>"+resources.getString("GML.name")+" :</td><td width=\"100%\">"+title+"</td></tr>";
        if (StringUtil.isDefined(description))
          		r += "<tr><td class=\"textePetitBold\" nowrap valign=\"top\">"+resources.getString("SurveyCreationDescription")+" :</td><td>"+description+"</td></tr>";
        r += "<tr><td class=\"textePetitBold\" nowrap>"+resources.getString("SurveyCreationDate")+" :</td><td>"+creationDate+"</td></tr>";
        r += "<tr><td class=\"textePetitBold\" nowrap>"+resources.getString("SurveyCreationBeginDate")+" :</td><td>"+beginDate+"</td></tr>";
        if (StringUtil.isDefined(endDate))
        		r += "<tr><td class=\"textePetitBold\" nowrap>"+resources.getString("SurveyCreationEndDate")+" :</td><td>"+endDate+"</td></tr>";

        if (surveyScc.isParticipationMultipleUsed())
		{
	          r += "<tr><td class=\"textePetitBold\" nowrap>"+resources.getString("SurveyNbParticipations")+" :</td><td>"+nbVoters+"</td></tr>";
		}
		else
		{
      int nbRegistered = surveyHeader.getNbRegistered();
            r += "<tr><td class=\"textePetitBold\" nowrap>"+resources.getString("SurveyNbVoters")+" :</td><td>"+nbVoters+"</td></tr>";
	          r += "<tr><td class=\"textePetitBold\" nowrap>"+resources.getString("SurveyNbRegistered")+" :</td><td>"+nbRegistered+"</td></tr>";
	          r += "<tr><td class=\"textePetitBold\" nowrap>"+resources.getString("SurveyParticipationRate")+" :</td><td><B>"+Math.round(((float)nbVoters*100)/((float)nbRegistered))+" %</B></td></tr>";
		}
        r += "</table>";
        r += board.printAfter();
        return r;
}

String displaySurvey(QuestionContainerDetail survey, GraphicElementFactory gef, String m_context, SurveySessionController surveyScc,
MultiSilverpeasBundle resources, SettingBundle settings, String profile, boolean pollingStationMode, boolean participated) throws SurveyException, ParseException {

        String r = "";
        Question question = null;
        Collection answers = null;
        try{
            if (survey != null) {
                QuestionContainerHeader surveyHeader = survey.getHeader();
                Collection questions = survey.getQuestions();

				r += displayTabs(surveyScc, surveyHeader.getPK().getId(), gef, "ViewSurvey", profile, resources, pollingStationMode, participated).print();

                //Display the survey header
                r += displaySurveyHeader(surveyHeader, surveyScc, resources, gef);

                if (questions != null && !questions.isEmpty()) {
                    //Display the questions
                    r += "<form name=\"survey\">";
                    r += "<input type=\"hidden\" name=\"Action\">";
                    r += "<input type=\"hidden\" name=\"NbQuestions\" value=\""+questions.size()+"\">";
                    r += "<input type=\"hidden\" name=\"SurveyId\" value=\""+surveyHeader.getPK().getId()+"\">";
                    Iterator itQ = questions.iterator();
                    int nbTotalQuestion = questions.size();
                    int i = 1;
                    while (itQ.hasNext()) {
                          question = (Question) itQ.next();
                          r += displayQuestion(question, i, i, nbTotalQuestion, m_context, settings, surveyScc, gef, resources);
                          i++;
                    }
                    r += "<table>";
                    Button cancelButton = gef.getFormButton(resources.getString("GML.back"), "surveyList.jsp?Action=View", false);
                    Button voteButton = gef.getFormButton(resources.getString("GML.validate"), "javascript:onClick=sendVote()", false);
                    r += "<tr><td align=\"center\"><table><tr><td>"+voteButton.print()+"</td><td>"+cancelButton.print()+"</td></tr></table></td></tr>";
                    r += "</table>";
                    r += "</form>";
                } else {
                    r += "<br>"+resources.getString("SurveyWithNoQuestions")+"<br><br>";
                }
            } else {
                r += "<table><tr><td>"+resources.getString("SurveyUnavailable")+"</td></tr>";
            }
        }
        catch (Exception e){
            throw new  SurveyException(e);
        }

        return r;
}

String displayQuestions(QuestionContainerDetail survey, int roundId, GraphicElementFactory gef, String m_context, SurveySessionController surveyScc,
MultiSilverpeasBundle resources, SettingBundle settings, String profile, boolean pollingStationMode, boolean participated) throws SurveyException, ParseException {
        Board board = gef.getBoard();
        String r = "";
        try{
            Question question = null;
            Frame frame = gef.getFrame();

            if (survey != null) {
                QuestionContainerHeader surveyHeader = survey.getHeader();
                int nbQuestionsPerPage = surveyHeader.getNbQuestionsPerPage();
                int end = nbQuestionsPerPage * roundId;
                int begin = end - nbQuestionsPerPage;
                Collection questions = survey.getQuestions();
                int nbQuestions = 0;
                int nbTotalQuestion = questions.size();

                if (end < questions.size()) {
                    nbQuestions = nbQuestionsPerPage;
                } else if (end == questions.size()) {
                    nbQuestions = (questions.size() / roundId);
                } else { //derniere page
                     nbQuestions = nbQuestionsPerPage - (end - questions.size());
                }

                if (nbQuestionsPerPage >= questions.size()) {
                    nbQuestions = questions.size();
                }
				r += displayTabs(surveyScc, surveyHeader.getPK().getId(), gef, "ViewSurvey", profile, resources, pollingStationMode, participated).print();
                r += frame.printBefore();
                r += displaySurveyHeader(surveyHeader, surveyScc, resources, gef);

               if (questions != null && questions.size()>0) {
                    //Display the questions
                    r += "<form name=\"survey\" Action=\"surveyDetail.jsp\" Method=\"POST\">";
                    r += "<input type=\"hidden\" name=\"Action\">";
                    r += "<input type=\"hidden\" name=\"RoundId\">";
                    r += "<input type=\"hidden\" name=\"NbQuestions\" value=\""+nbQuestions+"\">";
                    r += "<input type=\"hidden\" name=\"SurveyId\" value=\""+surveyHeader.getPK().getId()+"\">";
                    Iterator itQ = questions.iterator();
                    int i = 1;
                    int j = 1;
                    while (itQ.hasNext()) {
                          question = (Question) itQ.next();
                          if ((i > begin) && (i <= end))
                          {
                              r += displayQuestion(question, j + (nbQuestionsPerPage * (roundId-1)), j, nbTotalQuestion, m_context, settings, surveyScc, gef, resources);
                              j++;
                          }
                          i++;
                    }

               		if (end >= questions.size())
               		{
						//Mode anonyme ou enquete anonyme -> force les commentaires aï¿½etre tous anonymes
						String anonymousCommentCheck = "";
						String anonymousCommentDisabled = "";
						if(surveyScc.isAnonymousModeEnabled() || surveyHeader.isAnonymous()) {
							anonymousCommentCheck = "checked";
							anonymousCommentDisabled = "disabled";
						}

            // affichage de la zone pour les commentaires
            if (surveyScc.isDisplayCommentsEnabled(profile, surveyScc.getUserDetail().getId())) {
              r += "<br>";
              r += board.printBefore();
              r += "<table><tr><td align=\"left\" valign=top class=\"txtlibform\">" +
                  resources.getString("survey.Comments") + " :</td>";
              r += "<td align=\"left\"><textarea name=\"Comment\" rows=\"4\" cols=\"60\"></textarea></td></tr>";
              r += "<tr><td align=\"left\" class=\"txtlibform\">" + resources.getString("survey.AnonymousComment") +
                  " :</td>";
              r +=
                  "<td align=\"left\"><input type=\"checkbox\" name=\"anonymousComment\" " + anonymousCommentCheck + " " +
                      anonymousCommentDisabled + "></td></tr>";
              r += "</table>";
              r += board.printAfter();
              r += "<br>";
            }
          }

        			r += "</form>";

                    Button cancelButton = null;
                    Button voteButton = null;
                    r += frame.printMiddle();
                    if ((begin <= 0) && (end < questions.size()))
                    {
                          voteButton = gef.getFormButton(resources.getString("GML.validate"), "javascript:onClick=sendVote('"+(roundId+1)+"')", false);
                          r += "<center>"+voteButton.print()+"</center>";
                    }
                    else if (end >= questions.size())
                    {
                          voteButton = gef.getFormButton(resources.getString("GML.validate"), "javascript:onClick=sendVote('end')", false);
                          r += "<center>"+voteButton.print()+"</center>";
                    }
                    else
                    {
                          voteButton = gef.getFormButton(resources.getString("GML.validate"), "javascript:onClick=sendVote('"+(roundId+1)+"')", false);
                          r += "<center>"+voteButton.print()+"</center>";
                    }
                } else {
                    r += "<br/>"+resources.getString("SurveyWithNoQuestions")+"<br/><br/>";
                    r += frame.printMiddle();
                }

            } else {
                r += "<center>"+resources.getString("SurveyUnavailable")+"</center>";
            }
            r += frame.printAfter();
        }
        catch( Exception e){
            throw new  SurveyException(e);
        }

        return r;
}

/**
	Display question
**/
String displayQuestion(Question question, int i, int nbQuestionInPage, int nbTotalQuestion, String m_context, SettingBundle settings, SurveySessionController surveyScc, GraphicElementFactory gef, MultiSilverpeasBundle resources)
{
        Collection answers = question.getAnswers();
        String r = "";
        Board board = gef.getBoard();
        r += "<br>";
        r += board.printBefore();
        r += "<table border=\"0\" cellpadding=\"2\" width=\"100%\">";
        if (!surveyScc.isPollingStationMode())
	        r += "<tr><td align=\"center\" colspan=\"2\"><b>"+resources.getString("SurveyCreationQuestion")+" n&deg;"+i+ " / " + nbTotalQuestion +"</b><BR></td></tr>";

        r += "<tr><td colspan=\"2\"><img src=\""+m_context+"/util/icons/mandatoryField.gif\" width=\"5\">&nbsp;&nbsp;<B><U>"+WebEncodeHelper.javaStringToHtmlString(question.getLabel())+"</U></B><BR/></td></tr>";

		// traitement du type de question
        String style = question.getStyle();

        //if (question.isOpen())
        if (style.equals("open"))
        {
              Iterator itA = answers.iterator();
              while (itA.hasNext())
              {
                  Answer answer = (Answer) itA.next();
                  String inputValue = answer.getPK().getId()+","+question.getPK().getId();
                  r += "<input type=\"hidden\" name=\"answer_"+nbQuestionInPage+"\" value=\""+inputValue+"\">";
                  r += "<tr><td colspan=\"2\"><textarea name=\"openedAnswer_"+nbQuestionInPage+"\" cols=\"60\" rows=\"4\"></textarea></td></tr>";
              }
        }
        else
        {
        	if (style.equals("list"))
            {
             	// liste dÃ©roulante
             	String selectedStr = "";

		String openAnswerId="";
		Iterator itA = answers.iterator();
		while (itA.hasNext())
	        {
			Answer answer = (Answer) itA.next();
			if (answer.isOpened()) {
				openAnswerId = answer.getPK().getId()+","+question.getPK().getId();
			}
		}

                r += "<tr><td><select id=\"answer_"+nbQuestionInPage+"\" name=\"answer_"+nbQuestionInPage+"\" onchange=\"if(this.value=='"+openAnswerId+"'){document.getElementById('openanswer"+nbQuestionInPage+"').style.display='block'}else{document.getElementById('openanswer"+nbQuestionInPage+"').style.display='none'};\">";

                itA = answers.iterator();
	            while (itA.hasNext())
	            {
	            	Answer answer = (Answer) itA.next();
			String inputValue = answer.getPK().getId()+","+question.getPK().getId();
			r += "<option value=\""+inputValue+"\" "+selectedStr+">"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"</option>";
	            }
		    r += "<input type=\"text\" name=\"openedAnswer_"+nbQuestionInPage+"\" id=\"openanswer"+nbQuestionInPage+"\" value=\"\" style=\"display: none\"/>";
	            r += "</td></tr>";
            }
            else
            {
	           String inputType = "radio";
	           String selectedStr = "";
	           //if (question.isQCM())
	           if (style.equals("checkbox"))
	           {
                    inputType = "checkbox";
                    selectedStr = "";
               }
               Iterator itA = answers.iterator();
               int isOpened = 0;
               int answerNb = 0;
               while (itA.hasNext())
               {
                  Answer answer = (Answer) itA.next();
                  String inputValue = answer.getPK().getId()+","+question.getPK().getId();
                  if (answer.isOpened())
                  {
                      	isOpened = 1;
                      	String label = resources.getString("SurveyCreationDefaultSuggestionLabel");
                      	r += "<tr><td width=\"40px\" align=\"center\"><input type=\""+inputType+"\" name=\"answer_"+nbQuestionInPage+"\" value=\""+inputValue+"\"></td><td align=\"left\" width=\"100%\">"+
                            WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"<BR><input type=\"text\" size=\"40\" maxlength=\""+DBUtil.getTextFieldLength()+"\" name=\"openedAnswer_"+nbQuestionInPage+"\" value=\""+label+"\" onFocus=\"checkButton(document.survey.answer_"+nbQuestionInPage+"["+answerNb+"])\"></td></tr>";
                  }
                  else
                  {
                    final String image = answer.getImage();
                    if (image == null) {
                      r += "<tr><td width=\"40px\" align=\"center\"><input type=\""+inputType+"\" name=\"answer_"+nbQuestionInPage+"\" value=\""+inputValue+"\" "+selectedStr+"></td><td align=\"left\" width=\"100%\">"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"</td></tr>";
                    } else {
                      String url = getAnswerImageUrl(answer.getPK().getComponentName(), image);
                      r += "<tr><td width=\"40px\" align=\"center\"><input type=\""+inputType+"\" name=\"answer_"+nbQuestionInPage+"\" value=\""+inputValue+"\" "+selectedStr+"></td><td align=\"left\" width=\"100%\">"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"<BR>";
                      r += "<img src=\""+url+"\" border=\"0\"></td><td>";
                    }
                  }
                  answerNb++;
              }	// {while}
        	}
        }
        r += "</table>";
        r += board.printAfter();
        return r;
}

// Previsualisation
  String displaySurveyPreview(QuestionContainerDetail survey, GraphicElementFactory gef, String m_context, SurveySessionController surveyScc, MultiSilverpeasBundle resources, SettingBundle settings) throws SurveyException, ParseException
  {
        String r = "";
        try
        {
            Question question = null;
            Collection answers = null;
            Frame frame = gef.getFrame();
			Board board = gef.getBoard();
            if (survey != null)
            {
                QuestionContainerHeader surveyHeader = survey.getHeader();
                Collection questions = survey.getQuestions();

                r += frame.printBefore();

                //Display the survey header
                String title = surveyHeader.getTitle();
                String description = surveyHeader.getDescription();
                String creationDate = resources.getOutputDate(new Date());
                String beginDate = "&nbsp";
                if (surveyHeader.getBeginDate() != null)
                    beginDate = resources.getOutputDate(surveyHeader.getBeginDate());
                String endDate = "";
                if (surveyHeader.getEndDate() != null)
                    endDate = resources.getOutputDate(surveyHeader.getEndDate());
                r += board.printBefore();
                  r += "<table border=\"0\" cellpadding=\"2\" width=\"100%\">";
                  r += "<tr><td class=\"textePetitBold\">"+resources.getString("GML.name")+" :</td><td>"+WebEncodeHelper.javaStringToHtmlString(title)+"</td></tr>";
                  if (StringUtil.isDefined(description))
                  		r += "<tr><td class=\"textePetitBold\" valign=\"top\">"+resources.getString("SurveyCreationDescription")+" :</td><td>"+WebEncodeHelper.javaStringToHtmlParagraphe(description)+"</td></tr>";
                  r += "<tr><td class=\"textePetitBold\">"+resources.getString("SurveyCreationDate")+" :</td><td>"+creationDate+"</td></tr>";
                  r += "<tr><td class=\"textePetitBold\">"+resources.getString("SurveyCreationBeginDate")+" :</td><td>"+beginDate+"</td></tr>";
                  if (StringUtil.isDefined(endDate))
                  		r += "<tr><td class=\"textePetitBold\">"+resources.getString("SurveyCreationEndDate")+" :</td><td>"+endDate+"</td></tr>";
                r += "</table>";
                r += board.printAfter();
                r += "<BR>";

                if (questions != null && questions.size()>0)
                {
                    //Display the questions
                    r += "<form name=\"survey\" Action=\"surveyDetail.jsp\" Method=\"Post\">";
                    r += "<input type=\"hidden\" name=\"Action\" value=\"SubmitSurvey\">";
                    Iterator itQ = questions.iterator();
                    int i = 1;
                    while (itQ.hasNext())
                    {
                          question = (Question) itQ.next();
                          answers = question.getAnswers();
                          //r+="<table cellpadding=0 cellspacing=2 border=0 width=\"98%\" CLASS=intfdcolor><tr><td class=intfdcolor4 nowrap>";
                          r += board.printBefore();
                          r += "<table border=\"0\" width=\"100%\">";
                          r += "<tr><td colspan=\"2\"><B><U>"+WebEncodeHelper.javaStringToHtmlString(question.getLabel())+"</U></B><BR/></td></tr>";

                          // traitement du type de question
                          String style = question.getStyle();

                          //if (question.isOpen())
                          if (style.equals("open"))
                          {
                          		// question ouverte
                                Iterator itA = answers.iterator();
                                int isOpened = 0;
                                r += "<tr><td colspan=\"2\"><textarea name=\"openedAnswer_"+i+"\" cols=\"60\" rows=\"4\"></textarea></td></tr>";
                          }
                          else
                          {
                          		if (style.equals("list"))
                          		{
                          			// drop down list
                          			r += "<tr><td><select id=\"answers\" name=\"answers\" onchange=\"if(this.value=='openanswer_"+i+"'){document.getElementById('openanswer"+i+"').style.display='block'}else{document.getElementById('openanswer"+i+"').style.display='none'};\">";

                          			Iterator itA = answers.iterator();
	                                int isOpened = 0;
	                                while (itA.hasNext())
	                                {
	                                    Answer answer = (Answer) itA.next();
					    if (answer.isOpened()) {
						r += "<option name=\"openanswer_"+i+"\" value=\"openanswer_"+i+"\">"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"</option>";
					    } else {
                   				r += "<option name=\"answer_"+i+"\" value=\"\">"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"</option>";
					    }
   	                                }
					r += "<input type=\"text\" id=\"openanswer"+i+"\" name=\"answer_"+i+"\" value=\"\" style=\"display:none\"/>";
	                                r += "</td></tr>";
                          		}
                          		else
                          		{
	                                String inputType = "radio";
	                                //if (question.isQCM())
	                                if (style.equals("checkbox"))
	                                      inputType = "checkbox";
	                                Iterator itA = answers.iterator();
	                                int isOpened = 0;
	                                while (itA.hasNext())
	                                {
	                                    Answer answer = (Answer) itA.next();
	                                    if (answer.isOpened())
	                                    {
	                                        isOpened = 1;
	                                        r += "<tr><td width=\"40px\" align=\"center\"><input type=\""+inputType+"\" name=\"answer_"+i+"\" value=\"\"></td><td align=\"left\" width=\"100%\">"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"<BR><input type=\"text\" size=\"20\" name=\"openedAnswer_"+i+"\"></td></tr>";
	                                    }
	                                    else
	                                    {
                                        final String image = answer.getImage();
                                        if (image == null) {
                                          r += "<tr><td width=\"40px\" align=\"center\"><input type=\""+inputType+"\" name=\"answer_"+i+"\" value=\"\"></td><td align=\"left\" width=\"100%\">"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"</td></tr>";
                                        } else {
                                          String url = getAnswerImageUrl(surveyScc.getComponentId(), image);
                                            r += "<tr><td width=\"40px\" align=\"center\"><input type=\""+inputType+"\" name=\"answer_"+i+"\" value=\"\"></td><td align=\"left\" width=\"100%\">"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"<BR>";
                                            r += "<img src=\""+url+"\" border=\"0\"></td><td>";
                                        }
	                                    }
	                                } // {while}
                                }
                          }
                          i++;
                          r += "</table>";
                          r += board.printAfter();
                          if (itQ.hasNext())
                              r += "<BR>";
                    } // {while}
                    r += "</form>";
                }
                else
                {
                     r += "<br/>"+resources.getString("SurveyWithNoQuestions")+"<br/><br/>";
                }
                r += frame.printMiddle();
                Button cancelButton = gef.getFormButton(resources.getString("GML.cancel"), "surveyList.jsp?Action=View", false);
                Button updateButton = gef.getFormButton(resources.getString("GML.modify"), "surveyDetail.jsp?Action=SubmitAndUpdateSurvey", false);
                Button voteButton = gef.getFormButton(resources.getString("GML.validate"), "javascript:onClick=document.survey.submit();", false);
                ButtonPane buttonPane = gef.getButtonPane();
                buttonPane.addButton(voteButton);
                buttonPane.addButton(updateButton);
                buttonPane.addButton(cancelButton);
                r += "<center>"+buttonPane.print()+"</center>";
                r += frame.printAfter();
            }
            else
            {
                r += "<table><tr><td>"+resources.getString("SurveyUnavailable")+"</td></tr>";
            }
        }
        catch( Exception e){
            throw new  SurveyException(e);
        }

       return r;
  }

String displaySurveyResultOfUser(String userId, Collection resultsByUser,
  QuestionContainerDetail survey, GraphicElementFactory gef, String m_context, SurveySessionController surveyScc,
  MultiSilverpeasBundle resources, SettingBundle settings, String profile)
    throws SurveyException {

  Board board = gef.getBoard();
  String r = "";

  // rechercher le(s) commentaire(s) de l'utilisateur
  List<Comment> userComments = new ArrayList<>();
  if (surveyScc.isDisplayCommentsEnabled(profile, userId)) {
    Collection<Comment> comments = survey.getComments();
    for (Comment comment : comments) {
      if (userId.equals(comment.getUserId())) {
        userComments.add(comment);
      }
    }
  }

  try {
    if (survey != null) {
	    Collection<Question> questions = survey.getQuestions();

       	r += board.printBefore();
       	r += "<table border=\"0\" cellspacing=\"5\" cellpadding=\"5\" width=\"100%\">";
          r += " <tr><td class=\"surveyDesc\" nowrap>" +
              resources.getString("survey.participationOf") + " : </td><td width=\"90%\">" +
              WebEncodeHelper.javaStringToHtmlString(User.getById(userId).getDisplayedName()) +
              "</td></tr>";
        int nbParticipations = 0;
        for (Comment userComment : userComments) {
          if (!userComment.getComment().equals("") && userComment != null) {
            nbParticipations++;
            r += " <tr><td class=\"textePetitBold\" nowrap valign=\"top\">" +
                resources.getString("survey.Comments") + "<span class=\"\">&nbsp; participation "+ nbParticipations + "</span> :</td><td width=\"90%\">" +
                WebEncodeHelper.javaStringToHtmlParagraphe(userComment.getComment()) + "&nbsp;("+DateUtil.getOutputDate(userComment.getDate(), surveyScc.getLanguage())+")</td></tr>";
          }
        }
        r += "</table>";
        r += board.printAfter();
        r += "<br/>";

      if (SilverpeasRole.ADMIN.toString().equals(profile) ||
          SilverpeasRole.PUBLISHER.toString().equals(profile)) {

        r += "<div class=\"surveyResult\">";

	      if (questions != null && !questions.isEmpty()) {
	        r += board.printBefore();
	        r += "<table border=\"0\" cellspacing=\"1\" width=\"100%\" class=\"questionResults\" >";
	        r += "<thead>";
	        int i=1;
	        for (Question question : questions) {
	          Collection answers = question.getAnswers();
	          if (!surveyScc.isPollingStationMode()) {
	            r += "<tr><th align=\"center\" colspan=\"2\"><b>"+resources.getString("SurveyCreationQuestion")+" n&deg;"+i+"</b></th></tr>";
	          }
	          r += "<tr><th colspan=\"2\" align=\"left\"><img src=\""+m_context+"/util/icons/mandatoryField.gif\" width=\"5\"/>&nbsp;&nbsp;<b><u>"+WebEncodeHelper.javaStringToHtmlString(question.getLabel())+"</u></b></th></tr>";
	          r += " </thead>";
	          r += "<tbody>";

	          String style = question.getStyle();
              // Display result for each user
              if (style.equals("open")) {
                r += displayOpenAnswersToQuestionByUser(userId, false, question.getPK().getId(), surveyScc);
              } else {
             	r += displaySurveyResultChartByUser(resultsByUser, userId, false, question.getPK().getId(), answers, m_context, settings, surveyScc);
              }
	          r += "</td></tr>";
	          r += "<tr class=\"questionResults-top\"><td class=\"questionResults-vide\" colspan=\"2\">&nbsp;</td></tr>";
	          i++;
	        } //end while
	        r += " </tbody></table>";
	        r += board.printAfter();
	      } else {//questions.size == 0
	        r += "<br/>"+resources.getString("SurveyWithNoQuestions")+"<br/><br/>";
	      }
      }
      r += "</div>";
    } else {//survey == null
      r += "<center>"+resources.getString("SurveyUnavailable")+"</center>";
    }
  } catch( Exception e){
    throw new  SurveyException(e);
  }
  return r;
}

  String displaySurveyResult(QuestionContainerDetail survey, GraphicElementFactory gef,
      String m_context, SurveySessionController surveyScc, MultiSilverpeasBundle resources,
      boolean isClosed, boolean participated, String profile,
      HttpServletRequest request) throws SurveyException {
  Board board = gef.getBoard();
  String r = "";
  DisplayResultView displayResultView = Optional.ofNullable(request.getParameter("DisplayResultView"))
      .filter(StringUtil::isDefined)
      .map(c -> surveyScc.setSurveyResultViewFromIdentifierOrMainView(survey, c))
      .orElseGet(surveyScc::getDisplayResultView);
  try {
    if (survey != null) {
	    QuestionContainerHeader surveyHeader = survey.getHeader();
	    Collection<Question> questions = survey.getQuestions();
	    Collection<QuestionResult> votes = survey.getCurrentUserVotes();

	    //Display the survey header
     	String surveyId = surveyHeader.getPK().getId();
     	String title = surveyHeader.getTitle();
     	String description = surveyHeader.getDescription();
     	String creationDate = resources.getOutputDate(surveyHeader.getCreationDate());
     	String beginDate = "&nbsp;";
    	if (surveyHeader.getBeginDate() != null) {
    	  beginDate = resources.getOutputDate(surveyHeader.getBeginDate());
    	}
     	String endDate = "&nbsp;";
     	if (surveyHeader.getEndDate() != null) {
        endDate = resources.getOutputDate(surveyHeader.getEndDate());
     	} else {
     	  endDate = "";
     	}
     	int nbVoters = surveyHeader.getNbVoters();
      int nbRegistered = 0;
      int participationRate = 0;
      if (!surveyScc.isParticipationMultipleUsed()) {
        nbRegistered = surveyHeader.getNbRegistered();
        participationRate = Math.round(((float)nbVoters*100)/((float)nbRegistered));
      }

     	boolean anonymous = surveyHeader.isAnonymous();

	//Mode anonyme -> force les enquetes aï¿½etre toutes anonymes
     	if(surveyScc.isAnonymousModeEnabled()) {
     	  anonymous = true;
     	}

     	int resultMode = surveyHeader.getResultMode();
     	int resultView = surveyHeader.getResultView();

      final div inlineMessage = new div();
      inlineMessage.setClass("inlineMessage");
      inlineMessage.addElement(new div().addElement(surveyScc.getString("survey.results.print.help")));
      if (isContributor(profile)) {
        inlineMessage.addElement(new div().addElement(surveyScc.getString("survey.results.export.help")));
      }
      r += inlineMessage.toString();

        if (resultMode == QuestionContainerHeader.DELAYED_RESULTS) {

	        r += "<div class=\"rightContent\">";

	        List<SimpleDocument> listDocument = surveyScc.getAllSynthesisFile(surveyId);
	        if(listDocument != null && !listDocument.isEmpty()) {
	          r += "<div class=\"attachments bgDegradeGris\">";
	          r += "  <div class=\"bgDegradeGris header\">";
	          r += "    <h4 class=\"clean\">"+resources.getString("survey.synthesisFile")+"</h4>";
	          r += "  </div>";
	          r += "  <ul id=\"attachmentList\">";

	          for(SimpleDocument simpleDocument : listDocument) {
	            String url = m_context +  simpleDocument.getAttachmentURL();
	            String permalink = m_context + "/File/"+simpleDocument.getId();
	            String dateDocument = resources.getOutputDate(simpleDocument.getCreationDate());
	            if(simpleDocument.getLastUpdateDate() != null) {
	              dateDocument = resources.getOutputDate(simpleDocument.getLastUpdateDate());
	            }

	            r += "    <li class=\"attachmentListItem\">";
			        r += "       <span class=\"lineMain\">";
			        r += "        <img class=\"icon\" src=\""+simpleDocument.getDisplayIcon()+"\">";
			        r += "        <a target=\"_blank\" href=\""+url+"\">"+simpleDocument.getFilename()+"</a>";
			        r += "       </span>";
			        r += "       <span class=\"lineSize\">";
			        r += "        <a class=\"sp-permalink\" href=\""+permalink+"\"><img border=\"0\" title=\""+resources.getString("survey.attachmentPermalink")+"\" alt=\""+resources.getString("survey.attachmentPermalink")+"\" src=\""+m_context+"/util/icons/link.gif\"></a>";
			        r +=            FileRepositoryManager.formatFileSize(simpleDocument.getSize())+" - "+dateDocument;
			        r += "       </span>";
			        r += "    </li>";
	          }

	          r += "  </ul>";
	          r += "</div>";
	        }
	        r += "<div class=\"bgDegradeGris\" id=\"surveyInfoPublication\">";
	        r += "  <p id=\"permalinkInfo\">";
	        r += "    <a title=\""+resources.getString("survey.CopySurveyLink")+"\" href=\""+m_context+"/Survey/"+surveyId+"\">";
	        r += "      <img border=\"0\" alt=\""+resources.getString("survey.CopySurveyLink")+"\" src=\""+m_context+"/util/icons/link.gif\">";
	        r += "    </a>"+resources.getString("GML.permalink")+"<br/>";
	        r += "    <input type=\"text\" value=\""+ URLUtil.getServerURL(request)+surveyHeader.getPermalink()+"\" onFocus=\"select();\" class=\"inputPermalink\">";
	        r += "  </p>";
	        r += "</div>";
	        r += "</div>";
        }

        r += "<div class=\"principalContent\">";
        r += " <h2 class=\"eventName\">"+WebEncodeHelper.javaStringToHtmlString(title)+"</h2>";
        r += " <div class=\"eventInfo\">";
        r += "   <div class=\"surveyDate\">";
        r += "     <div class=\"bloc\">";
        r += "       <span class=\"eventBeginDate\">"+resources.getString("SurveyCreationDate")+" : ";
        r += "       "+creationDate;
        r += "       </span>";
        r += "       <span class=\"eventBeginDate\">"+resources.getString("SurveyCreationBeginDate");
        r += "       "+beginDate;
        r += "       </span>";
        if (StringUtil.isDefined(endDate)) {
          r += "      <span class=\"eventEndDate\">"+resources.getString("SurveyCreationEndDate");
          r += "      "+endDate;
          r += "      </span>";
        }
        r += "     </div>";
        r += "   </div>";
        r += "   <div class=\"surveyParticipation\">";
        r += "     <div class=\"bloc\">";
        r += "       <span>"+resources.getString("survey.participation")+" : "+nbVoters;
        if (!surveyScc.isParticipationMultipleUsed()) {
          r += "/"+nbRegistered;
        }
        if (!anonymous &&
            ((SilverpeasRole.ADMIN.toString().equals(profile) ||
            SilverpeasRole.PUBLISHER.toString().equals(profile) ||
                !survey.getCurrentUserVotes().isEmpty()) &&
            (resultMode == QuestionContainerHeader.IMMEDIATE_RESULTS ||
            (resultMode == QuestionContainerHeader.DELAYED_RESULTS &&
            (resultView == QuestionContainerHeader.DETAILED_DISPLAY_RESULTS ||
            resultView == QuestionContainerHeader.TWICE_DISPLAY_RESULTS))))) {
          // affichage de l'icone des users
          r += "       <a href=\"javaScript:onClick=viewAllUsers('"+surveyId+"');\"><img src=\"icons/info.gif\" border=\"0\" align=\"absmiddle\" width=\"15\" height=\"15\"></a>";
        }
        r += "       </span>";
        if (!surveyScc.isParticipationMultipleUsed()) {
          r += "       <span>"+resources.getString("survey.thatToSay");
          if (isClosed) {
            r += "       "+(100-participationRate)+"&nbsp;%&nbsp;"+resources.getString("survey.abstentionRate");
          } else {
            r += "       "+participationRate+"&nbsp;%&nbsp;"+resources.getString("GML.preview.dialog.title.of")+" "+resources.getString("survey.participation");
          }
          r += "       </span>";
        }
        r += "     </div>";
        r += "   </div>";
        r += "   <div class=\"surveyUserParticipation\">";

        if (votes != null) {
          if (votes.size() > 0) {
            Iterator<QuestionResult> it = votes.iterator();
            if (it.hasNext()) {
              QuestionResult vote = (QuestionResult) it.next();
              r += "     <div class=\"bloc\">";
              r += "       <span>"+resources.getString("YouHaveAlreadyParticipate");
              r += "       "+resources.getOutputDate(vote.getVoteDate())+"</span>";

              if (surveyScc.isParticipationMultipleAllowedForUser()) {
                String labelButton = resources.getString("Survey.revote");
                if (surveyScc.isPollingStationMode()) {
                  labelButton = resources.getString("PollingStation.revote");
                }
                r += "       <span><a href=\"surveyDetail.jsp?Action=Vote&SurveyId="+
                         survey.getHeader().getId() + "\">" + labelButton + "</a></span>";
              }
              r += "     </div>";
            }
          }
        }

        r += "   </div>";
        r += "   <br clear=\"left\">&nbsp;";
        r += " </div>";
        if (StringUtil.isDefined(description)) {
        	r += " <div class=\"surveyDesc\">"+WebEncodeHelper.javaStringToHtmlParagraphe(description)+"</div>";
        }
        r += "</div>";

      if (isContributor(profile) ||
          resultMode == QuestionContainerHeader.IMMEDIATE_RESULTS ||
           (resultMode == QuestionContainerHeader.DELAYED_RESULTS &&
           resultView != QuestionContainerHeader.NOTHING_DISPLAY_RESULTS)) {

        r += "<div class=\"surveyResult\">";

        final div resultHeader = new div();
        resultHeader.setClass("sousNavBulle");
        if (!anonymous) {
          final p mainViewChoice = new p().addElement(
              format("%s %s ", resources.getString("survey.results"), resources.getString("survey.choice")));
          final String currentMainView = displayResultView.getMainView();
          displayResultView = List.of(CLASSIC_GRAPHICAL, DETAIL)
              .stream()
              .filter(v -> isContributor(profile) ||
                  resultView == TWICE_DISPLAY_RESULTS ||
                  (CLASSIC_MAIN_VIEW.equals(v.getMainView()) && resultView == CLASSIC_DISPLAY_RESULTS) ||
                  (DETAIL_MAIN_VIEW.equals(v.getMainView()) && resultView == DETAILED_DISPLAY_RESULTS))
              .map(v -> {
                final a mainViewLink = new a().setHref("javascript:void(0)");
                final String mainView = v.getMainView();
                mainViewLink.setID("scope-" + mainView);
                mainViewLink.setOnClick(
                    format("changeScope('%s', '%s', '%s')", mainView, participated, surveyId));
                final StringBuilder classes = new StringBuilder();
                classes.append("main-view");
                if (currentMainView.equals(mainView)) {
                  classes.append(" active");
                }
                mainViewLink.setClass(classes.toString());
                mainViewLink.addElement(resources.getString(v.getMainViewBundleKey()));
                mainViewChoice.addElement(mainViewLink);
                switch (resultView) {
                  case CLASSIC_DISPLAY_RESULTS:
                    return surveyScc.setSurveyResultViewFromIdentifierOrMainView(survey, CLASSIC_MAIN_VIEW);
                  case DETAILED_DISPLAY_RESULTS:
                    return surveyScc.setSurveyResultViewFromIdentifierOrMainView(survey, DETAIL_MAIN_VIEW);
                  default:
                    return null;
                }
              })
              .filter(Objects::nonNull)
              .findFirst()
              .orElse(displayResultView);
          resultHeader.addElement(mainViewChoice);
        } else {
          displayResultView = surveyScc.setSurveyResultViewFromIdentifierOrMainView(survey, CLASSIC_MAIN_VIEW);
        }
        if (CLASSIC_MAIN_VIEW.equals(displayResultView.getMainView())) {
          final p secondaryLevelViewChoice = new p();
          if (resultHeader.elements().hasMoreElements()) {
            resultHeader.addElement(new span().setClass("sub-view-separator"));
          }
          final String currentSecondaryLevelView = displayResultView.getSecondaryLevelView();
          DisplayResultView.fromMainViewOnly(displayResultView.getMainView()).forEach(v -> {
            final a secondaryLevelViewLink = new a().setHref("javascript:void(0)");
            final String secondaryLevelView = v.getSecondaryLevelView();
            secondaryLevelViewLink.setID("scope-" + secondaryLevelView);
            secondaryLevelViewLink.setOnClick(
                format("changeScope('%s', '%s', '%s')", v.getIdentifier(), participated, surveyId));
            final StringBuilder classes = new StringBuilder();
            classes.append("sub-view");
            if (currentSecondaryLevelView.equals(secondaryLevelView)) {
              classes.append(" active");
            }
            secondaryLevelViewLink.setClass(classes.toString());
            secondaryLevelViewLink.addElement(resources.getString(v.getSecondaryViewBundleKey()));
            secondaryLevelViewChoice.addElement(secondaryLevelViewLink);
          });
          resultHeader.addElement(secondaryLevelViewChoice);
        }
        if (resultHeader.elements().hasMoreElements()) {
          r += resultHeader;
        }

	      if (questions != null && !questions.isEmpty()) {
          Results results = surveyScc.getResults();
	        r += board.printBefore();
	        r += "<table border=\"0\" cellspacing=\"1\" width=\"100%\" class=\"questionResults\">";
	        int i=1;
	        for (Question question : questions) {
	          Collection<Answer> answers = question.getAnswers();
	          String questionDecorator = "";
	          if (!surveyScc.isPollingStationMode()) {
	            questionDecorator = resources.getString("SurveyCreationQuestion")+" n&deg;"+i+"&nbsp;-&nbsp;";
	          }
	          r += "<tr><th colspan=\"2\" align=\"left\"><img src=\""+m_context+"/util/icons/mandatoryField.gif\" width=\"5\">&nbsp;&nbsp;"+questionDecorator+WebEncodeHelper.javaStringToHtmlString(question.getLabel())+"</th></tr>";

	            String style = question.getStyle();
	            if (!anonymous && DETAIL_MAIN_VIEW.equals(displayResultView.getMainView())) {
	              // display not anonymous result
	           	  if (style.equals("open")) {
	           	   r += displayOpenAnswersToQuestionNotAnonymous(question.getPK().getId(), surveyScc, profile);
	              } else {
	                r += displaySurveyResultChartNotAnonymous(question, answers, surveyScc, nbVoters, results, profile);
	              }
	            } else {
	              // traitement de l'affichage des questions ouvertes
	              if (style.equals("open")) {
	                r += displayOpenAnswersToQuestion(question.getPK().getId(), surveyScc);
	              } else {
	                r += displaySurveyResultChart(question, displayResultView, anonymous, answers, nbVoters);
	              }
	            }
	          r += "</td></tr>";
	          r += "<tr><td class=\"questionSeparator\" colspan=\"2\">&nbsp;</td></tr>";
	          i++;
	        } //end while
	        r += "</table>";
	        r += board.printAfter();
	      } else {//questions.size == 0
	        r += "<br/>"+resources.getString("SurveyWithNoQuestions")+"<br/><br/>";
	      }
	      r += "</div>";
      } else {
        r += "<div class=\"inlineMessage\">"+resources.getString("survey.result.thankyou")+"</div>";
      }
    } else {//survey == null
      r += "<center>"+resources.getString("SurveyUnavailable")+"</center>";
    }
  } catch( Exception e){
    throw new  SurveyException(e);
  }
  return r;
}

  String displayOpenAnswersToQuestion(String questionId, SurveySessionController surveyScc) throws SurveyException {
        String r = "";
        try{
            //fetch the answers to this open question
            Collection openAnswers = surveyScc.getSuggestions(questionId);
            Iterator it = openAnswers.iterator();
            String answer = "";
            while (it.hasNext()) {
                QuestionResult qR = (QuestionResult) it.next();
                answer = WebEncodeHelper.javaStringToHtmlParagraphe(qR.getOpenedAnswer());
                if (StringUtil.isDefined(answer)) {
                  r += "<tr><td colspan=\"2\" align=\"left\">&#149; " + answer + "<br></td></tr>";
                }
            }
        }
        catch( Exception e){
            throw new  SurveyException(e);
        }
        return r;
  }

  String displayOpenAnswersToQuestionNotAnonymous(String questionId, SurveySessionController surveyScc, String profile) throws SurveyException {
        String r = "";
        try{
            //fetch the answers to this open question
            Collection openAnswers = surveyScc.getSuggestions(questionId);
            Iterator it = openAnswers.iterator();
            String answer = "";
            while (it.hasNext()) {
                QuestionResult qR = (QuestionResult) it.next();
                answer = WebEncodeHelper.javaStringToHtmlParagraphe(qR.getOpenedAnswer());
                if (StringUtil.isDefined(answer)) {
                  String userId = qR.getUserId();
                  UserDetail userDetail = surveyScc.getUserDetail(userId);
                  String userName = userDetail.getDisplayedName();
                  String displayedName = WebEncodeHelper.javaStringToHtmlString(userName);
                  if (surveyScc.isDisplayCommentsEnabled(profile, userId)) {
                    displayedName = "<a href=\"javaScript:onClick=viewResultByUser('" + userId + "');\">" + displayedName + "</a>";
                  }
                  r += "<tr><td class=\"displayUserName\" width=\"40%\">" + displayedName + "</td><td class=\"freeAnswer\">" + answer + "</td></tr>";
                }
            }
        }
        catch( Exception e){
            throw new  SurveyException(e);
        }
        return r;
  }

  String displayOpenAnswersToQuestionByUser(String userId, boolean anonymous, String questionId, SurveySessionController surveyScc) throws SurveyException {
        String r = "";
        try{
            //fetch the answers to this open question
            Collection openAnswers = surveyScc.getSuggestions(questionId);
            Iterator it = openAnswers.iterator();
            String answer = "";
            while (it.hasNext()) {
                QuestionResult qR = (QuestionResult) it.next();
                answer = WebEncodeHelper.javaStringToHtmlParagraphe(qR.getOpenedAnswer());
                if (!StringUtil.isDefined(answer))
                    answer = surveyScc.getString("NoResponse");
                String questionUserId = qR.getUserId();
                if (userId.equals(questionUserId))
                	r += "<tr><td colspan=\"2\" align=\"left\">&#149; "+answer+"<BR></td></tr>";
            }
        }
        catch( Exception e){
            throw new  SurveyException(e);
        }
        return r;
  }

  String displaySurveyResultChart(final Question question, DisplayResultView displayResultView,
      boolean anonymous, Collection<Answer> answers, int nbUsers) {
    final ElementContainer html = new ElementContainer();
    if (answers != null) {
      final HtmlSanitizer htmlSanitizer = HtmlSanitizer.get();
      final String questionId = question.getPK().getId();
      final String jsonEntities = JSONCodec.encode(
          AnswerPercentEntity.asWebEntities(answers, nbUsers, nbUsers > 0));
      String options = JSONCodec.encodeObject(o -> o
          .put("id", "question-answer-result-" + questionId)
          .put("title", htmlSanitizer.sanitize(question.getLabel()))
          .put("answerPercents", "jsonEntities")
          .put("view", displayResultView.getSecondaryLevelView())
          .put("anonymous", anonymous));
      options = options.replace("\"jsonEntities\"", jsonEntities);
      html.addElement(format("<tr id='question-answer-result-%s'></tr>", questionId));
      html.addElement(scriptContent(format("SurveyResultChart.mountQuestionAnswerResult(%s)", options)));
    }
    return html.toString();
  }

  String displaySurveyResultChartNotAnonymous(Question question, Collection<Answer> answers, SurveySessionController surveyScc, int nbVoters, Results results, String profile) throws SurveyException
  {
        String r = "";
        try
        {
            if (answers != null)
            {
                Iterator itA = answers.iterator();
                r += "<tr><td colspan=\"2\"><table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"1\">";
                r+= " <thead> <tr class=\"questionResults-top\"> <th class=\"questionResults-vide\"></th>";
                Map answerValues = new HashMap();
                int rang = 0;
                while (itA.hasNext())
                {
                	rang = rang + 1;
                    Answer answer = (Answer) itA.next();
			// affichage de la ligne des differentes rï¿½ponses possibles
                    if (answer.isOpened() &&
                        answer.getNbVoters() > 0) {
						r += "<th> "+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+" <A href=\"javaScript:onClick=viewSuggestions('"+answer.getQuestionPK().getId()+"');\"><img src=\"icons/info.gif\" border=\"0\" align=\"absmiddle\" width=\"15\" height=\"15\"></a> </th>";
                    } else {
						r += "<th> "+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+" </th>";
                    }
                    answerValues.put(answer.getPK().getId(), new Integer(rang));
                }
                r += "</tr> </thead>";
                r += "<tbody>";

                Collection<String> users = surveyScc.getUserByQuestion(new ResourceReference(question.getPK()));
                String saveUser = "";
                Iterator<String> itU = users.iterator();
                while (itU.hasNext())
                {
                 	String user = itU.next();
                 	String userId = user.split("/")[0];
                	String participationId = user.split("/")[1];
                	int position = 1;
                	if (!saveUser.equals(userId+"-"+participationId))
                	{
                    String displayedName = WebEncodeHelper.javaStringToHtmlString(results.getUser(userId).getDisplayedName());
                    if (surveyScc.isDisplayCommentsEnabled(profile, userId)) {
                      displayedName = "<a href=\"javaScript:onClick=viewResultByUser('" + userId + "');\">" + displayedName + "</a>";
                    }
                    r += "<tr><td align=\"left\" width=\"40%\" class=\"displayUserName\">" +displayedName + "</td>";

                    String value;
                    position = 1;
	                		List<QuestionResult> qrs = results.getQuestionResultByQuestion(question.getPK().getId(), userId, Integer.parseInt(participationId));
	                		for (QuestionResult qr : qrs) {
                        value = qr.getAnswerPK().getId();

                        int valueColonne = (Integer) answerValues.get(value);
                        // dÃ©caller pour se trouver dans la bonne colonne
                        while (position <= valueColonne) {
                          if (valueColonne == position) {
                            // on est sur la bonne colonne
                            r += "<td class=\"questionResults-Oui\"> X </td>";
                          } else {
                            // on dÃ©cale
                            r += "<td class=\"questionResults-Non\">&nbsp;</td>";
                          }
                          position = position + 1;
                        }
                        saveUser = userId + "-" + participationId;
                      }
	                	// completer la ligne avec des cases Ã  "vide"
		              	while (position <= rang)
		              	{
		              		r += "<td class=\"questionResults-Non\">&nbsp;</td>";
		              		position = position + 1;
		              	}
                	}

                }
                r += " </tbody>";
                r += "<tr><td></td>";
              r += AnswerPercentEntity.asWebEntities(answers, nbVoters, !users.isEmpty()).stream()
                      .map(AnswerPercentEntity::getPercent)
                      .map(p -> "<td align=\"center\">"+p+"%</td>")
                      .collect(Collectors.joining());
	            r += "</tr>";
	            r += "</table></td></tr>";
            }
        }
        catch( Exception e){
            throw new  SurveyException(e);
        }
        return r;
  }

  String displaySurveyResultChartByUser(Collection resultsByUser, String userId, boolean anonymous, String questionId, Collection answers, 
      String m_context, SettingBundle settings, SurveySessionController surveyScc) throws SurveyException
  { 
        String r = "";
        try
        {
            if (answers != null)
            {
                Iterator itA = answers.iterator();
                int nbVoters = 0;
                while (itA.hasNext())
                {
                    Answer answer = (Answer) itA.next();
                    nbVoters += answer.getNbVoters();
                }
                itA = answers.iterator();
                while (itA.hasNext())
                {
                    Answer answer = (Answer) itA.next();
                    if (answer.isOpened())
                    {
                        if (answer.getNbVoters() == 0) {
                            r += "<tr><td class=\"labelAnswer\" >"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"</td><td>";
                        } else {
                          String suggestion = "";
                          if (resultsByUser.contains(answer.getPK().getId())) {
                            QuestionResult questionResult = surveyScc.getSuggestion(userId, questionId, answer.getPK().getId());
                            if(questionResult != null) {
                           		suggestion = " : "+questionResult.getOpenedAnswer();
                            }
                          } 
                          r += "<tr><td class=\"labelAnswer\" >"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+suggestion+"</td><td>";
                        }
                    }
                    else
                    {
                      final String image = answer.getImage();
                      if (image == null) {
                        r += "<tr><td class=\"labelAnswer\" >"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"</td><td>";
                      } else {
                        String url = getAnswerImageUrl(answer.getPK().getComponentName(), image);
                          r += "<tr><td class=\"labelAnswer\" >"+WebEncodeHelper.javaStringToHtmlString(answer.getLabel())+"<BR>";
                          r += "<img src=\""+url+"\" border=\"0\" width=\"60%\"/></td><td>";
                      }
                    }
			// mettre en valeur cette rï¿½ponse si c'est le choix de l'utilisateur
                    if (resultsByUser.contains(answer.getPK().getId())) {
	                	r += "<img src=\""+m_context+"/util/icons/finishedTask.gif\" border=\"0\" valign=\"center\" width=\"15\" height=\"15\"/>";
                    }
                    r += "</td>";
                } // {while}
            }
        }
        catch( Exception e){
            throw new  SurveyException(e);
        }
        return r;
  }

  String displaySurveyComments(SurveySessionController surveyScc, QuestionContainerDetail survey, GraphicElementFactory gef,
  MultiSilverpeasBundle resources, String profile, boolean pollingStationMode, boolean participated) throws SurveyException {
		Board board = gef.getBoard();
		Frame frame = gef.getFrame();
        String r = "";
        boolean oneComment = false;
        boolean first = true;
        QuestionContainerHeader surveyHeader = survey.getHeader();
        r += displayTabs(surveyScc, surveyHeader.getPK().getId(), gef, "ViewComments", profile, resources, pollingStationMode, participated).print();
        r += frame.printBefore();
        try
        {
            if (survey != null)
            {
                Collection comments = survey.getComments();
                r += board.printBefore();
                r += "<TABLE border=0 cellspacing=0 cellpadding=5 width=\"98%\" align=center>";
                if (comments != null) {
                    if (comments.size() > 0) {
                        Iterator it = comments.iterator();
                        while (it.hasNext()) {
                          String userName = "";
                          UserDetail user = null;
                          Comment comment = (Comment) it.next();
                          if (comment.getComment() != null && comment.getComment().trim().length() > 0) {
                                  if (first)
                                        r += "<tr><td class=txtnav><B>"+resources.getString("survey.Comments")+"</B><BR></td></tr>";
                                  r += "<tr>";
                                  r += "<td valign=\"top\"><blockquote>";
                                  if (comment.isAnonymous() || surveyScc.isAnonymousModeEnabled() || surveyHeader.isAnonymous()) {
                                      userName = resources.getString("survey.AnonymousComment");
                                  } else {
                                      user = surveyScc.getUserDetail(comment.getUserId());
                                      if (user != null)
                                        userName = user.getFirstName() + " " + user.getLastName();
                                      else
                                        userName = resources.getString("UnknownUser");
                                  }
                                  r += "<p>&#149; <B>"+userName+"</B> - "+resources.getOutputDate(comment.getDate())+"<br>";
                                    r +="&nbsp;&nbsp;"+ WebEncodeHelper.javaStringToHtmlParagraphe(comment.getComment())+"</p>";
                                r += "</blockquote></td>";
                              r += "</tr>";
                              oneComment = true;
                              first = false;
                          }
                       }
                    }
                    if (!oneComment)
                        r += "<tr><td align=center class=\"txttitrecol\"><B>"+resources.getString("survey.NoComment")+"</B></td></tr>";
                } else {
                     r += "<tr><td align=center class=\"txttitrecol\"><B>"+resources.getString("survey.NoComment")+"</B></td></tr>";
                }
                r += "</table>";
                r += board.printAfter();
                r += frame.printAfter();
            }
        }
        catch( Exception e){
            throw new  SurveyException(e);
        }
       return r;
  }

  private static boolean isContributor(final String profile) {
    return SilverpeasRole.ADMIN.toString().equals(profile) ||
        SilverpeasRole.PUBLISHER.toString().equals(profile);
  }

  String getAnswerImageUrl(final String instanceId, final String image) {
    return AnswerEntity.normalizeImageUrl(instanceId, image).orElse(image);
  }


  private static final javax.servlet.jsp.JspFactory _jspxFactory =
          javax.servlet.jsp.JspFactory.getDefaultFactory();

  private static java.util.Map<java.lang.String,java.lang.Long> _jspx_dependants;

  static {
    _jspx_dependants = new java.util.HashMap<java.lang.String,java.lang.Long>(7);
    _jspx_dependants.put("jar:file:/home/silverbuild/.m2/repository/org/silverpeas/core/silverpeas-core-web/6.4.5-build251127/silverpeas-core-web-6.4.5-build251127.jar!/META-INF/viewGenerator.tld", Long.valueOf(1764256130000L));
    _jspx_dependants.put("/survey/jsp/surveyUtils.jsp", Long.valueOf(1725461247996L));
    _jspx_dependants.put("file:/home/silverbuild/.m2/repository/org/glassfish/web/javax.servlet.jsp.jstl/1.2.5/javax.servlet.jsp.jstl-1.2.5.jar", Long.valueOf(1764256128037L));
    _jspx_dependants.put("jar:file:/home/silverbuild/.m2/repository/org/glassfish/web/javax.servlet.jsp.jstl/1.2.5/javax.servlet.jsp.jstl-1.2.5.jar!/META-INF/c.tld", Long.valueOf(1531470420000L));
    _jspx_dependants.put("/survey/jsp/checkSurvey.jsp", Long.valueOf(1725461247992L));
    _jspx_dependants.put("jar:file:/home/silverbuild/.m2/repository/org/glassfish/web/javax.servlet.jsp.jstl/1.2.5/javax.servlet.jsp.jstl-1.2.5.jar!/META-INF/fmt.tld", Long.valueOf(1531470420000L));
    _jspx_dependants.put("file:/home/silverbuild/.m2/repository/org/silverpeas/core/silverpeas-core-web/6.4.5-build251127/silverpeas-core-web-6.4.5-build251127.jar", Long.valueOf(1764256153755L));
  }

  private static final java.util.Set<java.lang.String> _jspx_imports_packages;

  private static final java.util.Set<java.lang.String> _jspx_imports_classes;

  static {
    _jspx_imports_packages = new java.util.LinkedHashSet<>(8);
    _jspx_imports_packages.add("static org.silverpeas.components.survey.control.DisplayResultView");
    _jspx_imports_packages.add("javax.servlet");
    _jspx_imports_packages.add("static org.silverpeas.core.questioncontainer.container.model.QuestionContainerHeader");
    _jspx_imports_packages.add("javax.servlet.http");
    _jspx_imports_packages.add("javax.servlet.jsp");
    _jspx_imports_packages.add("static org.silverpeas.components.survey.control.DisplayResultView.Constants");
    _jspx_imports_classes = new java.util.LinkedHashSet<>(91);
    _jspx_imports_classes.add("org.silverpeas.core.admin.user.model.SilverpeasRole");
    _jspx_imports_classes.add("java.util.Date");
    _jspx_imports_classes.add("static org.silverpeas.core.web.util.viewgenerator.html.JavascriptPluginInclusion.scriptContent");
    _jspx_imports_classes.add("org.silverpeas.core.util.MultiSilverpeasBundle");
    _jspx_imports_classes.add("org.silverpeas.core.persistence.jdbc.DBUtil");
    _jspx_imports_classes.add("org.silverpeas.core.util.URLUtil");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.board.Board");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.window.Window");
    _jspx_imports_classes.add("org.silverpeas.core.admin.user.model.UserDetail");
    _jspx_imports_classes.add("org.silverpeas.kernel.bundle.LocalizationBundle");
    _jspx_imports_classes.add("org.silverpeas.components.survey.control.DisplayResultView");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.tabs.TabbedPane");
    _jspx_imports_classes.add("java.util.Map");
    _jspx_imports_classes.add("java.lang.Math");
    _jspx_imports_classes.add("org.silverpeas.components.survey.control.SurveySessionController");
    _jspx_imports_classes.add("org.apache.ecs.xhtml.div");
    _jspx_imports_classes.add("java.text.ParseException");
    _jspx_imports_classes.add("org.silverpeas.core.security.html.HtmlSanitizer");
    _jspx_imports_classes.add("org.silverpeas.core.ResourceReference");
    _jspx_imports_classes.add("org.silverpeas.kernel.util.StringUtil");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.operationpanes.OperationPane");
    _jspx_imports_classes.add("org.apache.ecs.xhtml.p");
    _jspx_imports_classes.add("java.util.Collection");
    _jspx_imports_classes.add("org.silverpeas.kernel.bundle.ResourceLocator");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory");
    _jspx_imports_classes.add("static java.lang.String.format");
    _jspx_imports_classes.add("org.silverpeas.core.questioncontainer.container.model.QuestionContainerHeader");
    _jspx_imports_classes.add("java.util.stream.Collectors");
    _jspx_imports_classes.add("org.silverpeas.core.admin.component.model.ComponentInstLight");
    _jspx_imports_classes.add("java.util.Objects");
    _jspx_imports_classes.add("java.util.List");
    _jspx_imports_classes.add("org.silverpeas.core.util.DateUtil");
    _jspx_imports_classes.add("org.silverpeas.core.questioncontainer.result.model.QuestionResult");
    _jspx_imports_classes.add("org.apache.ecs.xhtml.a");
    _jspx_imports_classes.add("java.util.Optional");
    _jspx_imports_classes.add("org.silverpeas.core.questioncontainer.answer.model.Answer");
    _jspx_imports_classes.add("org.silverpeas.core.util.WebEncodeHelper");
    _jspx_imports_classes.add("org.silverpeas.core.questioncontainer.question.model.Question");
    _jspx_imports_classes.add("java.util.HashMap");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.iconpanes.IconPane");
    _jspx_imports_classes.add("org.silverpeas.core.contribution.attachment.model.SimpleDocument");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayLine");
    _jspx_imports_classes.add("java.util.ArrayList");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.buttonpanes.ButtonPane");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellText");
    _jspx_imports_classes.add("org.silverpeas.core.admin.user.model.User");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayColumn");
    _jspx_imports_classes.add("org.silverpeas.core.questioncontainer.container.model.QuestionContainerDetail");
    _jspx_imports_classes.add("org.silverpeas.core.util.file.FileServerUtils");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.buttons.Button");
    _jspx_imports_classes.add("org.silverpeas.components.survey.SurveyException");
    _jspx_imports_classes.add("org.silverpeas.components.survey.web.AnswerEntity");
    _jspx_imports_classes.add("java.util.Iterator");
    _jspx_imports_classes.add("org.silverpeas.core.util.file.FileUploadUtil");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPane");
    _jspx_imports_classes.add("org.silverpeas.core.util.file.FileRepositoryManager");
    _jspx_imports_classes.add("org.apache.commons.fileupload.FileItem");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.icons.Icon");
    _jspx_imports_classes.add("org.silverpeas.core.questioncontainer.container.model.Comment");
    _jspx_imports_classes.add("org.silverpeas.kernel.bundle.SettingBundle");
    _jspx_imports_classes.add("org.silverpeas.core.util.JSONCodec");
    _jspx_imports_classes.add("java.net.URLEncoder");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.frame.Frame");
    _jspx_imports_classes.add("org.silverpeas.components.survey.web.AnswerPercentEntity");
    _jspx_imports_classes.add("org.silverpeas.core.questioncontainer.result.model.Results");
    _jspx_imports_classes.add("org.apache.ecs.xhtml.span");
    _jspx_imports_classes.add("org.apache.ecs.ElementContainer");
    _jspx_imports_classes.add("org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBar");
  }

  private volatile javax.el.ExpressionFactory _el_expressionfactory;
  private volatile org.apache.tomcat.InstanceManager _jsp_instancemanager;

  public java.util.Map<java.lang.String,java.lang.Long> getDependants() {
    return _jspx_dependants;
  }

  public java.util.Set<java.lang.String> getPackageImports() {
    return _jspx_imports_packages;
  }

  public java.util.Set<java.lang.String> getClassImports() {
    return _jspx_imports_classes;
  }

  public javax.el.ExpressionFactory _jsp_getExpressionFactory() {
    if (_el_expressionfactory == null) {
      synchronized (this) {
        if (_el_expressionfactory == null) {
          _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
        }
      }
    }
    return _el_expressionfactory;
  }

  public org.apache.tomcat.InstanceManager _jsp_getInstanceManager() {
    if (_jsp_instancemanager == null) {
      synchronized (this) {
        if (_jsp_instancemanager == null) {
          _jsp_instancemanager = org.apache.jasper.runtime.InstanceManagerFactory.getInstanceManager(getServletConfig());
        }
      }
    }
    return _jsp_instancemanager;
  }

  public void _jspInit() {
  }

  public void _jspDestroy() {
  }

  public void _jspService(final javax.servlet.http.HttpServletRequest request, final javax.servlet.http.HttpServletResponse response)
      throws java.io.IOException, javax.servlet.ServletException {

    if (!javax.servlet.DispatcherType.ERROR.equals(request.getDispatcherType())) {
      final java.lang.String _jspx_method = request.getMethod();
      if ("OPTIONS".equals(_jspx_method)) {
        response.setHeader("Allow","GET, HEAD, POST, OPTIONS");
        return;
      }
      if (!"GET".equals(_jspx_method) && !"POST".equals(_jspx_method) && !"HEAD".equals(_jspx_method)) {
        response.setHeader("Allow","GET, HEAD, POST, OPTIONS");
        response.sendError(HttpServletResponse.SC_METHOD_NOT_ALLOWED, "JSPs only permit GET, POST or HEAD. Jasper also permits OPTIONS");
        return;
      }
    }

    final javax.servlet.jsp.PageContext pageContext;
    javax.servlet.http.HttpSession session = null;
    final javax.servlet.ServletContext application;
    final javax.servlet.ServletConfig config;
    javax.servlet.jsp.JspWriter out = null;
    final java.lang.Object page = this;
    javax.servlet.jsp.JspWriter _jspx_out = null;
    javax.servlet.jsp.PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			"../../admin/jsp/errorpageMain.jsp", true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\n\n\n\n");
      out.write('\n');
      out.write('\n');
      out.write('\n');

response.setHeader("Cache-Control","no-store"); //HTTP 1.1
response.setHeader("Pragma","no-cache"); //HTTP 1.0
response.setDateHeader ("Expires",-1); //prevents caching at the proxy server

      out.write("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");

  SurveySessionController surveyScc = (SurveySessionController) request.getAttribute("survey");
  GraphicElementFactory gef = (GraphicElementFactory) session.getAttribute("SessionGraphicElementFactory");
  MultiSilverpeasBundle resources = (MultiSilverpeasBundle)request.getAttribute("resources");

  if (surveyScc == null) {
      // No session controller in the request -> security exception
      String sessionTimeout = ResourceLocator.getGeneralSettingBundle().getString("sessionTimeout");
      getServletConfig().getServletContext().getRequestDispatcher(sessionTimeout).forward(request, response);
      return;
  }

  LocalizationBundle generalMessage = ResourceLocator.getGeneralLocalizationBundle(
      surveyScc.getLanguage());

  String[] browseContext = (String[]) request.getAttribute("browseContext");
  String spaceLabel 		= browseContext[0];
  String componentLabel 	= browseContext[1];
  String spaceId 			= browseContext[2];
  String componentId 		= browseContext[3];

  boolean pollingStationMode = (componentId != null && componentId.startsWith("pollingStation"));

      out.write('\n');
      out.write('\n');
      out.write("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
      out.write('\n');
      out.write("\n\n\n\n\n\n");
      out.write('\n');
      if (_jspx_meth_fmt_005fsetLocale_005f0(_jspx_page_context))
        return;
      out.write('\n');
      if (_jspx_meth_view_005fsetBundle_005f0(_jspx_page_context))
        return;
      out.write('\n');
      out.write('\n');

	if (! surveyScc.isPollingStationMode()) {

      out.write('\n');
      if (_jspx_meth_fmt_005fmessage_005f0(_jspx_page_context))
        return;
      out.write('\n');
 
	} else { 

      out.write('\n');
      out.write(' ');
      out.write(' ');
      if (_jspx_meth_fmt_005fmessage_005f1(_jspx_page_context))
        return;
      out.write('\n');

	}

      out.write('\n');
      out.write('\n');

//Retrieve parameter
String action = request.getParameter("Action");
String surveyId = request.getParameter("SurveyId");

String title = request.getParameter("title");
String description = request.getParameter("description");
String creationDate = "";
String beginDate = request.getParameter("beginDate");
String endDate = request.getParameter("endDate");
String nbQuestions = request.getParameter("nbQuestions");
String nbVotersString = request.getParameter("nbVoters");
int nbVoters = 0;
if(nbVotersString != null) {
  nbVoters = Integer.parseInt(nbVotersString);
}

String appName = "survey";
if (surveyScc.isPollingStationMode()) {
  nbQuestions = "1";
  appName = "pollingStation";
}
String anonymousString = request.getParameter("anonymous");

//Anonymous mode -> force all the survey to be anonymous
if(surveyScc.isAnonymousModeEnabled()) {
	anonymousString = "on";
}

boolean anonymous = StringUtil.isDefined(anonymousString) && "on".equalsIgnoreCase(anonymousString);

String resultMode = request.getParameter("resultMode");
String resultView = request.getParameter("resultView");

String m_context = ResourceLocator.getGeneralSettingBundle().getString("ApplicationURL");

//Icons
String mandatoryField = m_context + "/util/icons/mandatoryField.gif";

QuestionContainerDetail survey = null;
if ("SendSurveyHeader".equals(action)) {
      if (beginDate != null) {
          if (beginDate.length()>0)
            beginDate = resources.getDBDate(beginDate);
          else
            beginDate = null;
      }
      if (endDate != null) {
          if (endDate.length()>0)
            endDate = resources.getDBDate(endDate);
          else
            endDate = null;
      }
      
      int resultModeInt = QuestionContainerHeader.IMMEDIATE_RESULTS;
      int resultViewInt = QuestionContainerHeader.TWICE_DISPLAY_RESULTS;
      
      if (! surveyScc.isPollingStationMode()) { 
	      resultModeInt = Integer.parseInt(resultMode);
	      resultViewInt = Integer.parseInt(resultView);
	      if(resultModeInt == QuestionContainerHeader.IMMEDIATE_RESULTS) {
	        resultViewInt = QuestionContainerHeader.TWICE_DISPLAY_RESULTS;
	      } else if (resultModeInt == QuestionContainerHeader.DELAYED_RESULTS) {
	        resultViewInt = QuestionContainerHeader.NOTHING_DISPLAY_RESULTS;
	      }
      }
      QuestionContainerHeader surveyHeader = new QuestionContainerHeader(null, title, description, null, null, beginDate, endDate, false, nbVoters, new Integer(nbQuestions).intValue(), anonymous, resultModeInt, resultViewInt);
      surveyScc.updateSurveyHeader(surveyHeader, surveyId);
      action = "UpdateSurveyHeader";
      request.setAttribute("UpdateSucceed", "true");
}
if ("UpdateSurveyHeader".equals(action))
{
         survey = surveyScc.getSurvey(surveyId);
         QuestionContainerHeader surveyHeader = survey.getHeader();
         title = WebEncodeHelper.javaStringToHtmlString(surveyHeader.getTitle());
         description = WebEncodeHelper.javaStringToHtmlString(surveyHeader.getDescription());
         creationDate = resources.getOutputDate(surveyHeader.getCreationDate());
         beginDate = "";
         if (surveyHeader.getBeginDate() != null)
             beginDate = resources.getInputDate(surveyHeader.getBeginDate());
         endDate = "";
         if (surveyHeader.getEndDate() != null)
             endDate = resources.getInputDate(surveyHeader.getEndDate());
         if (!surveyScc.isPollingStationMode()) {
         	nbQuestions = new Integer(surveyHeader.getNbQuestionsPerPage()).toString();
         }
         anonymous = surveyHeader.isAnonymous();

          //Mode anonyme -> force les enquetes a etre toutes anonymes
          if(surveyScc.isAnonymousModeEnabled()) {
            anonymous = true;
          }

          resultMode = Integer.toString(surveyHeader.getResultMode());
          resultView = Integer.toString(surveyHeader.getResultView());

      out.write("\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<title></title>\n");
      if (_jspx_meth_view_005flooknfeel_005f0(_jspx_page_context))
        return;
      out.write('\n');
      if (_jspx_meth_view_005fincludePlugin_005f0(_jspx_page_context))
        return;
      out.write("\n<script type=\"text/javascript\" src=\"");
      out.print(m_context);
      out.write("/util/javaScript/dateUtils.js\"></script>\n<script type=\"text/javascript\">\nfunction sendData() {\n    ifCorrectFormExecute(function() {\n		  document.surveyForm.anonymous.disabled = false;\n      document.surveyForm.submit();\n    });\n}\n\nfunction ifCorrectFormExecute(callback) {\n     var errorMsg = \"\";\n     var errorNb = 0;\n     var title = stripInitialWhitespace(document.surveyForm.title.value);\n     var beginDate = document.surveyForm.beginDate.value;\n     var endDate = document.surveyForm.endDate.value;\n     var beginDateOK = true;\n     \n     if (isWhitespace(title)) {\n           errorMsg+=\"  - ");
      out.print(resources.getString("GML.theField"));
      out.write(' ');
      out.write('\'');
      out.print(resources.getString("GML.name"));
      out.write('\'');
      out.write(' ');
      out.print(resources.getString("GML.MustBeFilled"));
      out.write("\\n\";\n           errorNb++;\n     }\n     ");
 if (!surveyScc.isPollingStationMode()) { 
      out.write("\n     if (!isValidTextArea(document.surveyForm.description)) {\n          errorMsg+=\"  - ");
      out.print(resources.getString("GML.theField"));
      out.write(' ');
      out.write('\'');
      out.print(resources.getString("SurveyCreationDescription"));
      out.write('\'');
      out.write(' ');
      out.print(resources.getString("ContainsTooLargeText"));
      out.write(' ');
      out.print(DBUtil.getTextAreaLength());
      out.write(' ');
      out.print(resources.getString("Characters"));
      out.write("\\n\";\n          errorNb++;\n     }\n     ");
 } 
      out.write("\n     if (!isWhitespace(beginDate)) {\n     	if (!isDateOK(beginDate, '");
      out.print(resources.getLanguage());
      out.write("')) {\n           errorMsg+=\"  - ");
      out.print(resources.getString("GML.theField"));
      out.write(' ');
      out.write('\'');
      out.print(resources.getString("SurveyCreationBeginDate"));
      out.write('\'');
      out.write(' ');
      out.print(resources.getString("GML.MustContainsCorrectDate"));
      out.write("\\n\";\n           errorNb++;\n           beginDateOK = false;\n         }\n       }\n       if (!isWhitespace(endDate)) {\n         if (!isDateOK(endDate, '");
      out.print(resources.getLanguage());
      out.write("')) {\n           errorMsg+=\"  - ");
      out.print(resources.getString("GML.theField"));
      out.write(' ');
      out.write('\'');
      out.print(resources.getString("SurveyCreationEndDate"));
      out.write('\'');
      out.write(' ');
      out.print(resources.getString("GML.MustContainsCorrectDate"));
      out.write("\\n\";\n           errorNb++;\n         } else {\n             if (!isWhitespace(beginDate) && !isWhitespace(endDate)) {\n               if (beginDateOK && !isDate1AfterDate2(endDate, beginDate, '");
      out.print(resources.getLanguage());
      out.write("')) {\n                 errorMsg+=\"  - ");
      out.print(resources.getString("GML.theField"));
      out.write(' ');
      out.write('\'');
      out.print(resources.getString("SurveyCreationEndDate"));
      out.write('\'');
      out.write(' ');
      out.print(resources.getString("GML.MustContainsPostDateTo"));
      out.write(' ');
      out.write('\'');
      out.print(resources.getString("SurveyCreationBeginDate"));
      out.write("'\\n\";\n                 errorNb++;\n               }\n             } else {\n               if (isWhitespace(beginDate) && !isWhitespace(endDate)) {\n                 if (!isFuture(endDate, '");
      out.print(resources.getLanguage());
      out.write("')) {\n                   errorMsg+=\"  - ");
      out.print(resources.getString("GML.theField"));
      out.write(' ');
      out.write('\'');
      out.print(resources.getString("SurveyCreationEndDate"));
      out.write('\'');
      out.write(' ');
      out.print(resources.getString("GML.MustContainsPostDate"));
      out.write("\\n\";\n                   errorNb++;\n                 }\n               }\n             }\n         }\n       }\n     ");
 if (!surveyScc.isPollingStationMode()) { 
      out.write("\n     var nbQuestions = document.surveyForm.nbQuestions.value;\n     if (isWhitespace(nbQuestions)) {\n           errorMsg+=\"  - ");
      out.print(resources.getString("GML.theField"));
      out.write(' ');
      out.write('\'');
      out.print(resources.getString("SurveyCreationNbQuestionPerPage"));
      out.write('\'');
      out.write(' ');
      out.print(resources.getString("GML.MustBeFilled"));
      out.write("\\n\";\n           errorNb++;\n     } else {\n           if (isInteger(nbQuestions) == false) {\n               errorMsg+=\"  - ");
      out.print(resources.getString("GML.theField"));
      out.write(' ');
      out.write('\'');
      out.print(resources.getString("SurveyCreationNbQuestionPerPage"));
      out.write('\'');
      out.write(' ');
      out.print(resources.getString("GML.MustContainsFloat"));
      out.write("\\n\";\n               errorNb++;\n           } else {\n                if (nbQuestions <= 0) {\n                   errorMsg+=\"  - ");
      out.print(resources.getString("GML.theField"));
      out.write(' ');
      out.write('\'');
      out.print(resources.getString("SurveyCreationNbQuestionPerPage"));
      out.write('\'');
      out.write(' ');
      out.print(resources.getString("MustContainsPositiveNumber"));
      out.write("\\n\";\n                   errorNb++;\n                }\n           }\n     }\n     ");
 } 
      out.write("\n     \n  	");
      if (_jspx_meth_view_005fpdcValidateClassification_005f0(_jspx_page_context))
        return;
      out.write("\n  \n     switch(errorNb) {\n       case 0 :\n            callback.call(this);\n            break;\n        case 1 :\n            errorMsg = \"");
      out.print(resources.getString("GML.ThisFormContains"));
      out.write(' ');
      out.write('1');
      out.write(' ');
      out.print(resources.getString("GML.error"));
      out.write(" : \\n\" + errorMsg;\n            jQuery.popup.error(errorMsg);\n            break;\n        default :\n            errorMsg = \"");
      out.print(resources.getString("GML.ThisFormContains"));
      out.write(" \" + errorNb + \" ");
      out.print(resources.getString("GML.errors"));
      out.write(" :\\n\" + errorMsg;\n            jQuery.popup.error(errorMsg);\n     }\n}\n\nfunction updateQuestions(surveyId, name, nbVotes)\n{\n  var voteNumbers = parseInt(nbVotes);\n  if(voteNumbers == 0) {\n    reallyUpdateQuestions(surveyId);\n  } else {\n    var label = \"");
      if (_jspx_meth_view_005fencodeJs_005f0(_jspx_page_context))
        return;
      out.write(" '\" + name + \"' ?\";\n    jQuery.popup.confirm(label, function() {\n      reallyUpdateQuestions(surveyId);\n    });\n  }\n}\n\nfunction reallyUpdateQuestions(surveyId) {\n  document.surveyForm.action = \"QuestionsUpdate\";\n  document.surveyForm.Action.value = \"UpdateQuestions\";\n  document.surveyForm.SurveyId.value = surveyId;\n  document.surveyForm.submit();\n}\n\n</script>\n</head>\n<body class=\"");
      out.print(appName);
      out.write('"');
      out.write('>');
      out.write('\n');

        Window window = gef.getWindow();
        Frame frame = gef.getFrame();
        Board board = gef.getBoard();

        BrowseBar browseBar = window.getBrowseBar();
        browseBar.setDomainName(surveyScc.getSpaceLabel());
        browseBar.setComponentName(surveyScc.getComponentLabel(),"surveyList.jsp?Action=View");
        browseBar.setExtraInformation(resources.getString("SurveyUpdate")+" '"+survey.getHeader().getTitle()+"'");

        out.println(window.printBefore());

        TabbedPane tabbedPane = gef.getTabbedPane();
        tabbedPane.addTab(resources.getString("GML.head"), "surveyUpdate.jsp?Action=UpdateSurveyHeader&SurveyId="+surveyId, action.equals("UpdateSurveyHeader"), true);
        String surveyTabPanelLabel = resources.getString("SurveyQuestions");
        if (surveyScc.isPollingStationMode()) {
          surveyTabPanelLabel = resources.getString("SurveyQuestion");
        }
        tabbedPane.addTab(surveyTabPanelLabel, "javascript:updateQuestions('"+surveyId+"', '" +
            WebEncodeHelper.javaStringToHtmlString(WebEncodeHelper.javaStringToJsString(surveyHeader.getTitle())) + "', '" +
        	surveyHeader.getNbVoters() + "')", action.equals("UpdateQuestions"), true);
        out.println(tabbedPane.print());
        
      out.write('\n');
      if (_jspx_meth_c_005fchoose_005f0(_jspx_page_context))
        return;
      out.write('\n');

        out.println(frame.printBefore());

      out.write("\n\n<form name=\"surveyForm\" action=\"surveyUpdate.jsp\" method=\"post\">\n<fieldset id=\"info\" class=\"skinFieldset\">\n	<legend>");
      out.print(resources.getString("survey.header.fieldset.info") );
      out.write("</legend>\n	<div class=\"fields\">\n		<div class=\"field\" id=\"nameArea\">\n			<label class=\"txtlibform\" for=\"title\">");
      out.print(resources.getString("GML.name"));
      out.write("</label>\n			<div class=\"champs\">\n				<input type=\"text\" name=\"title\" size=\"60\" maxlength=\"60\" value=\"");
      out.print(title);
      out.write("\">&nbsp;<img border=\"0\" src=\"");
      out.print(mandatoryField);
      out.write("\" width=\"5\" height=\"5\"/>\n			</div>\n		</div>\n		");
 if (!surveyScc.isPollingStationMode()) { 
      out.write("\n		<div class=\"field\" id=\"questionArea\">\n			<label class=\"txtlibform\">");
      out.print(resources.getString("SurveyCreationDescription"));
      out.write("</label>\n			<div class=\"champs\">\n				<textarea name=\"description\" cols=\"80\" rows=\"4\">");
      out.print(description);
      out.write("</textarea>\n			</div>\n		</div>\n		");
 } 
      out.write('\n');
      out.write('	');
      out.write('	');

		    
		
      out.write('\n');
      out.write('	');
      out.write('	');
 if (!surveyScc.isPollingStationMode()) { 
      out.write("\n		<div class=\"field\" id=\"nbQuestionsArea\">\n			<label class=\"txtlibform\">");
      out.print(resources.getString("SurveyCreationNbQuestionPerPage"));
      out.write("</label>\n			<div class=\"champs\">\n				<input type=\"text\" name=\"nbQuestions\" size=\"5\" value=\"");
      out.print(nbQuestions);
      out.write("\" maxlength=\"2\"/>&nbsp;<img border=\"0\" src=\"");
      out.print(mandatoryField);
      out.write("\" width=\"5\" height=\"5\"/>\n			</div>\n		</div>\n		");
 } 
      out.write("\n		\n		<div class=\"field\" id=\"anonymousArea\">\n			");

				String anonymousLabel = resources.getString("survey.surveyAnonymous");
	    		if (surveyScc.isPollingStationMode()) {
	    			anonymousLabel = resources.getString("survey.pollAnonymous");
	      		}
	    
		        //Mode anonyme -> force les votes à être tous anonymes
		        String anonymousDisabled = "";
		        String anonymousCheck = "";
		        if (anonymous) {
	  		      	anonymousCheck = "checked=\"checked\"";
	  		  	}
		        if(surveyScc.isAnonymousModeEnabled()) {
		          anonymousCheck = "checked=\"checked\"";
		          anonymousDisabled = "disabled=\"disabled\"";
		        }
			
      out.write("\n			<label class=\"txtlibform\">");
      out.print(anonymousLabel);
      out.write("</label>\n			<div class=\"champs\">\n				<input type=\"checkbox\" name=\"anonymous\" ");
      out.print(anonymousCheck);
      out.write(' ');
      out.print(anonymousDisabled);
      out.write("/>\n			</div>\n		</div>\n		");
 if (! surveyScc.isPollingStationMode()) { 
      out.write("\n		<div class=\"field\" id=\"resultModeArea\">\n        <label class=\"txtlibform\" for=\"resultMode\">");
      out.print(resources.getString("survey.creation.resultMode"));
      out.write("</label>\n        <div class=\"champs\">\n          <select id=\"resultMode\" name=\"resultMode\">\n            ");

            String selectedStr = "";
            if (Integer.parseInt(resultMode) == QuestionContainerHeader.IMMEDIATE_RESULTS) {
              selectedStr = "selected";
            }
            
      out.write("\n              <option ");
      out.print(selectedStr);
      out.write(" value=\"");
      out.print(QuestionContainerHeader.IMMEDIATE_RESULTS);
      out.write('"');
      out.write('>');
      out.print(resources.getString("survey.creation.resultMode.1"));
      out.write("</option>\n            ");

            selectedStr = "";
            if (Integer.parseInt(resultMode) == QuestionContainerHeader.DELAYED_RESULTS) {
              selectedStr = "selected";
            }
            
      out.write("\n              <option ");
      out.print(selectedStr);
      out.write(" value=\"");
      out.print(QuestionContainerHeader.DELAYED_RESULTS);
      out.write('"');
      out.write('>');
      out.print(resources.getString("survey.creation.resultMode.2"));
      out.write("</option>\n          </select>\n        </div>\n    </div>\n    ");
} 
      out.write("\n	<input type=\"hidden\" name=\"Action\" value=\"SendSurveyHeader\"/>\n    <input type=\"hidden\" name=\"NextAction\"/>\n    <input type=\"hidden\" name=\"SurveyId\" value=\"");
      out.print(surveyId);
      out.write("\"/>\n    <input type=\"hidden\" name=\"resultView\" value=\"");
      out.print(resultView);
      out.write("\"/>\n    <input type=\"hidden\" name=\"nbVoters\" value=\"");
      out.print(surveyHeader.getNbVoters());
      out.write("\"/>\n	</div>\n</fieldset>\n\n<fieldset id=\"dates\" class=\"skinFieldset\">\n		<legend>");
      out.print(resources.getString("survey.header.fieldset.period") );
      out.write("</legend>\n		<div class=\"fields\">\n			<div class=\"field\" id=\"beginArea\">\n				<label for=\"beginDate\" class=\"txtlibform\">");
      out.print(resources.getString("SurveyCreationBeginDate"));
      out.write("</label>\n				<div class=\"champs\">\n					<input type=\"text\" class=\"dateToPick\" name=\"beginDate\" size=\"12\" value=\"");
      out.print(beginDate);
      out.write("\" maxlength=\"");
      out.print(DBUtil.getDateFieldLength());
      out.write("\"/>	\n				</div>\n			</div>\n			<div class=\"field\" id=\"endArea\">\n				<label for=\"beginDate\" class=\"txtlibform\">");
      out.print(resources.getString("SurveyCreationEndDate"));
      out.write("</label>\n				<div class=\"champs\">\n					<input type=\"text\" class=\"dateToPick\" name=\"endDate\" size=\"12\" value=\"");
      out.print(endDate);
      out.write("\" maxlength=\"");
      out.print(DBUtil.getDateFieldLength());
      out.write("\"/>\n				</div>\n			</div>\n		</div>\n</fieldset>\n\n");
      //  view:pdcClassification
      org.silverpeas.core.web.util.viewgenerator.html.pdc.PdcClassificationTag _jspx_th_view_005fpdcClassification_005f0 = new org.silverpeas.core.web.util.viewgenerator.html.pdc.PdcClassificationTag();
      _jsp_getInstanceManager().newInstance(_jspx_th_view_005fpdcClassification_005f0);
      try {
        _jspx_th_view_005fpdcClassification_005f0.setJspContext(_jspx_page_context);
        // /survey/jsp/surveyUpdate.jsp(402,0) name = componentId type = java.lang.String reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
        _jspx_th_view_005fpdcClassification_005f0.setComponentId( componentId );
        // /survey/jsp/surveyUpdate.jsp(402,0) name = contentId type = java.lang.String reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
        _jspx_th_view_005fpdcClassification_005f0.setContentId( surveyId );
        // /survey/jsp/surveyUpdate.jsp(402,0) name = editable type = java.lang.Boolean reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
        _jspx_th_view_005fpdcClassification_005f0.setEditable(true);
        _jspx_th_view_005fpdcClassification_005f0.doTag();
      } finally {
        _jsp_getInstanceManager().destroyInstance(_jspx_th_view_005fpdcClassification_005f0);
      }
      out.write("\n\n<div class=\"legend\">\n	<img src=\"");
      out.print(mandatoryField);
      out.write("\" width=\"5\" height=\"5\"/> : ");
      out.print(resources.getString("GML.requiredField"));
      out.write("\n</div>\n\n</form>\n\n");

        out.println(frame.printMiddle());
        Button validateButton = gef.getFormButton(resources.getString("GML.validate"), "javascript:onClick=sendData()", false);
        ButtonPane buttonPane = gef.getButtonPane();
        buttonPane.addButton(validateButton);
        buttonPane.setHorizontalPosition();
        out.println("<center>"+buttonPane.print()+"</center>");
        out.println(frame.printAfter());
        out.println(window.printAfter());

      out.write("\n</body>\n</html>\n");
 } 
      out.write('\n');
    } catch (java.lang.Throwable t) {
      if (!(t instanceof javax.servlet.jsp.SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try {
            if (response.isCommitted()) {
              out.flush();
            } else {
              out.clearBuffer();
            }
          } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }

  private boolean _jspx_meth_fmt_005fsetLocale_005f0(javax.servlet.jsp.PageContext _jspx_page_context)
          throws java.lang.Throwable {
    javax.servlet.jsp.PageContext pageContext = _jspx_page_context;
    javax.servlet.jsp.JspWriter out = _jspx_page_context.getOut();
    //  fmt:setLocale
    org.apache.taglibs.standard.tag.rt.fmt.SetLocaleTag _jspx_th_fmt_005fsetLocale_005f0 = new org.apache.taglibs.standard.tag.rt.fmt.SetLocaleTag();
    _jsp_getInstanceManager().newInstance(_jspx_th_fmt_005fsetLocale_005f0);
    _jspx_th_fmt_005fsetLocale_005f0.setPageContext(_jspx_page_context);
    _jspx_th_fmt_005fsetLocale_005f0.setParent(null);
    // /survey/jsp/surveyUpdate.jsp(37,0) name = value type = null reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_fmt_005fsetLocale_005f0.setValue((java.lang.Object) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${sessionScope['SilverSessionController'].favoriteLanguage}", java.lang.Object.class, (javax.servlet.jsp.PageContext)_jspx_page_context, null));
    int _jspx_eval_fmt_005fsetLocale_005f0 = _jspx_th_fmt_005fsetLocale_005f0.doStartTag();
    if (_jspx_th_fmt_005fsetLocale_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      return true;
    }
    org.apache.jasper.runtime.JspRuntimeLibrary.releaseTag(_jspx_th_fmt_005fsetLocale_005f0, _jsp_getInstanceManager());
    return false;
  }

  private boolean _jspx_meth_view_005fsetBundle_005f0(javax.servlet.jsp.PageContext _jspx_page_context)
          throws java.lang.Throwable {
    javax.servlet.jsp.PageContext pageContext = _jspx_page_context;
    javax.servlet.jsp.JspWriter out = _jspx_page_context.getOut();
    //  view:setBundle
    org.silverpeas.core.web.util.viewgenerator.html.SetBundleTag _jspx_th_view_005fsetBundle_005f0 = new org.silverpeas.core.web.util.viewgenerator.html.SetBundleTag();
    _jsp_getInstanceManager().newInstance(_jspx_th_view_005fsetBundle_005f0);
    _jspx_th_view_005fsetBundle_005f0.setPageContext(_jspx_page_context);
    _jspx_th_view_005fsetBundle_005f0.setParent(null);
    // /survey/jsp/surveyUpdate.jsp(38,0) name = bundle type = org.silverpeas.kernel.bundle.SilverpeasBundle reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_view_005fsetBundle_005f0.setBundle((org.silverpeas.kernel.bundle.SilverpeasBundle) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${requestScope.resources.multilangBundle}", org.silverpeas.kernel.bundle.SilverpeasBundle.class, (javax.servlet.jsp.PageContext)_jspx_page_context, null));
    int _jspx_eval_view_005fsetBundle_005f0 = _jspx_th_view_005fsetBundle_005f0.doStartTag();
    if (_jspx_th_view_005fsetBundle_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      return true;
    }
    org.apache.jasper.runtime.JspRuntimeLibrary.releaseTag(_jspx_th_view_005fsetBundle_005f0, _jsp_getInstanceManager());
    return false;
  }

  private boolean _jspx_meth_fmt_005fmessage_005f0(javax.servlet.jsp.PageContext _jspx_page_context)
          throws java.lang.Throwable {
    javax.servlet.jsp.PageContext pageContext = _jspx_page_context;
    javax.servlet.jsp.JspWriter out = _jspx_page_context.getOut();
    //  fmt:message
    org.apache.taglibs.standard.tag.rt.fmt.MessageTag _jspx_th_fmt_005fmessage_005f0 = new org.apache.taglibs.standard.tag.rt.fmt.MessageTag();
    _jsp_getInstanceManager().newInstance(_jspx_th_fmt_005fmessage_005f0);
    _jspx_th_fmt_005fmessage_005f0.setPageContext(_jspx_page_context);
    _jspx_th_fmt_005fmessage_005f0.setParent(null);
    // /survey/jsp/surveyUpdate.jsp(43,0) name = var type = java.lang.String reqTime = false required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_fmt_005fmessage_005f0.setVar("surveyConfirmUpdateLabel");
    // /survey/jsp/surveyUpdate.jsp(43,0) name = key type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_fmt_005fmessage_005f0.setKey("survey.confirmUpdateSurvey");
    int _jspx_eval_fmt_005fmessage_005f0 = _jspx_th_fmt_005fmessage_005f0.doStartTag();
    if (_jspx_th_fmt_005fmessage_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      return true;
    }
    org.apache.jasper.runtime.JspRuntimeLibrary.releaseTag(_jspx_th_fmt_005fmessage_005f0, _jsp_getInstanceManager());
    return false;
  }

  private boolean _jspx_meth_fmt_005fmessage_005f1(javax.servlet.jsp.PageContext _jspx_page_context)
          throws java.lang.Throwable {
    javax.servlet.jsp.PageContext pageContext = _jspx_page_context;
    javax.servlet.jsp.JspWriter out = _jspx_page_context.getOut();
    //  fmt:message
    org.apache.taglibs.standard.tag.rt.fmt.MessageTag _jspx_th_fmt_005fmessage_005f1 = new org.apache.taglibs.standard.tag.rt.fmt.MessageTag();
    _jsp_getInstanceManager().newInstance(_jspx_th_fmt_005fmessage_005f1);
    _jspx_th_fmt_005fmessage_005f1.setPageContext(_jspx_page_context);
    _jspx_th_fmt_005fmessage_005f1.setParent(null);
    // /survey/jsp/surveyUpdate.jsp(47,2) name = var type = java.lang.String reqTime = false required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_fmt_005fmessage_005f1.setVar("surveyConfirmUpdateLabel");
    // /survey/jsp/surveyUpdate.jsp(47,2) name = key type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_fmt_005fmessage_005f1.setKey("survey.confirmUpdatePoll");
    int _jspx_eval_fmt_005fmessage_005f1 = _jspx_th_fmt_005fmessage_005f1.doStartTag();
    if (_jspx_th_fmt_005fmessage_005f1.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      return true;
    }
    org.apache.jasper.runtime.JspRuntimeLibrary.releaseTag(_jspx_th_fmt_005fmessage_005f1, _jsp_getInstanceManager());
    return false;
  }

  private boolean _jspx_meth_view_005flooknfeel_005f0(javax.servlet.jsp.PageContext _jspx_page_context)
          throws java.lang.Throwable {
    javax.servlet.jsp.PageContext pageContext = _jspx_page_context;
    javax.servlet.jsp.JspWriter out = _jspx_page_context.getOut();
    //  view:looknfeel
    org.silverpeas.core.web.util.viewgenerator.html.LookAndStyleTag _jspx_th_view_005flooknfeel_005f0 = new org.silverpeas.core.web.util.viewgenerator.html.LookAndStyleTag();
    _jsp_getInstanceManager().newInstance(_jspx_th_view_005flooknfeel_005f0);
    _jspx_th_view_005flooknfeel_005f0.setPageContext(_jspx_page_context);
    _jspx_th_view_005flooknfeel_005f0.setParent(null);
    // /survey/jsp/surveyUpdate.jsp(153,0) name = withFieldsetStyle type = boolean reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_view_005flooknfeel_005f0.setWithFieldsetStyle(true);
    // /survey/jsp/surveyUpdate.jsp(153,0) name = withCheckFormScript type = boolean reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_view_005flooknfeel_005f0.setWithCheckFormScript(true);
    int _jspx_eval_view_005flooknfeel_005f0 = _jspx_th_view_005flooknfeel_005f0.doStartTag();
    if (_jspx_th_view_005flooknfeel_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      return true;
    }
    org.apache.jasper.runtime.JspRuntimeLibrary.releaseTag(_jspx_th_view_005flooknfeel_005f0, _jsp_getInstanceManager());
    return false;
  }

  private boolean _jspx_meth_view_005fincludePlugin_005f0(javax.servlet.jsp.PageContext _jspx_page_context)
          throws java.lang.Throwable {
    javax.servlet.jsp.PageContext pageContext = _jspx_page_context;
    javax.servlet.jsp.JspWriter out = _jspx_page_context.getOut();
    //  view:includePlugin
    org.silverpeas.core.web.util.viewgenerator.html.IncludeJSPluginTag _jspx_th_view_005fincludePlugin_005f0 = new org.silverpeas.core.web.util.viewgenerator.html.IncludeJSPluginTag();
    _jsp_getInstanceManager().newInstance(_jspx_th_view_005fincludePlugin_005f0);
    try {
      _jspx_th_view_005fincludePlugin_005f0.setJspContext(_jspx_page_context);
      // /survey/jsp/surveyUpdate.jsp(154,0) name = name type = java.lang.String reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_view_005fincludePlugin_005f0.setName("datepicker");
      _jspx_th_view_005fincludePlugin_005f0.doTag();
    } finally {
      _jsp_getInstanceManager().destroyInstance(_jspx_th_view_005fincludePlugin_005f0);
    }
    return false;
  }

  private boolean _jspx_meth_view_005fpdcValidateClassification_005f0(javax.servlet.jsp.PageContext _jspx_page_context)
          throws java.lang.Throwable {
    javax.servlet.jsp.PageContext pageContext = _jspx_page_context;
    javax.servlet.jsp.JspWriter out = _jspx_page_context.getOut();
    //  view:pdcValidateClassification
    org.silverpeas.core.web.util.viewgenerator.html.pdc.PdcClassificationValidationTag _jspx_th_view_005fpdcValidateClassification_005f0 = new org.silverpeas.core.web.util.viewgenerator.html.pdc.PdcClassificationValidationTag();
    _jsp_getInstanceManager().newInstance(_jspx_th_view_005fpdcValidateClassification_005f0);
    try {
      _jspx_th_view_005fpdcValidateClassification_005f0.setJspContext(_jspx_page_context);
      // /survey/jsp/surveyUpdate.jsp(227,3) name = errorCounter type = java.lang.String reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_view_005fpdcValidateClassification_005f0.setErrorCounter("errorNb");
      // /survey/jsp/surveyUpdate.jsp(227,3) name = errorMessager type = java.lang.String reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
      _jspx_th_view_005fpdcValidateClassification_005f0.setErrorMessager("errorMsg");
      _jspx_th_view_005fpdcValidateClassification_005f0.doTag();
    } finally {
      _jsp_getInstanceManager().destroyInstance(_jspx_th_view_005fpdcValidateClassification_005f0);
    }
    return false;
  }

  private boolean _jspx_meth_view_005fencodeJs_005f0(javax.servlet.jsp.PageContext _jspx_page_context)
          throws java.lang.Throwable {
    javax.servlet.jsp.PageContext pageContext = _jspx_page_context;
    javax.servlet.jsp.JspWriter out = _jspx_page_context.getOut();
    //  view:encodeJs
    org.silverpeas.core.web.util.viewgenerator.html.JavascriptEncoderTag _jspx_th_view_005fencodeJs_005f0 = new org.silverpeas.core.web.util.viewgenerator.html.JavascriptEncoderTag();
    _jsp_getInstanceManager().newInstance(_jspx_th_view_005fencodeJs_005f0);
    _jspx_th_view_005fencodeJs_005f0.setPageContext(_jspx_page_context);
    _jspx_th_view_005fencodeJs_005f0.setParent(null);
    // /survey/jsp/surveyUpdate.jsp(249,17) name = string type = java.lang.String reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_view_005fencodeJs_005f0.setString((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${surveyConfirmUpdateLabel}", java.lang.String.class, (javax.servlet.jsp.PageContext)_jspx_page_context, null));
    int _jspx_eval_view_005fencodeJs_005f0 = _jspx_th_view_005fencodeJs_005f0.doStartTag();
    if (_jspx_th_view_005fencodeJs_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      return true;
    }
    org.apache.jasper.runtime.JspRuntimeLibrary.releaseTag(_jspx_th_view_005fencodeJs_005f0, _jsp_getInstanceManager());
    return false;
  }

  private boolean _jspx_meth_c_005fchoose_005f0(javax.servlet.jsp.PageContext _jspx_page_context)
          throws java.lang.Throwable {
    javax.servlet.jsp.PageContext pageContext = _jspx_page_context;
    javax.servlet.jsp.JspWriter out = _jspx_page_context.getOut();
    //  c:choose
    org.apache.taglibs.standard.tag.common.core.ChooseTag _jspx_th_c_005fchoose_005f0 = new org.apache.taglibs.standard.tag.common.core.ChooseTag();
    _jsp_getInstanceManager().newInstance(_jspx_th_c_005fchoose_005f0);
    _jspx_th_c_005fchoose_005f0.setPageContext(_jspx_page_context);
    _jspx_th_c_005fchoose_005f0.setParent(null);
    int _jspx_eval_c_005fchoose_005f0 = _jspx_th_c_005fchoose_005f0.doStartTag();
    if (_jspx_eval_c_005fchoose_005f0 != javax.servlet.jsp.tagext.Tag.SKIP_BODY) {
      do {
        out.write('\n');
        out.write(' ');
        out.write(' ');
        if (_jspx_meth_c_005fwhen_005f0(_jspx_th_c_005fchoose_005f0, _jspx_page_context))
          return true;
        out.write('\n');
        int evalDoAfterBody = _jspx_th_c_005fchoose_005f0.doAfterBody();
        if (evalDoAfterBody != javax.servlet.jsp.tagext.BodyTag.EVAL_BODY_AGAIN)
          break;
      } while (true);
    }
    if (_jspx_th_c_005fchoose_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      return true;
    }
    org.apache.jasper.runtime.JspRuntimeLibrary.releaseTag(_jspx_th_c_005fchoose_005f0, _jsp_getInstanceManager());
    return false;
  }

  private boolean _jspx_meth_c_005fwhen_005f0(javax.servlet.jsp.tagext.JspTag _jspx_th_c_005fchoose_005f0, javax.servlet.jsp.PageContext _jspx_page_context)
          throws java.lang.Throwable {
    javax.servlet.jsp.PageContext pageContext = _jspx_page_context;
    javax.servlet.jsp.JspWriter out = _jspx_page_context.getOut();
    //  c:when
    org.apache.taglibs.standard.tag.rt.core.WhenTag _jspx_th_c_005fwhen_005f0 = new org.apache.taglibs.standard.tag.rt.core.WhenTag();
    _jsp_getInstanceManager().newInstance(_jspx_th_c_005fwhen_005f0);
    _jspx_th_c_005fwhen_005f0.setPageContext(_jspx_page_context);
    _jspx_th_c_005fwhen_005f0.setParent((javax.servlet.jsp.tagext.Tag) _jspx_th_c_005fchoose_005f0);
    // /survey/jsp/surveyUpdate.jsp(290,2) name = test type = boolean reqTime = true required = true fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_c_005fwhen_005f0.setTest(((java.lang.Boolean) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${requestScope['UpdateSucceed']}", boolean.class, (javax.servlet.jsp.PageContext)_jspx_page_context, null)).booleanValue());
    int _jspx_eval_c_005fwhen_005f0 = _jspx_th_c_005fwhen_005f0.doStartTag();
    if (_jspx_eval_c_005fwhen_005f0 != javax.servlet.jsp.tagext.Tag.SKIP_BODY) {
      do {
        out.write("\n    <div class=\"inlineMessage inlineMessage-ok\">\n      ");
        if (_jspx_meth_fmt_005fmessage_005f2(_jspx_th_c_005fwhen_005f0, _jspx_page_context))
          return true;
        out.write("\n    </div><br clear=\"all\"/>\n  ");
        int evalDoAfterBody = _jspx_th_c_005fwhen_005f0.doAfterBody();
        if (evalDoAfterBody != javax.servlet.jsp.tagext.BodyTag.EVAL_BODY_AGAIN)
          break;
      } while (true);
    }
    if (_jspx_th_c_005fwhen_005f0.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      return true;
    }
    org.apache.jasper.runtime.JspRuntimeLibrary.releaseTag(_jspx_th_c_005fwhen_005f0, _jsp_getInstanceManager());
    return false;
  }

  private boolean _jspx_meth_fmt_005fmessage_005f2(javax.servlet.jsp.tagext.JspTag _jspx_th_c_005fwhen_005f0, javax.servlet.jsp.PageContext _jspx_page_context)
          throws java.lang.Throwable {
    javax.servlet.jsp.PageContext pageContext = _jspx_page_context;
    javax.servlet.jsp.JspWriter out = _jspx_page_context.getOut();
    //  fmt:message
    org.apache.taglibs.standard.tag.rt.fmt.MessageTag _jspx_th_fmt_005fmessage_005f2 = new org.apache.taglibs.standard.tag.rt.fmt.MessageTag();
    _jsp_getInstanceManager().newInstance(_jspx_th_fmt_005fmessage_005f2);
    _jspx_th_fmt_005fmessage_005f2.setPageContext(_jspx_page_context);
    _jspx_th_fmt_005fmessage_005f2.setParent((javax.servlet.jsp.tagext.Tag) _jspx_th_c_005fwhen_005f0);
    // /survey/jsp/surveyUpdate.jsp(292,6) name = key type = null reqTime = true required = false fragment = false deferredValue = false expectedTypeName = null deferredMethod = false methodSignature = null
    _jspx_th_fmt_005fmessage_005f2.setKey("survey.update.header.succeed");
    int _jspx_eval_fmt_005fmessage_005f2 = _jspx_th_fmt_005fmessage_005f2.doStartTag();
    if (_jspx_th_fmt_005fmessage_005f2.doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE) {
      return true;
    }
    org.apache.jasper.runtime.JspRuntimeLibrary.releaseTag(_jspx_th_fmt_005fmessage_005f2, _jsp_getInstanceManager());
    return false;
  }
}
