/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.components.datawarning.DataWarningException;
import org.silverpeas.components.datawarning.model.DataWarning;
import org.silverpeas.components.datawarning.model.DataWarningGroup;
import org.silverpeas.components.datawarning.model.DataWarningQuery;
import org.silverpeas.components.datawarning.model.DataWarningScheduler;
import org.silverpeas.components.datawarning.model.DataWarningUser;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.BeanCriteria;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasEntityBean;
import org.silverpeas.kernel.logging.SilverLogger;

public class DataWarningDataManager {
    private static final String INSTANCE_ID = "instanceId";
    private final SilverpeasBeanDAO<DataWarning> dataWarningDAO;
    private final SilverpeasBeanDAO<DataWarningGroup> dataWarningGroupDAO;
    private final SilverpeasBeanDAO<DataWarningUser> dataWarningUserDAO;
    private final SilverpeasBeanDAO<DataWarningQuery> dataWarningQueryDAO;
    private final SilverpeasBeanDAO<DataWarningScheduler> dataWarningSchedulerDAO;

    public DataWarningDataManager() throws DataWarningException {
        try {
            this.dataWarningDAO = SilverpeasBeanDAOFactory.getDAO(DataWarning.class);
            this.dataWarningGroupDAO = SilverpeasBeanDAOFactory.getDAO(DataWarningGroup.class);
            this.dataWarningUserDAO = SilverpeasBeanDAOFactory.getDAO(DataWarningUser.class);
            this.dataWarningQueryDAO = SilverpeasBeanDAOFactory.getDAO(DataWarningQuery.class);
            this.dataWarningSchedulerDAO = SilverpeasBeanDAOFactory.getDAO(DataWarningScheduler.class);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void createDataWarning(DataWarning dw) throws DataWarningException {
        try {
            this.dataWarningDAO.add((SilverpeasEntityBean)dw);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void deleteDataWarning(String instanceId) throws DataWarningException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId);
            this.dataWarningDAO.removeBy(criteria);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void updateDataWarning(DataWarning dw) throws DataWarningException {
        try {
            DataWarning dataWarning = this.getDataWarning(dw.getInstanceId());
            if (dataWarning == null) {
                this.createDataWarning(dw);
            } else {
                this.dataWarningDAO.update((SilverpeasEntityBean)dw);
            }
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public DataWarning getDataWarning(String instanceId) throws DataWarningException {
        DataWarning bean = null;
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId);
            Collection data = this.dataWarningDAO.findBy(criteria);
            if (data != null && !data.isEmpty()) {
                Iterator it = data.iterator();
                bean = (DataWarning)((Object)it.next());
            }
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
        return bean;
    }

    public void createDataWarningQuery(DataWarningQuery dwq) throws DataWarningException {
        try {
            this.dataWarningQueryDAO.add((SilverpeasEntityBean)dwq);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void deleteDataWarningQuery(String instanceId) throws DataWarningException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId);
            this.dataWarningQueryDAO.removeBy(criteria);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void updateDataWarningQuery(DataWarningQuery dwq) throws DataWarningException {
        try {
            DataWarningQuery dataQuery = this.getDataWarningQuery(dwq.getInstanceId(), dwq.getQueryCondition());
            if (dataQuery == null) {
                this.createDataWarningQuery(dwq);
            } else {
                this.dataWarningQueryDAO.update((SilverpeasEntityBean)dwq);
            }
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public DataWarningQuery getDataWarningQuery(String instanceId, int queryCondition) throws DataWarningException {
        DataWarningQuery bean = null;
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and("queryCondition", (Object)queryCondition);
            Collection data = this.dataWarningQueryDAO.findBy(criteria);
            if (data != null && !data.isEmpty()) {
                Iterator it = data.iterator();
                bean = (DataWarningQuery)((Object)it.next());
            }
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
        return bean;
    }

    public Collection<DataWarningQuery> getDataWarningQueries(String instanceId) throws DataWarningException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId);
            return this.dataWarningQueryDAO.findBy(criteria);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void createDataWarningScheduler(DataWarningScheduler dws) throws DataWarningException {
        try {
            this.dataWarningSchedulerDAO.add((SilverpeasEntityBean)dws);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void deleteDataWarningScheduler(String instanceId) throws DataWarningException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId);
            this.dataWarningSchedulerDAO.removeBy(criteria);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void updateDataWarningScheduler(DataWarningScheduler dws) throws DataWarningException {
        try {
            DataWarningScheduler scheduler = this.getDataWarningScheduler(dws.getInstanceId());
            if (scheduler == null) {
                this.createDataWarningScheduler(dws);
            } else {
                this.dataWarningSchedulerDAO.update((SilverpeasEntityBean)dws);
            }
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public DataWarningScheduler getDataWarningScheduler(String instanceId) throws DataWarningException {
        DataWarningScheduler bean = null;
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId);
            Collection data = this.dataWarningSchedulerDAO.findBy(criteria);
            if (data != null && !data.isEmpty()) {
                Iterator it = data.iterator();
                bean = (DataWarningScheduler)((Object)it.next());
            }
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
        return bean;
    }

    public List<String> getDataWarningSchedulerInstances() throws DataWarningException {
        ArrayList<String> retour = new ArrayList<String>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rsSchedulers = null;
        try {
            con = DBUtil.openConnection();
            String sqlForSchedulers = "SELECT DISTINCT instanceId FROM SC_DataWarning_Scheduler WHERE SCHEDULERSTATE=1";
            stmt = con.createStatement();
            rsSchedulers = stmt.executeQuery(sqlForSchedulers);
            while (rsSchedulers.next()) {
                retour.add(rsSchedulers.getString(1));
            }
            this.closeAllConnection(con, stmt, rsSchedulers);
        }
        catch (Exception e) {
            try {
                throw new DataWarningException(e);
            }
            catch (Throwable throwable) {
                this.closeAllConnection(con, stmt, rsSchedulers);
                throw throwable;
            }
        }
        return retour;
    }

    public void createDataWarningGroup(DataWarningGroup dwg) throws DataWarningException {
        try {
            this.dataWarningGroupDAO.add((SilverpeasEntityBean)dwg);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void deleteDataWarningGroup(String instanceId, int groupId) throws DataWarningException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and("groupId", (Object)groupId);
            this.dataWarningGroupDAO.removeBy(criteria);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void deleteDataWarningGroups(String instanceId) throws DataWarningException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId);
            this.dataWarningGroupDAO.removeBy(criteria);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void updateDataWarningGroup(DataWarningGroup dwg) throws DataWarningException {
        try {
            this.dataWarningGroupDAO.update((SilverpeasEntityBean)dwg);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public Collection<DataWarningGroup> getDataWarningGroups(String instanceId) throws DataWarningException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId);
            return this.dataWarningGroupDAO.findBy(criteria);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public DataWarningGroup getDataWarningGroup(String instanceId, int groupId) throws DataWarningException {
        DataWarningGroup bean = null;
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and("groupId", (Object)groupId);
            Collection data = this.dataWarningGroupDAO.findBy(criteria);
            if (data != null && !data.isEmpty()) {
                Iterator it = data.iterator();
                bean = (DataWarningGroup)((Object)it.next());
            }
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
        return bean;
    }

    public void createDataWarningUser(DataWarningUser dwu) throws DataWarningException {
        try {
            this.dataWarningUserDAO.add((SilverpeasEntityBean)dwu);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void deleteDataWarningUser(String instanceId, int userId) throws DataWarningException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and("userId", (Object)userId);
            this.dataWarningUserDAO.removeBy(criteria);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void deleteDataWarningUsers(String instanceId) throws DataWarningException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId);
            this.dataWarningUserDAO.removeBy(criteria);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public void updateDataWarningUser(DataWarningUser dwu) throws DataWarningException {
        try {
            this.dataWarningUserDAO.update((SilverpeasEntityBean)dwu);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public Collection<DataWarningUser> getDataWarningUsers(String instanceId) throws DataWarningException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId);
            return this.dataWarningUserDAO.findBy(criteria);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
    }

    public DataWarningUser getDataWarningUser(String instanceId, String userId) throws DataWarningException {
        DataWarningUser bean = null;
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and("userId", (Object)Integer.parseInt(userId));
            Collection data = this.dataWarningUserDAO.findBy(criteria);
            if (data != null && !data.isEmpty()) {
                Iterator it = data.iterator();
                bean = (DataWarningUser)((Object)it.next());
            }
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
        return bean;
    }

    public void closeConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnection(Connection con, Statement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnection(Connection con, Statement st, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        finally {
            this.closeAllConnection(con, st);
        }
    }
}

