/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.guava.common.collect.Maps;

public class CacheMetadata<K> {
    private final ConcurrentMap<K, MetadataEntry> metadataMap = Maps.newConcurrentMap();
    private boolean enabled = true;

    boolean isEnabled() {
        return this.enabled;
    }

    void disable() {
        this.enabled = false;
    }

    void put(K key) {
        if (!this.enabled) {
            return;
        }
        this.getOrCreate(key, false);
    }

    void putFromPersistenceAndIncrement(K key) {
        if (!this.enabled) {
            return;
        }
        this.getOrCreate(key, true).incrementCount();
    }

    void increment(K key) {
        if (!this.enabled) {
            return;
        }
        this.getOrCreate(key, false).incrementCount();
    }

    MetadataEntry remove(Object key) {
        if (!this.enabled) {
            return null;
        }
        return (MetadataEntry)this.metadataMap.remove(key);
    }

    void putAll(Iterable<?> keys) {
        if (!this.enabled) {
            return;
        }
        for (Object k : keys) {
            this.getOrCreate(k, false);
        }
    }

    void incrementAll(Iterable<?> keys) {
        if (!this.enabled) {
            return;
        }
        for (Object k : keys) {
            this.getOrCreate(k, false).incrementCount();
        }
    }

    void removeAll(Iterable<?> keys) {
        if (!this.enabled) {
            return;
        }
        for (Object k : keys) {
            this.metadataMap.remove(k);
        }
    }

    void clear() {
        if (!this.enabled) {
            return;
        }
        this.metadataMap.clear();
    }

    private MetadataEntry getOrCreate(K key, boolean readFromPersistentCache) {
        if (!this.enabled) {
            return null;
        }
        MetadataEntry metadata = (MetadataEntry)this.metadataMap.get(key);
        if (metadata == null) {
            MetadataEntry newEntry = new MetadataEntry(readFromPersistentCache);
            MetadataEntry oldEntry = this.metadataMap.putIfAbsent(key, newEntry);
            metadata = oldEntry == null ? newEntry : oldEntry;
        }
        return metadata;
    }

    static class MetadataEntry {
        private final AtomicLong accessCount = new AtomicLong();
        private final boolean readFromPersistentCache;

        private MetadataEntry(boolean readFromPersistentCache) {
            this.readFromPersistentCache = readFromPersistentCache;
        }

        void incrementCount() {
            this.accessCount.incrementAndGet();
        }

        long getAccessCount() {
            return this.accessCount.get();
        }

        boolean isReadFromPersistentCache() {
            return this.readFromPersistentCache;
        }
    }
}

