<%--

    Copyright (C) 2000 - 2024 Silverpeas

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    As a special exception to the terms and conditions of version 3.0 of
    the GPL, you may redistribute this Program in connection with Free/Libre
    Open Source Software ("FLOSS") applications as described in Silverpeas's
    FLOSS exception.  You should have received a copy of the text describing
    the FLOSS exception, and it is also available here:
    "http://www.silverpeas.org/docs/core/legal/floss_exception.html"

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

--%>

<%@page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%
response.setHeader("Cache-Control","no-store"); //HTTP 1.1
response.setHeader("Pragma","no-cache"); //HTTP 1.0
response.setDateHeader ("Expires",-1); //prevents caching at the proxy server
%>

<%@ page import="java.util.Collection"%>
<%@ page import="java.util.Date"%>
<%@ page import="java.util.Iterator"%>
<%@ page import="java.util.List"%>
<%@ page import="java.util.Map"%>
<%@ page import="java.util.HashMap"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.lang.Math"%>
<%@ page import="java.net.URLEncoder"%>
<%@ page import="java.text.ParseException"%>

<%@ page import="org.silverpeas.core.util.WebEncodeHelper"%>
<%@ page import="org.silverpeas.core.ResourceReference"%>
<%@ page import="org.silverpeas.kernel.util.StringUtil"%>

<%@ page import="org.silverpeas.core.util.MultiSilverpeasBundle"%>
<%@ page import="org.silverpeas.core.util.URLUtil"%>

<%@ page import="org.silverpeas.core.admin.user.model.SilverpeasRole"%>
<%@ page import="org.silverpeas.core.admin.user.model.UserDetail"%>
<%@ page import="org.silverpeas.components.survey.control.SurveySessionController "%>
<%@ page import="org.silverpeas.components.survey.SurveyException"%>

<%@ page import="org.silverpeas.kernel.bundle.ResourceLocator"%>
<%@ page import="org.silverpeas.kernel.bundle.LocalizationBundle"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory "%>
<%@ page import="org.silverpeas.core.util.DateUtil"%>
<%@ page import="org.silverpeas.core.persistence.jdbc.DBUtil"%>
<%@ page import="org.silverpeas.core.questioncontainer.question.model.Question "%>
<%@ page import="org.silverpeas.core.questioncontainer.result.model.QuestionResult "%>
<%@ page import="org.silverpeas.core.questioncontainer.answer.model.Answer "%>

<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPane"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayLine"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayColumn"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellText"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.board.Board"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBar"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.buttonpanes.ButtonPane"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.buttons.Button"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.iconpanes.IconPane"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.icons.Icon"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.tabs.TabbedPane"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.operationpanes.OperationPane"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.window.Window"%>
<%@ page import="org.silverpeas.core.web.util.viewgenerator.html.frame.Frame"%>

<%@ page import="org.silverpeas.core.questioncontainer.container.model.Comment"%>
<%@ page import="org.silverpeas.core.questioncontainer.container.model.QuestionContainerHeader "%>
<%@ page import="org.silverpeas.core.questioncontainer.container.model.QuestionContainerDetail "%>

<%@ page import="org.silverpeas.core.util.file.FileRepositoryManager"%>
<%@ page import="org.silverpeas.core.util.file.FileServerUtils"%>
<%@ page import="org.silverpeas.core.admin.component.model.ComponentInstLight"%>

<%@ page import="org.silverpeas.core.util.file.FileUploadUtil"%>

<%@ page import="org.silverpeas.core.contribution.attachment.model.SimpleDocument"%>
<%@ page import="org.apache.commons.fileupload.FileItem"%>

<%@ page errorPage="../../admin/jsp/errorpageMain.jsp"%>

<%
  SurveySessionController surveyScc = (SurveySessionController) request.getAttribute("survey");
  GraphicElementFactory gef = (GraphicElementFactory) session.getAttribute("SessionGraphicElementFactory");
  MultiSilverpeasBundle resources = (MultiSilverpeasBundle)request.getAttribute("resources");

  if (surveyScc == null) {
      // No session controller in the request -> security exception
      String sessionTimeout = ResourceLocator.getGeneralSettingBundle().getString("sessionTimeout");
      getServletConfig().getServletContext().getRequestDispatcher(sessionTimeout).forward(request, response);
      return;
  }

  LocalizationBundle generalMessage = ResourceLocator.getGeneralLocalizationBundle(
      surveyScc.getLanguage());

  String[] browseContext = (String[]) request.getAttribute("browseContext");
  String spaceLabel 		= browseContext[0];
  String componentLabel 	= browseContext[1];
  String spaceId 			= browseContext[2];
  String componentId 		= browseContext[3];

  boolean pollingStationMode = (componentId != null && componentId.startsWith("pollingStation"));
%>
