/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.util.Collection;
import org.silverpeas.components.kmelia.service.AbstractKmeliaSimulationElementLister;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.attachment.process.AttachmentSimulationElementLister;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.io.media.image.thumbnail.control.ThumbnailSimulationElement;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.process.annotation.SimulationElement;
import org.silverpeas.core.process.annotation.SimulationElementLister;

public class KmeliaPublicationSimulationElementLister
extends AbstractKmeliaSimulationElementLister {
    public KmeliaPublicationSimulationElementLister() {
    }

    public KmeliaPublicationSimulationElementLister(SimulationElementLister parentElementLister) {
        super(parentElementLister);
    }

    public void listElements(ResourceReference sourcePK, String language) {
        if (sourcePK instanceof NodePK) {
            this.listPublicationDocumentsFromNode((NodePK)sourcePK, language);
        } else if (sourcePK instanceof PublicationPK) {
            this.listPublicationDocumentsFromPublication(this.getPublicationService().getDetail((PublicationPK)sourcePK), language);
        } else {
            throw new IllegalArgumentException("The reference " + sourcePK.getClass().getSimpleName() + " isn't taken in charge");
        }
    }

    private void listPublicationDocumentsFromNode(NodePK nodePK, String language) {
        Collection publications = this.getPublicationService().getDetailsByFatherPK(nodePK);
        for (PublicationDetail publication : publications) {
            this.listPublicationDocumentsFromPublication(publication, language);
        }
    }

    private void listPublicationDocumentsFromPublication(PublicationDetail publication, String language) {
        this.addElement((SimulationElement)new ThumbnailSimulationElement(publication.getThumbnail()));
        new AttachmentSimulationElementLister((SimulationElementLister)this).listElements(publication.getPK().toResourceReference(), language);
    }
}

