/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesResponse;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyReferencesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetReferencesRequestHandler
extends SimpleChannelInboundHandler<GetReferencesRequest> {
    private static final Logger log = LoggerFactory.getLogger(GetReferencesRequestHandler.class);
    private final StandbyReferencesReader reader;

    public GetReferencesRequestHandler(StandbyReferencesReader reader) {
        this.reader = reader;
    }

    protected void channelRead0(ChannelHandlerContext ctx, GetReferencesRequest msg) throws Exception {
        log.debug("Reading references of segment {} for client {}", (Object)msg.getSegmentId(), (Object)msg.getClientId());
        Iterable<String> references = this.reader.readReferences(msg.getSegmentId());
        if (references == null) {
            log.debug("References for segment {} not found, discarding request from client {}", (Object)msg.getSegmentId(), (Object)msg.getClientId());
            return;
        }
        ctx.writeAndFlush((Object)new GetReferencesResponse(msg.getClientId(), msg.getSegmentId(), references));
    }
}

