/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.internal;

import java.io.Closeable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.security.authorization.restriction.WhiteboardRestrictionProvider;
import org.apache.jackrabbit.oak.security.internal.Preconditions;
import org.apache.jackrabbit.oak.security.internal.SecurityProviderBuilder;
import org.apache.jackrabbit.oak.security.user.UserConfigurationImpl;
import org.apache.jackrabbit.oak.security.user.whiteboard.WhiteboardAuthorizableActionProvider;
import org.apache.jackrabbit.oak.security.user.whiteboard.WhiteboardAuthorizableNodeName;
import org.apache.jackrabbit.oak.security.user.whiteboard.WhiteboardUserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginModuleMBean;
import org.apache.jackrabbit.oak.spi.security.authentication.token.CompositeTokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregationFilter;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.principal.CompositePrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableNodeName;
import org.apache.jackrabbit.oak.spi.security.user.UserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.Monitor;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Designate(ocd=Configuration.class)
public class SecurityProviderRegistration {
    private static final Logger log = LoggerFactory.getLogger(SecurityProviderRegistration.class);
    private AuthenticationConfiguration authenticationConfiguration;
    private PrivilegeConfiguration privilegeConfiguration;
    private UserConfiguration userConfiguration;
    private BundleContext context;
    private ServiceRegistration registration;
    private boolean registering;
    private final Preconditions preconditions = new Preconditions();
    private final CompositeAuthorizationConfiguration authorizationConfiguration = new CompositeAuthorizationConfiguration();
    private final CompositePrincipalConfiguration principalConfiguration = new CompositePrincipalConfiguration();
    private final CompositeTokenConfiguration tokenConfiguration = new CompositeTokenConfiguration();
    private final SortedMap<ServiceReference, AuthorizableNodeName> authorizableNodeNames = Collections.synchronizedSortedMap(new TreeMap());
    private final SortedMap<ServiceReference, AuthorizableActionProvider> authorizableActionProviders = Collections.synchronizedSortedMap(new TreeMap());
    private final SortedMap<ServiceReference, RestrictionProvider> restrictionProviders = Collections.synchronizedSortedMap(new TreeMap());
    private final SortedMap<ServiceReference, UserAuthenticationFactory> userAuthenticationFactories = Collections.synchronizedSortedMap(new TreeMap());
    private final SortedMap<ServiceReference, AggregationFilter> aggregationFilters = Collections.synchronizedSortedMap(new TreeMap());
    private RootProvider rootProvider;
    private TreeProvider treeProvider;
    @Reference
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    private Closer closer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate(BundleContext context, Configuration configuration) {
        String[] requiredServicePids = configuration.requiredServicePids();
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            for (String pid : requiredServicePids) {
                this.preconditions.addPrecondition(pid);
            }
            this.context = context;
        }
        this.authorizationConfiguration.withCompositionType(configuration.authorizationCompositionType());
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    public void modified(Configuration configuration) {
        String[] requiredServicePids = configuration.requiredServicePids();
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.preconditions.clearPreconditions();
            for (String pid : requiredServicePids) {
                this.preconditions.addPrecondition(pid);
            }
        }
        this.authorizationConfiguration.withCompositionType(configuration.authorizationCompositionType());
        this.maybeUnregister();
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate() {
        ServiceRegistration registration;
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            registration = this.registration;
            this.registration = null;
            this.registering = false;
            this.context = null;
            this.preconditions.clearPreconditions();
        }
        if (registration != null) {
            registration.unregister();
        }
        IOUtils.closeQuietly((Closeable)this.closer);
    }

    @Reference(name="authenticationConfiguration")
    public void bindAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    public void unbindAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = null;
    }

    @Reference(name="privilegeConfiguration")
    public void bindPrivilegeConfiguration(PrivilegeConfiguration privilegeConfiguration) {
        this.privilegeConfiguration = privilegeConfiguration;
    }

    public void unbindPrivilegeConfiguration(PrivilegeConfiguration privilegeConfiguration) {
        this.privilegeConfiguration = null;
    }

    @Reference(name="userConfiguration")
    public void bindUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
    }

    public void unbindUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = null;
    }

    @Reference(name="rootProvider")
    public void bindRootProvider(RootProvider rootProvider) {
        this.rootProvider = rootProvider;
    }

    public void unbindRootProvider(RootProvider rootProvider) {
        this.rootProvider = null;
    }

    @Reference(name="treeProvider")
    public void bindTreeProvider(TreeProvider treeProvider) {
        this.treeProvider = treeProvider;
    }

    public void unbindTreeProvider(TreeProvider treeProvider) {
        this.treeProvider = null;
    }

    @Reference(name="authorizationConfiguration", service=AuthorizationConfiguration.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindAuthorizationConfiguration(AuthorizationConfiguration configuration, Map<String, Object> properties) {
        this.bindConfiguration(this.authorizationConfiguration, configuration, properties);
    }

    public void unbindAuthorizationConfiguration(AuthorizationConfiguration configuration, Map<String, Object> properties) {
        this.unbindConfiguration(this.authorizationConfiguration, configuration, properties);
    }

    @Reference(name="principalConfiguration", service=PrincipalConfiguration.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindPrincipalConfiguration(PrincipalConfiguration configuration, Map<String, Object> properties) {
        this.bindConfiguration((CompositeConfiguration)this.principalConfiguration, (SecurityConfiguration)configuration, properties);
    }

    public void unbindPrincipalConfiguration(PrincipalConfiguration configuration, Map<String, Object> properties) {
        this.unbindConfiguration((CompositeConfiguration)this.principalConfiguration, (SecurityConfiguration)configuration, properties);
    }

    @Reference(name="tokenConfiguration", service=TokenConfiguration.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindTokenConfiguration(TokenConfiguration configuration, Map<String, Object> properties) {
        this.bindConfiguration((CompositeConfiguration)this.tokenConfiguration, (SecurityConfiguration)configuration, properties);
    }

    public void unbindTokenConfiguration(TokenConfiguration configuration, Map<String, Object> properties) {
        this.unbindConfiguration((CompositeConfiguration)this.tokenConfiguration, (SecurityConfiguration)configuration, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends SecurityConfiguration> void bindConfiguration(@NotNull CompositeConfiguration<T> composite, @NotNull T configuration, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            composite.addConfiguration(configuration, ConfigurationParameters.of(properties));
            this.addCandidate(properties);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends SecurityConfiguration> void unbindConfiguration(@NotNull CompositeConfiguration<T> composite, @NotNull T configuration, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            composite.removeConfiguration(configuration);
            this.removeCandidate(properties);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="authorizableNodeName", service=AuthorizableNodeName.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindAuthorizableNodeName(@NotNull ServiceReference serviceReference, @NotNull AuthorizableNodeName authorizableNodeName) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableNodeNames.put(serviceReference, authorizableNodeName);
            this.addCandidate(serviceReference);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAuthorizableNodeName(@NotNull ServiceReference serviceReference, @NotNull AuthorizableNodeName authorizableNodeName) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableNodeNames.remove(serviceReference);
            this.removeCandidate(serviceReference);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="authorizableActionProvider", service=AuthorizableActionProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindAuthorizableActionProvider(@NotNull ServiceReference serviceReference, @NotNull AuthorizableActionProvider authorizableActionProvider) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableActionProviders.put(serviceReference, authorizableActionProvider);
            this.addCandidate(serviceReference);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAuthorizableActionProvider(@NotNull ServiceReference serviceReference, @NotNull AuthorizableActionProvider authorizableActionProvider) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableActionProviders.remove(serviceReference);
            this.removeCandidate(serviceReference);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="restrictionProvider", service=RestrictionProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindRestrictionProvider(@NotNull ServiceReference serviceReference, @NotNull RestrictionProvider restrictionProvider) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.restrictionProviders.put(serviceReference, restrictionProvider);
            this.addCandidate(serviceReference);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindRestrictionProvider(@NotNull ServiceReference serviceReference, @NotNull RestrictionProvider restrictionProvider) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.restrictionProviders.remove(serviceReference);
            this.removeCandidate(serviceReference);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="userAuthenticationFactory", service=UserAuthenticationFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindUserAuthenticationFactory(@NotNull ServiceReference serviceReference, @NotNull UserAuthenticationFactory userAuthenticationFactory) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.userAuthenticationFactories.put(serviceReference, userAuthenticationFactory);
            this.addCandidate(serviceReference);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindUserAuthenticationFactory(@NotNull ServiceReference serviceReference, @NotNull UserAuthenticationFactory userAuthenticationFactory) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.userAuthenticationFactories.remove(serviceReference);
            this.removeCandidate(serviceReference);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="aggregationFilters", service=AggregationFilter.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindAggregationFilter(@NotNull ServiceReference serviceReference, @NotNull AggregationFilter aggregationFilter) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.aggregationFilters.put(serviceReference, aggregationFilter);
            this.addCandidate(serviceReference);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAggregationFilter(@NotNull ServiceReference serviceReference, @NotNull AggregationFilter aggregationFilter) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.aggregationFilters.remove(serviceReference);
            this.removeCandidate(serviceReference);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeRegister() {
        BundleContext context;
        log.info("Trying to register a SecurityProvider...");
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            if (this.context == null) {
                log.info("Aborting: no BundleContext is available");
                return;
            }
            if (!this.preconditions.areSatisfied()) {
                log.info("Aborting: preconditions are not satisfied: {}", (Object)this.preconditions);
                return;
            }
            if (this.registration != null) {
                log.info("Aborting: a SecurityProvider is already registered");
                return;
            }
            if (this.registering) {
                log.info("Aborting: a SecurityProvider is already being registered");
                return;
            }
            this.registering = true;
            context = this.context;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("type", "default");
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(context);
        SecurityProvider securityProvider = this.createSecurityProvider((Whiteboard)whiteboard);
        ServiceRegistration registration = context.registerService(SecurityProvider.class.getName(), (Object)securityProvider, properties);
        SecurityProviderRegistration securityProviderRegistration2 = this;
        synchronized (securityProviderRegistration2) {
            this.registration = registration;
            this.registering = false;
        }
        this.closer = Closer.create();
        Iterable monitors = Iterables.transform((Iterable)securityProvider.getConfigurations(), sc -> sc.getMonitors(this.statisticsProvider));
        for (Monitor monitor : Iterables.concat((Iterable)monitors)) {
            Registration reg = whiteboard.register(monitor.getMonitorClass(), (Object)monitor, monitor.getMonitorProperties());
            this.closer.register(() -> ((Registration)reg).unregister());
            if (!(monitor instanceof LoginModuleMBean)) continue;
            Registration mbean = WhiteboardUtils.registerMBean((Whiteboard)whiteboard, LoginModuleMBean.class, (Object)((LoginModuleMBean)monitor), (String)"LoginModuleStats", (String)"LoginModule statistics");
            this.closer.register(() -> ((Registration)mbean).unregister());
        }
        log.info("SecurityProvider instance registered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeUnregister() {
        ServiceRegistration registration;
        log.info("Trying to unregister the SecurityProvider...");
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            if (this.registration == null) {
                log.info("Aborting: no SecurityProvider is registered");
                return;
            }
            if (this.preconditions.areSatisfied()) {
                log.info("Aborting: preconditions are satisfied");
                return;
            }
            registration = this.registration;
            this.registration = null;
        }
        registration.unregister();
        IOUtils.closeQuietly((Closeable)this.closer);
        log.info("SecurityProvider instance unregistered");
    }

    private SecurityProvider createSecurityProvider(@NotNull Whiteboard whiteboard) {
        ConfigurationParameters userParams = ConfigurationParameters.of((ConfigurationParameters[])new ConfigurationParameters[]{ConfigurationParameters.of((String)"authorizableActionProvider", (Object)this.createWhiteboardAuthorizableActionProvider()), ConfigurationParameters.of((String)"authorizableNodeName", (Object)this.createWhiteboardAuthorizableNodeName()), ConfigurationParameters.of((String)"userAuthenticationFactory", (Object)this.createWhiteboardUserAuthenticationFactory())});
        ConfigurationParameters authorizationParams = ConfigurationParameters.of((String)"restrictionProvider", (Object)this.createWhiteboardRestrictionProvider());
        this.authorizationConfiguration.withAggregationFilter(this.createAggregationFilter());
        return SecurityProviderBuilder.newBuilder().withRootProvider(this.rootProvider).withTreeProvider(this.treeProvider).with(this.authenticationConfiguration, ConfigurationParameters.EMPTY, this.privilegeConfiguration, ConfigurationParameters.EMPTY, this.userConfiguration, userParams, this.authorizationConfiguration, authorizationParams, (PrincipalConfiguration)this.principalConfiguration, ConfigurationParameters.EMPTY, (TokenConfiguration)this.tokenConfiguration, ConfigurationParameters.EMPTY).withWhiteboard(whiteboard).build();
    }

    private RestrictionProvider createWhiteboardRestrictionProvider() {
        return new WhiteboardRestrictionProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<RestrictionProvider> getServices() {
                Collection<RestrictionProvider> values = SecurityProviderRegistration.this.restrictionProviders.values();
                SortedMap<ServiceReference, RestrictionProvider> sortedMap = SecurityProviderRegistration.this.restrictionProviders;
                synchronized (sortedMap) {
                    return Lists.newArrayList(values);
                }
            }
        };
    }

    private AuthorizableActionProvider createWhiteboardAuthorizableActionProvider() {
        return new WhiteboardAuthorizableActionProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<AuthorizableActionProvider> getServices() {
                Collection<AuthorizableActionProvider> values = SecurityProviderRegistration.this.authorizableActionProviders.values();
                SortedMap<ServiceReference, AuthorizableActionProvider> sortedMap = SecurityProviderRegistration.this.authorizableActionProviders;
                synchronized (sortedMap) {
                    return Lists.newArrayList(values);
                }
            }
        };
    }

    private AuthorizableNodeName createWhiteboardAuthorizableNodeName() {
        return new WhiteboardAuthorizableNodeName(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<AuthorizableNodeName> getServices() {
                Collection<AuthorizableNodeName> values = SecurityProviderRegistration.this.authorizableNodeNames.values();
                SortedMap<ServiceReference, AuthorizableNodeName> sortedMap = SecurityProviderRegistration.this.authorizableNodeNames;
                synchronized (sortedMap) {
                    return Lists.newArrayList(values);
                }
            }
        };
    }

    private UserAuthenticationFactory createWhiteboardUserAuthenticationFactory() {
        return new WhiteboardUserAuthenticationFactory(UserConfigurationImpl.getDefaultAuthenticationFactory()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<UserAuthenticationFactory> getServices() {
                Collection<UserAuthenticationFactory> values = SecurityProviderRegistration.this.userAuthenticationFactories.values();
                SortedMap<ServiceReference, UserAuthenticationFactory> sortedMap = SecurityProviderRegistration.this.userAuthenticationFactories;
                synchronized (sortedMap) {
                    return Lists.newArrayList(values);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AggregationFilter createAggregationFilter() {
        ArrayList filters;
        SortedMap<ServiceReference, AggregationFilter> sortedMap = this.aggregationFilters;
        synchronized (sortedMap) {
            filters = Lists.newArrayList(this.aggregationFilters.values());
        }
        switch (filters.size()) {
            case 0: {
                return AggregationFilter.DEFAULT;
            }
            case 1: {
                return (AggregationFilter)filters.get(0);
            }
        }
        return new AggregationFilter(){

            public boolean stop(@NotNull AggregatedPermissionProvider permissionProvider, @NotNull Set<Principal> principals) {
                for (AggregationFilter f : filters) {
                    if (!f.stop(permissionProvider, principals)) continue;
                    return true;
                }
                return false;
            }

            public boolean stop(@NotNull JackrabbitAccessControlManager accessControlManager, @NotNull Set<Principal> principals) {
                for (AggregationFilter f : filters) {
                    if (!f.stop(accessControlManager, principals)) continue;
                    return true;
                }
                return false;
            }

            public boolean stop(@NotNull AccessControlManager accessControlManager, @Nullable String absPath) {
                for (AggregationFilter f : filters) {
                    if (!f.stop(accessControlManager, absPath)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private void addCandidate(Map<String, Object> properties) {
        String pidOrName = SecurityProviderRegistration.getServicePidOrComponentName(properties);
        if (pidOrName == null) {
            return;
        }
        this.preconditions.addCandidate(pidOrName);
    }

    private void addCandidate(@NotNull ServiceReference serviceReference) {
        String pidOrName = SecurityProviderRegistration.getServicePidOrComponentName(serviceReference);
        if (pidOrName == null) {
            return;
        }
        this.preconditions.addCandidate(pidOrName);
    }

    private void removeCandidate(Map<String, Object> properties) {
        String pidOrName = SecurityProviderRegistration.getServicePidOrComponentName(properties);
        if (pidOrName == null) {
            return;
        }
        this.preconditions.removeCandidate(pidOrName);
    }

    private void removeCandidate(@NotNull ServiceReference serviceReference) {
        String pidOrName = SecurityProviderRegistration.getServicePidOrComponentName(serviceReference);
        if (pidOrName == null) {
            return;
        }
        this.preconditions.removeCandidate(pidOrName);
    }

    private static String getServicePidOrComponentName(Map<String, Object> properties) {
        String servicePid = PropertiesUtil.toString((Object)properties.get("service.pid"), null);
        if (servicePid != null) {
            return servicePid;
        }
        return PropertiesUtil.toString((Object)properties.get("oak.security.name"), null);
    }

    private static String getServicePidOrComponentName(@NotNull ServiceReference serviceReference) {
        String servicePid = PropertiesUtil.toString((Object)serviceReference.getProperty("service.pid"), null);
        if (servicePid != null) {
            return servicePid;
        }
        return PropertiesUtil.toString((Object)serviceReference.getProperty("oak.security.name"), null);
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak SecurityProvider", description="The default SecurityProvider embedded in Apache Jackrabbit Oak")
    static @interface Configuration {
        @AttributeDefinition(name="Required Services", description="The SecurityProvider will not register itself unless the services identified by the following service pids or the oak.security.name properties are registered first. The class name is identified by checking the service.pid property. If that property does not exist, the oak.security.name property is used as a fallback.Only implementations of the following interfaces are checked :AuthorizationConfiguration, PrincipalConfiguration, TokenConfiguration, AuthorizableActionProvider, RestrictionProvider and UserAuthenticationFactory.")
        public String[] requiredServicePids() default {"org.apache.jackrabbit.oak.security.authorization.AuthorizationConfigurationImpl", "org.apache.jackrabbit.oak.security.principal.PrincipalConfigurationImpl", "org.apache.jackrabbit.oak.security.authentication.token.TokenConfigurationImpl", "org.apache.jackrabbit.oak.spi.security.user.action.DefaultAuthorizableActionProvider", "org.apache.jackrabbit.oak.security.authorization.restriction.RestrictionProviderImpl", "org.apache.jackrabbit.oak.security.user.UserAuthenticationFactoryImpl"};

        @AttributeDefinition(name="Authorization Composition Type", description="The Composite Authorization model uses this flag to determine what type of logic to apply to the existing providers (default value is AND).", options={@Option(label="AND", value="AND"), @Option(label="OR", value="OR")})
        public String authorizationCompositionType() default "AND";
    }
}

