/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NodeTypeRegistry;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.nodetype.NodeTypeConstants;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;

public class InitialContent
implements RepositoryInitializer,
NodeTypeConstants {
    private boolean prePopulateVS = false;

    public void initialize(@NotNull NodeBuilder builder) {
        builder.setProperty("jcr:primaryType", (Object)"rep:root", Type.NAME);
        if (!builder.hasChildNode("jcr:system")) {
            NodeBuilder system = builder.child("jcr:system");
            system.setProperty("jcr:primaryType", (Object)"rep:system", Type.NAME);
            system.child("jcr:versionStorage").setProperty("jcr:primaryType", (Object)"rep:versionStorage", Type.NAME);
            system.child("jcr:nodeTypes").setProperty("jcr:primaryType", (Object)"rep:nodeTypes", Type.NAME);
            system.child("jcr:activities").setProperty("jcr:primaryType", (Object)"rep:Activities", Type.NAME);
            Namespaces.setupNamespaces(system);
        }
        NodeBuilder versionStorage = builder.child("jcr:system").child("jcr:versionStorage");
        if (this.prePopulateVS && !InitialContent.isInitialized(versionStorage)) {
            InitialContent.createIntermediateNodes(versionStorage);
        }
        if (!builder.hasChildNode("oak:index")) {
            NodeBuilder index = IndexUtils.getOrCreateOakIndex(builder);
            NodeBuilder uuid = IndexUtils.createIndexDefinition(index, "uuid", true, true, (Collection<String>)ImmutableList.of((Object)"jcr:uuid"), null);
            uuid.setProperty("info", (Object)"Oak index for UUID lookup (direct lookup of nodes with the mixin 'mix:referenceable').");
            NodeBuilder nodetype = IndexUtils.createIndexDefinition(index, "nodetype", true, false, (Collection<String>)ImmutableList.of((Object)"jcr:primaryType", (Object)"jcr:mixinTypes"), null);
            nodetype.setProperty("info", (Object)"Oak index for queries with node type, and possibly path restrictions, for example \"/jcr:root/content//element(*, mix:language)\".");
            IndexUtils.createReferenceIndex(index);
            index.child("counter").setProperty("jcr:primaryType", (Object)"oak:QueryIndexDefinition", Type.NAME).setProperty("type", (Object)"counter").setProperty("async", (Object)"async").setProperty("info", (Object)"Oak index that allows to estimate how many nodes are stored below a given path, to decide whether traversing or using an index is faster.");
        }
        NodeState base = ModifiedNodeState.squeeze((NodeState)builder.getNodeState());
        MemoryNodeStore store = new MemoryNodeStore(base);
        InitialContent.registerBuiltIn(RootFactory.createSystemRoot((NodeStore)store, null, null, null, null));
        NodeState target = store.getRoot();
        target.compareAgainstBaseState(base, (NodeStateDiff)new ApplyDiff(builder));
    }

    public InitialContent withPrePopulatedVersionStore() {
        this.prePopulateVS = true;
        return this;
    }

    private static boolean isInitialized(NodeBuilder versionStorage) {
        PropertyState init = versionStorage.getProperty(":initialized");
        return init != null && (Long)init.getValue(Type.LONG) > 0L;
    }

    private static void createIntermediateNodes(NodeBuilder versionStorage) {
        String fmt = "%02x";
        versionStorage.setProperty(":initialized", (Object)1);
        for (int i = 0; i < 255; ++i) {
            NodeBuilder c = InitialContent.storageChild(versionStorage, String.format(fmt, i));
            for (int j = 0; j < 255; ++j) {
                InitialContent.storageChild(c, String.format(fmt, j));
            }
        }
    }

    private static NodeBuilder storageChild(NodeBuilder node, String name) {
        NodeBuilder c = node.child(name);
        if (!c.hasProperty("jcr:primaryType")) {
            c.setProperty("jcr:primaryType", (Object)"rep:versionStorage", Type.NAME);
        }
        return c;
    }

    private static void registerBuiltIn(Root root) {
        try (InputStream stream = InitialContent.class.getResourceAsStream("builtin_nodetypes.cnd");){
            NodeTypeRegistry.register(root, stream, "built-in node types");
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read built-in node types", e);
        }
    }
}

