/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.service;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.gallery.GalleryComponentSettings;
import org.silverpeas.components.gallery.GalleryContentManager;
import org.silverpeas.components.gallery.Watermark;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.components.gallery.dao.MediaDAO;
import org.silverpeas.components.gallery.dao.OrderDAO;
import org.silverpeas.components.gallery.dao.PhotoDAO;
import org.silverpeas.components.gallery.delegate.GalleryPasteDelegate;
import org.silverpeas.components.gallery.delegate.MediaDataCreateDelegate;
import org.silverpeas.components.gallery.delegate.MediaDataUpdateDelegate;
import org.silverpeas.components.gallery.model.AlbumDetail;
import org.silverpeas.components.gallery.model.GalleryRuntimeException;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaCriteria;
import org.silverpeas.components.gallery.model.MediaOrderCriteria;
import org.silverpeas.components.gallery.model.MediaPK;
import org.silverpeas.components.gallery.model.Order;
import org.silverpeas.components.gallery.model.OrderRow;
import org.silverpeas.components.gallery.model.Photo;
import org.silverpeas.components.gallery.process.GalleryProcessManagement;
import org.silverpeas.components.gallery.service.GalleryService;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.date.period.Period;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.node.dao.NodeDAO;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.search.SearchService;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.SettingBundle;

@Service
@Named(value="galleryService")
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultGalleryService
implements GalleryService {
    @Inject
    private NodeService nodeService;
    @Inject
    private GalleryContentManager galleryContentManager;
    @Inject
    private NodeDAO nodeDAO;

    @Override
    public Optional<Media> getContributionById(ContributionIdentifier contributionId) {
        return Optional.ofNullable(this.getMedia(new MediaPK(contributionId.getLocalId(), contributionId.getComponentInstanceId())));
    }

    public SettingBundle getComponentSettings() {
        return GalleryComponentSettings.getSettings();
    }

    public LocalizationBundle getComponentMessages(String language) {
        return GalleryComponentSettings.getMessagesIn(language);
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith("gallery");
    }

    @Override
    public AlbumDetail getAlbum(NodePK nodePK) {
        return this.getAlbum(nodePK, MediaCriteria.VISIBILITY.BY_DEFAULT);
    }

    @Override
    public AlbumDetail getAlbum(NodePK nodePK, MediaCriteria.VISIBILITY visibility) {
        try {
            return new AlbumDetail(this.nodeService.getDetail(nodePK), visibility);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public Collection<AlbumDetail> getAllAlbums(String instanceId) {
        try {
            NodePK nodePK = new NodePK("0", instanceId);
            List nodes = this.nodeService.getSubTree(nodePK);
            ArrayList<AlbumDetail> albums = new ArrayList<AlbumDetail>(nodes.size());
            for (NodeDetail node : nodes) {
                albums.add(new AlbumDetail(node));
            }
            return albums;
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public AlbumDetail createAlbum(AlbumDetail album, NodePK nodePK) {
        try {
            AlbumDetail currentAlbum = this.getAlbum(nodePK);
            NodeDetail node = this.nodeService.createNode((NodeDetail)album, (NodeDetail)currentAlbum);
            return new AlbumDetail(node);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void updateAlbum(AlbumDetail album) {
        try {
            this.nodeService.setDetail((NodeDetail)album);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteAlbum(UserDetail user, String componentInstanceId, NodePK nodePK) {
        try {
            GalleryProcessManagement processManagement = new GalleryProcessManagement(user, componentInstanceId);
            processManagement.addDeleteAlbumProcesses(nodePK);
            processManagement.execute();
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public Photo getPhoto(MediaPK mediaPK) {
        try {
            return PhotoDAO.getPhoto(mediaPK.getId());
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public Media getMedia(MediaPK mediaPK) {
        return this.getMedia(mediaPK, MediaCriteria.VISIBILITY.BY_DEFAULT);
    }

    @Override
    public Media getMedia(MediaPK mediaPK, MediaCriteria.VISIBILITY visibility) {
        try {
            return MediaDAO.getByCriteria(MediaCriteria.fromComponentInstanceId(mediaPK.getInstanceId()).identifierIsOneOf(mediaPK.getId()).withVisibility(visibility));
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public List<Media> getMedia(List<String> mediaIds, String componentInstanceId) {
        return this.getMedia(mediaIds, componentInstanceId, MediaCriteria.VISIBILITY.BY_DEFAULT);
    }

    @Override
    public List<Media> getMedia(List<String> mediaIds, String componentInstanceId, MediaCriteria.VISIBILITY visibility) {
        try {
            return MediaDAO.findByCriteria(MediaCriteria.fromComponentInstanceId(componentInstanceId).identifierIsOneOf(mediaIds.toArray(new String[0])).withVisibility(visibility));
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public Collection<Media> getAllMedia(String instanceId, MediaCriteria.VISIBILITY visibility) {
        try {
            return MediaDAO.findByCriteria(MediaCriteria.fromComponentInstanceId(instanceId).withVisibility(visibility));
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public Collection<Media> getAllMedia(NodePK nodePK, MediaCriteria.VISIBILITY visibility) {
        try {
            String albumId = nodePK.getId();
            String instanceId = nodePK.getInstanceId();
            return MediaDAO.findByCriteria(MediaCriteria.fromComponentInstanceId(instanceId).albumIdentifierIsOneOf(albumId).withVisibility(visibility));
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public long countAllMedia(NodePK nodePK) {
        return this.countAllMedia(nodePK, MediaCriteria.VISIBILITY.BY_DEFAULT);
    }

    @Override
    public long countAllMedia(NodePK nodePK, MediaCriteria.VISIBILITY visibility) {
        try {
            String albumId = nodePK.getId();
            String instanceId = nodePK.getInstanceId();
            return MediaDAO.countByCriteria(MediaCriteria.fromComponentInstanceId(instanceId).albumIdentifierIsOneOf(albumId).withVisibility(visibility));
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public Collection<Photo> getAllPhotos(NodePK nodePK) {
        return this.getAllPhotos(nodePK, MediaCriteria.VISIBILITY.BY_DEFAULT);
    }

    @Override
    public Collection<Photo> getAllPhotos(NodePK nodePK, MediaCriteria.VISIBILITY visibility) {
        try {
            String albumId = nodePK.getId();
            String instanceId = nodePK.getInstanceId();
            return PhotoDAO.getAllPhoto(albumId, instanceId, visibility);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public Collection<Media> getNotVisible(String instanceId) {
        try {
            return MediaDAO.findByCriteria(MediaCriteria.fromComponentInstanceId(instanceId).withVisibility(MediaCriteria.VISIBILITY.HIDDEN_ONLY));
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void paste(UserDetail user, String componentInstanceId, GalleryPasteDelegate delegate) {
        try {
            GalleryProcessManagement processManagement = new GalleryProcessManagement(user, componentInstanceId);
            if (delegate.getAlbum().hasFather()) {
                for (Map.Entry<Object, Boolean> entry : delegate.getMediaToPaste().entrySet()) {
                    processManagement.addPasteMediaProcesses(this.getMedia(((Media)entry.getKey()).getMediaPK(), MediaCriteria.VISIBILITY.FORCE_GET_ALL), delegate.getAlbum().getNodePK(), entry.getValue());
                }
            }
            for (Map.Entry<Object, Boolean> entry : delegate.getAlbumsToPaste().entrySet()) {
                processManagement.addPasteAlbumProcesses((AlbumDetail)((Object)entry.getKey()), delegate.getAlbum(), entry.getValue());
            }
            processManagement.execute();
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.SUPPORTS)
    public void importFromRepository(UserDetail user, String componentInstanceId, File repository, MediaDataCreateDelegate delegate) {
        try {
            GalleryProcessManagement.importFromRepositoryProcesses(user, componentInstanceId, repository, delegate.getAlbumId(), delegate);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public Media createMedia(UserDetail user, String componentInstanceId, Watermark watermark, MediaDataCreateDelegate delegate) {
        try {
            GalleryProcessManagement processManagement = new GalleryProcessManagement(user, componentInstanceId);
            Media newMedia = delegate.newInstance();
            processManagement.addCreateMediaProcesses(newMedia, delegate.getAlbumId(), delegate.getFileItem(), watermark, delegate);
            processManagement.execute();
            return newMedia;
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void updateMedia(UserDetail user, String componentInstanceId, Collection<String> mediaIds, String albumId, MediaDataUpdateDelegate delegate) {
        try {
            GalleryProcessManagement processManagement = new GalleryProcessManagement(user, componentInstanceId);
            for (String mediaId : mediaIds) {
                processManagement.addUpdateMediaProcesses(this.getMedia(new MediaPK(mediaId, componentInstanceId)), null, delegate);
            }
            processManagement.execute();
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void updateMedia(UserDetail user, String componentInstanceId, Media media, Watermark watermark, MediaDataUpdateDelegate delegate) {
        try {
            GalleryProcessManagement processManagement = new GalleryProcessManagement(user, componentInstanceId);
            processManagement.addUpdateMediaProcesses(media, watermark, delegate);
            processManagement.execute();
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteMedia(UserDetail user, String componentInstanceId, Collection<String> mediaIds) {
        try {
            GalleryProcessManagement processManagement = new GalleryProcessManagement(user, componentInstanceId);
            for (String mediaId : mediaIds) {
                processManagement.addDeleteMediaProcesses(this.getMedia(new MediaPK(mediaId, componentInstanceId)));
            }
            processManagement.execute();
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public List<Media> getLastRegisteredMedia(String instanceId) {
        try {
            return MediaDAO.findByCriteria(MediaCriteria.fromComponentInstanceId(instanceId).orderedBy(MediaCriteria.QUERY_ORDER_BY.CREATE_DATE_DESC, MediaCriteria.QUERY_ORDER_BY.IDENTIFIER_DESC).limitResultTo(GalleryComponentSettings.getNbMediaDisplayedPerPage()));
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    private Connection openConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (SQLException e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public Collection<NodeDetail> getPath(NodePK nodePK) {
        NodePath path;
        try {
            path = this.nodeService.getPath(nodePK);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
        return path;
    }

    @Override
    public Collection<String> getAlbumIdsOf(Media media) {
        try {
            return MediaDAO.getAlbumIdsOf(media);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeMediaFromAllAlbums(Media media) {
        try {
            MediaDAO.deleteAllMediaPath(media);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void addMediaToAlbums(Media media, String ... albums) {
        try {
            for (String albumId : albums) {
                MediaDAO.saveMediaPath(media, albumId);
            }
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public void indexGallery(UserDetail user, String instanceId) {
        Collection<AlbumDetail> albums = this.getAllAlbums(instanceId);
        if (albums != null) {
            for (AlbumDetail album : albums) {
                try {
                    this.nodeService.createIndex((NodeDetail)album);
                }
                catch (Exception e) {
                    throw new GalleryRuntimeException(e);
                }
                Collection<Media> media = this.getAllMedia(album.getNodePK(), MediaCriteria.VISIBILITY.FORCE_GET_ALL);
                if (media == null) continue;
                for (Media aMedia : media) {
                    this.createIndex(user, aMedia);
                }
            }
        }
    }

    private void createIndex(UserDetail user, Media media) {
        try {
            GalleryProcessManagement processManagement = new GalleryProcessManagement(user, media.getComponentInstanceId());
            processManagement.addIndexMediaProcesses(media);
            processManagement.execute();
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public int getSilverObjectId(MediaPK mediaPK) {
        int silverObjectId;
        try {
            silverObjectId = this.galleryContentManager.getSilverContentId(mediaPK.getId(), mediaPK.getInstanceId());
            if (silverObjectId == -1) {
                Media media = this.getMedia(mediaPK, MediaCriteria.VISIBILITY.FORCE_GET_ALL);
                silverObjectId = (Integer)Transaction.performInOne(() -> this.createSilverContent(media, media.getCreatorId()));
            }
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
        return silverObjectId;
    }

    private int createSilverContent(Media media, String creatorId) {
        try {
            return this.galleryContentManager.createSilverContent((Contribution)media, creatorId);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public Collection<Media> search(QueryDescription query) {
        ArrayList<Media> mediaList = new ArrayList<Media>();
        try {
            List results = SearchService.get().search(query);
            results.stream().filter(result -> MediaType.from(result.getType()) != MediaType.Unknown).forEach(result -> {
                MediaPK mediaPK = new MediaPK(result.getId());
                Media media = this.getMedia(mediaPK);
                if (media != null) {
                    mediaList.add(media);
                }
            });
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
        return mediaList;
    }

    @Override
    public Collection<Media> getAllMediaThatWillBeNotVisible(int nbDays) {
        try {
            return MediaDAO.findByCriteria(MediaCriteria.fromNbDaysBeforeThatMediaIsNotVisible(nbDays).withVisibility(MediaCriteria.VISIBILITY.FORCE_GET_ALL));
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public String createOrder(Collection<String> basket, String userId, String componentId) {
        try {
            return OrderDAO.createOrder(basket, userId, componentId);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public List<Order> getAllOrders(String userId, String instanceId) {
        try {
            return OrderDAO.findByCriteria(MediaOrderCriteria.fromComponentInstanceId(instanceId).withOrdererId(userId));
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void updateOrder(Order order) {
        try {
            OrderDAO.updateOrder(order);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void updateOrderRow(OrderRow row) {
        try {
            OrderDAO.updateOrderRow(row);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public Order getOrder(String orderId, String instanceId) {
        try {
            return OrderDAO.getByCriteria(MediaOrderCriteria.fromComponentInstanceId(instanceId).identifierIsOneOf(orderId));
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public List<Order> getAllOrderToDelete(int nbDays) {
        try {
            return OrderDAO.findByCriteria(MediaOrderCriteria.fromNbDaysAfterThatDeleteAnOrder(nbDays));
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteOrders(List<Order> orders) {
        try {
            for (Order order : orders) {
                OrderDAO.deleteOrder(order);
            }
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public List<SocialInformation> getAllMediaByUserId(String userId, Period period) {
        try {
            return MediaDAO.getAllMediaIdByUserId(userId, period);
        }
        catch (SQLException e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public List<SocialInformation> getSocialInformationListOfMyContacts(List<String> listOfUserId, List<String> availableComponent, Period period) {
        try {
            return MediaDAO.getSocialInformationListOfMyContacts(listOfUserId, availableComponent, period);
        }
        catch (SQLException e) {
            throw new GalleryRuntimeException(e);
        }
    }

    @Override
    public void sortAlbums(List<NodePK> nodePKs) {
        try (Connection con = this.openConnection();){
            this.nodeDAO.sortNodes(con, nodePKs);
        }
        catch (SQLException e) {
            throw new GalleryRuntimeException(e);
        }
    }
}

