/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.blog.notification;

import java.util.Collection;
import org.owasp.encoder.Encode;
import org.silverpeas.components.blog.model.PostDetail;
import org.silverpeas.components.blog.notification.AbstractBlogUserNotification;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.notification.user.UserSubscriptionNotificationBehavior;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.service.ResourceSubscriptionProvider;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberMapBySubscriberType;
import org.silverpeas.core.template.SilverpeasTemplate;

public class BlogUserSubscriptionNotification
extends AbstractBlogUserNotification
implements UserSubscriptionNotificationBehavior {
    private final String fileName;
    private final NotifAction action;
    private final Comment comment;
    private final SubscriptionSubscriberMapBySubscriberType subscriberIdsByTypes;

    public BlogUserSubscriptionNotification(PostDetail postDetail, Comment comment, String type, String senderId) {
        super(postDetail, (User)UserDetail.getById((String)senderId));
        if ("create".equals(type)) {
            this.fileName = "blogNotificationSubscriptionCreate";
            this.action = NotifAction.CREATE;
        } else {
            this.fileName = "blogNotificationSubscriptionUpdate";
            this.action = NotifAction.UPDATE;
        }
        this.subscriberIdsByTypes = ResourceSubscriptionProvider.getSubscribersOfComponent((String)this.getComponentInstanceId()).indexBySubscriberType();
        this.comment = comment;
    }

    protected String getBundleSubjectKey() {
        return "blog.subjectSubscription";
    }

    protected String getTemplateFileName() {
        return this.fileName;
    }

    protected Collection<String> getUserIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.USER)).getAllIds();
    }

    protected Collection<String> getGroupIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.GROUP)).getAllIds();
    }

    @Override
    protected void performTemplateData(String language, PostDetail resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        template.setAttribute("comment", (Object)this.comment);
        String commentMessage = null;
        if (this.comment != null) {
            commentMessage = Encode.forHtml((String)this.comment.getMessage());
        }
        template.setAttribute("commentMessage", commentMessage);
    }

    protected NotifAction getAction() {
        return this.action;
    }
}

