/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.commons.TimeDurationFormatter;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.NodeDocumentSweepListener;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NodeDocumentSweeper {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDocumentSweeper.class);
    private static final int INVALIDATE_BATCH_SIZE = 100;
    private static final long LOGINTERVALMS = TimeUnit.MINUTES.toMillis(1L);
    static Predicate<String> SWEEP_ONE_PREDICATE = Utils.PROPERTY_OR_DELETED_OR_COMMITROOT_OR_REVISIONS;
    private final RevisionContext context;
    private final int clusterId;
    private final RevisionVector headRevision;
    private final boolean sweepNewerThanHead;
    private Revision head;
    private long totalCount;
    private long lastCount;
    private long startOfScan;
    private long lastLog;

    NodeDocumentSweeper(RevisionContext context, boolean sweepNewerThanHead) {
        this.context = (RevisionContext)Preconditions.checkNotNull((Object)context);
        this.clusterId = context.getClusterId();
        this.headRevision = context.getHeadRevision();
        this.sweepNewerThanHead = sweepNewerThanHead;
    }

    @Nullable
    Revision sweep(@NotNull Iterable<NodeDocument> documents, @NotNull NodeDocumentSweepListener listener) throws DocumentStoreException {
        return this.performSweep(documents, (NodeDocumentSweepListener)Preconditions.checkNotNull((Object)listener));
    }

    RevisionVector getHeadRevision() {
        return this.headRevision;
    }

    @Nullable
    private Revision performSweep(Iterable<NodeDocument> documents, NodeDocumentSweepListener listener) throws DocumentStoreException {
        this.head = this.headRevision.getRevision(this.clusterId);
        this.totalCount = 0L;
        this.lastCount = 0L;
        this.lastLog = this.startOfScan = this.context.getClock().getTime();
        if (this.head == null) {
            LOG.warn("Head revision does not have an entry for clusterId {}. Sweeping of documents is skipped.", (Object)this.clusterId);
            return null;
        }
        Iterable<Map.Entry<Path, UpdateOp>> ops = this.sweepOperations(documents);
        for (List batch : Iterables.partition(ops, (int)100)) {
            HashMap updates = Maps.newHashMap();
            for (Map.Entry entry : batch) {
                updates.put((Path)entry.getKey(), (UpdateOp)entry.getValue());
            }
            listener.sweepUpdate(updates);
        }
        LOG.debug("Document sweep finished");
        return this.head;
    }

    private Iterable<Map.Entry<Path, UpdateOp>> sweepOperations(Iterable<NodeDocument> docs) {
        return Iterables.filter((Iterable)Iterables.transform(docs, (Function)new Function<NodeDocument, Map.Entry<Path, UpdateOp>>(){

            public Map.Entry<Path, UpdateOp> apply(NodeDocument doc) {
                return Maps.immutableEntry((Object)doc.getPath(), (Object)NodeDocumentSweeper.this.sweepOne(doc));
            }
        }), (Predicate)new Predicate<Map.Entry<Path, UpdateOp>>(){

            public boolean apply(Map.Entry<Path, UpdateOp> input) {
                return input.getValue() != null;
            }
        });
    }

    private UpdateOp sweepOne(NodeDocument doc) throws DocumentStoreException {
        UpdateOp op = NodeDocumentSweeper.createUpdateOp(doc);
        for (String property : Iterables.filter(doc.keySet(), SWEEP_ONE_PREDICATE)) {
            SortedMap<Revision, String> valueMap = doc.getLocalMap(property);
            for (Map.Entry entry : valueMap.entrySet()) {
                Revision rev = (Revision)entry.getKey();
                if (rev.getClusterId() != this.clusterId) continue;
                Revision cRev = this.getCommitRevision(doc, rev);
                if (cRev == null) {
                    this.uncommitted(doc, property, rev, op);
                    continue;
                }
                if (cRev.equals(rev)) {
                    this.committed(property, rev, op);
                    continue;
                }
                this.committedBranch(doc, property, rev, cRev, op);
            }
        }
        ++this.totalCount;
        ++this.lastCount;
        long now = this.context.getClock().getTime();
        long lastElapsed = now - this.lastLog;
        if (lastElapsed >= LOGINTERVALMS) {
            TimeDurationFormatter df = TimeDurationFormatter.forLogging();
            long totalElapsed = now - this.startOfScan;
            long totalRateMin = this.totalCount * TimeUnit.MINUTES.toMillis(1L) / totalElapsed;
            long lastRateMin = this.lastCount * TimeUnit.MINUTES.toMillis(1L) / lastElapsed;
            String message = String.format("Sweep on cluster node [%d]: %d nodes scanned in %s (~%d/m) - last interval %d nodes in %s (~%d/m)", this.clusterId, this.totalCount, df.format(totalElapsed, TimeUnit.MILLISECONDS), totalRateMin, this.lastCount, df.format(lastElapsed, TimeUnit.MILLISECONDS), lastRateMin);
            LOG.info(message);
            this.lastLog = now;
            this.lastCount = 0L;
        }
        return op.hasChanges() ? op : null;
    }

    private void uncommitted(NodeDocument doc, String property, Revision rev, UpdateOp op) {
        if (this.head.compareRevisionTime(rev) < 0 && !this.sweepNewerThanHead) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Uncommitted change on {}, {} @ {} newer than head {} ", new Object[]{op.getId(), property, rev, this.head});
            }
            return;
        }
        if (this.isV18BranchCommit(rev, doc)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unmerged branch commit on {}, {} @ {}", new Object[]{op.getId(), property, rev});
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Uncommitted change on {}, {} @ {}", new Object[]{op.getId(), property, rev});
            }
            op.removeMapEntry(property, rev);
            if (doc.getLocalCommitRoot().containsKey(rev)) {
                NodeDocument.removeCommitRoot(op, rev);
            } else {
                NodeDocument.removeRevision(op, rev);
            }
            if (NodeDocument.isDeletedEntry(property) && !doc.wasDeletedOnce() && "false".equals(doc.getLocalDeleted().get(rev))) {
                NodeDocument.setDeletedOnce(op);
            }
        }
    }

    private boolean isV18BranchCommit(Revision rev, NodeDocument doc) {
        return doc.getLocalBranchCommits().contains(rev);
    }

    private void committed(String property, Revision rev, UpdateOp op) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Committed change on {}, {} @ {}", new Object[]{op.getId(), property, rev});
        }
    }

    private void committedBranch(NodeDocument doc, String property, Revision rev, Revision cRev, UpdateOp op) {
        boolean newerThanHead;
        boolean bl = newerThanHead = cRev.compareRevisionTime(this.head) > 0;
        if (LOG.isDebugEnabled()) {
            String msg = newerThanHead ? " (newer than head)" : "";
            LOG.debug("Committed branch change on {}, {} @ {}/{}{}", new Object[]{op.getId(), property, rev, cRev, msg});
        }
        if (!this.isV18BranchCommit(rev, doc)) {
            NodeDocument.setBranchCommit(op, rev);
        }
    }

    private static UpdateOp createUpdateOp(NodeDocument doc) {
        return new UpdateOp(doc.getId(), false);
    }

    @Nullable
    private Revision getCommitRevision(NodeDocument doc, Revision rev) throws DocumentStoreException {
        String cv = this.context.getCommitValue(rev, doc);
        if (cv == null) {
            return null;
        }
        return Utils.resolveCommitRevision(rev, cv);
    }
}

