/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import java.nio.ByteBuffer;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.DataTypeUtil;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;

public class ValueDataType
implements DataType<Object> {
    private final DocumentNodeStore docNodeStore;
    private final DocumentStore docStore;
    private final CacheType type;

    ValueDataType(DocumentNodeStore docNodeStore, DocumentStore docStore, CacheType type) {
        this.docNodeStore = docNodeStore;
        this.docStore = docStore;
        this.type = type;
    }

    public int compare(Object a, Object b) {
        return 0;
    }

    public int getMemory(Object obj) {
        return ((CacheValue)obj).getMemory();
    }

    public void write(WriteBuffer buff, Object obj) {
        this.type.writeValue(buff, obj);
    }

    public Object read(ByteBuffer buff) {
        return this.type.readValue(this.docNodeStore, this.docStore, buff);
    }

    public void write(WriteBuffer buff, Object storage, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(buff, DataTypeUtil.cast(storage)[i]);
        }
    }

    public void read(ByteBuffer buff, Object storage, int len) {
        for (int i = 0; i < len; ++i) {
            DataTypeUtil.cast((Object)storage)[i] = this.read(buff);
        }
    }

    public int binarySearch(Object key, Object storage, int size, int initialGuess) {
        return DataTypeUtil.binarySearch(this, key, storage, size, initialGuess);
    }

    public boolean isMemoryEstimationAllowed() {
        return true;
    }

    public Object[] createStorage(int size) {
        return new Object[size];
    }
}

