/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import org.apache.jackrabbit.oak.security.authorization.permission.CacheStrategy;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;

final class CacheStrategyImpl
implements CacheStrategy {
    static final String EAGER_CACHE_SIZE_PARAM = "eagerCacheSize";
    private static final long DEFAULT_SIZE = 250L;
    static final String EAGER_CACHE_MAXPATHS_PARAM = "eagerCacheMaxPaths";
    private static final long DEFAULT_MAX_PATHS = 10L;
    private final long maxSize;
    private final long maxPaths;
    private final long threshold;
    private boolean fullyLoaded = true;

    CacheStrategyImpl(ConfigurationParameters options, boolean isRefresh) {
        this.maxSize = (Long)options.getConfigValue(EAGER_CACHE_SIZE_PARAM, (Object)250L);
        this.maxPaths = (Long)options.getConfigValue(EAGER_CACHE_MAXPATHS_PARAM, (Object)10L);
        this.threshold = isRefresh ? this.maxSize : Long.MAX_VALUE;
    }

    @Override
    public long maxSize() {
        return this.maxSize;
    }

    @Override
    public boolean loadFully(long numEntriesSize, long cnt) {
        if (numEntriesSize <= this.maxPaths && cnt < this.threshold) {
            return true;
        }
        this.fullyLoaded = false;
        return false;
    }

    @Override
    public boolean usePathEntryMap(long cnt) {
        if (cnt > 0L) {
            return this.fullyLoaded || cnt < this.maxSize;
        }
        return false;
    }
}

