/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.comment.service.notification;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.silverpeas.core.ApplicationServiceProvider;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.service.SilverpeasComponentInstanceProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.comment.model.CommentId;
import org.silverpeas.core.comment.service.CommentService;
import org.silverpeas.core.comment.service.CommentUserNotification;
import org.silverpeas.core.comment.service.notification.CommentEvent;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.NotificationSender;
import org.silverpeas.kernel.exception.NotFoundException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class CommentUserNotificationService
extends CDIResourceEventListener<CommentEvent> {
    private static final String SUBJECT_COMMENT_ADDING = "commentAddingSubject";
    @Inject
    private CommentService commentService;

    public void onCreation(CommentEvent event) throws Exception {
        Comment comment = (Comment)((Object)event.getTransition().getAfter());
        String componentInstanceId = comment.getComponentInstanceId();
        if (StringUtil.isDefined((String)componentInstanceId)) {
            Optional mayBeService = ApplicationServiceProvider.get().getApplicationServiceById(componentInstanceId);
            mayBeService.ifPresent(service -> {
                try {
                    ContributionIdentifier contributionId = ContributionIdentifier.from((ResourceReference)comment.getResourceReference(), (String)comment.getResourceType());
                    Contribution commentedContent = (Contribution)service.getContributionById(contributionId).orElseThrow(() -> new NotFoundException("No such contribution " + contributionId.asString()));
                    Set<String> recipients = this.getInterestedUsers(comment.getCreator().getId(), commentedContent);
                    if (!recipients.isEmpty()) {
                        String componentName = this.getComponentName(componentInstanceId);
                        Comment newComment = this.getCommentService().getComment(new CommentId(componentInstanceId, comment.getId()));
                        NotificationMetaData notification = UserNotificationHelper.build((UserNotificationBuilder)new CommentUserNotification(this.getCommentService(), newComment, commentedContent, componentName + ".commentAddingSubject", service.getComponentMessages(""), recipients));
                        this.notifyUsers(notification);
                    }
                }
                catch (Exception ex) {
                    SilverLogger.getLogger((Object)((Object)this)).error(ex.getMessage(), (Throwable)ex);
                }
            });
        }
    }

    private Set<String> getInterestedUsers(String commentAuthorId, Contribution contribution) {
        User contentUpdater;
        LinkedHashSet<String> interestedUsers = new LinkedHashSet<String>();
        ResourceReference ref = new ResourceReference(contribution.getIdentifier().getLocalId(), contribution.getIdentifier().getComponentInstanceId());
        List<Comment> comments = this.getCommentService().getAllCommentsOnResource(contribution.getContributionType(), ref);
        for (Comment aComment : comments) {
            User author = aComment.getCreator();
            if (author.getId().equals(commentAuthorId) || !this.canBeSent(contribution, author)) continue;
            interestedUsers.add(author.getId());
        }
        User contentCreator = contribution.getCreator();
        if (!commentAuthorId.equals(contentCreator.getId()) && this.canBeSent(contribution, contentCreator)) {
            interestedUsers.add(contentCreator.getId());
        }
        if ((contentUpdater = contribution.getLastUpdater()) != null && !contentUpdater.getId().equals(contentCreator.getId()) && !commentAuthorId.equals(contentUpdater.getId()) && this.canBeSent(contribution, contentUpdater)) {
            interestedUsers.add(contentUpdater.getId());
        }
        return interestedUsers;
    }

    protected void notifyUsers(NotificationMetaData notification) throws NotificationException {
        this.getNotificationSender(notification.getComponentId()).notifyUser(notification);
    }

    protected NotificationSender getNotificationSender(String componentInstanceId) {
        return new NotificationSender(componentInstanceId);
    }

    protected CommentService getCommentService() {
        return this.commentService;
    }

    private boolean canBeSent(Contribution contribution, User recipient) {
        return contribution.canBeAccessedBy(recipient);
    }

    private String getComponentName(String componentInstanceId) {
        return SilverpeasComponentInstanceProvider.get().getComponentName(componentInstanceId);
    }
}

