/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning.model;

import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBean;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;

public class DataWarningScheduler
extends SilverpeasBean {
    private static final long serialVersionUID = -406809133902097195L;
    public static final int SCHEDULER_N_TIMES_MOMENT_HOUR = 0;
    public static final int SCHEDULER_N_TIMES_MOMENT_DAY = 1;
    public static final int SCHEDULER_N_TIMES_MOMENT_WEEK = 2;
    public static final int SCHEDULER_N_TIMES_MOMENT_MONTH = 3;
    public static final int SCHEDULER_N_TIMES_MOMENT_YEAR = 4;
    public static final int SCHEDULER_STATE_OFF = 0;
    public static final int SCHEDULER_STATE_ON = 1;
    private static final int MINUTES_IN_HOUR = 60;
    private static final int HOURS_IN_DAY = 24;
    private static final int DAYS_IN_WEEK = 7;
    private static final int MONTHS_IN_YEAR = 12;
    private static final int MIN_DAYS_IN_MONTH = 28;
    private String instanceId;
    private int numberOfTimes;
    private int numberOfTimesMoment;
    private int minits;
    private int hours;
    private int dayOfWeek;
    private int dayOfMonth;
    private int theMonth;
    private int schedulerState = 0;
    private long wakeUp = 0L;

    public DataWarningScheduler copy() {
        DataWarningScheduler newOne;
        try {
            newOne = (DataWarningScheduler)((Object)super.clone());
        }
        catch (CloneNotSupportedException e) {
            SilverLogger.getLogger((Object)((Object)this)).silent((Throwable)e);
            newOne = new DataWarningScheduler();
        }
        newOne.instanceId = this.instanceId;
        newOne.numberOfTimes = this.numberOfTimes;
        newOne.numberOfTimesMoment = this.numberOfTimesMoment;
        newOne.minits = this.minits;
        newOne.hours = this.hours;
        newOne.dayOfWeek = this.dayOfWeek;
        newOne.dayOfMonth = this.dayOfMonth;
        newOne.theMonth = this.theMonth;
        newOne.schedulerState = this.schedulerState;
        newOne.wakeUp = this.wakeUp;
        newOne.setPK(this.getPK());
        return newOne;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public long getWakeUp() {
        return this.wakeUp;
    }

    public void setWakeUp(long wakeUp) {
        this.wakeUp = wakeUp;
    }

    public int getNumberOfTimes() {
        return this.numberOfTimes;
    }

    public void setNumberOfTimes(int numberOfTimes) {
        this.numberOfTimes = numberOfTimes;
    }

    public int getNumberOfTimesMoment() {
        return this.numberOfTimesMoment;
    }

    public void setNumberOfTimesMoment(int numberOfTimesMoment) {
        this.numberOfTimesMoment = numberOfTimesMoment;
    }

    public int getMinits() {
        return this.minits;
    }

    public void setMinits(int minits) {
        this.minits = minits;
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(int dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(int dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public int getTheMonth() {
        return this.theMonth;
    }

    public void setTheMonth(int month) {
        this.theMonth = month;
    }

    public int getSchedulerState() {
        return this.schedulerState;
    }

    public void setSchedulerState(int schedulerState) {
        this.schedulerState = schedulerState;
    }

    @NonNull
    protected String getTableName() {
        return "SC_DataWarning_Scheduler";
    }

    public String createCronString() {
        String cron = this.numberOfTimes == 1 ? this.cronForOneTime() : this.cronForSeveralTimes();
        return cron;
    }

    private String cronForSeveralTimes() {
        String cron = null;
        switch (this.numberOfTimesMoment) {
            case 0: {
                cron = this.cronSystem(60, this.numberOfTimes, false) + " * * * ?";
                break;
            }
            case 1: {
                cron = "* " + this.cronSystem(24, this.numberOfTimes, false) + " * * ?";
                break;
            }
            case 2: {
                cron = "* 12 ? * " + this.cronSystem(7, this.numberOfTimes, false);
                break;
            }
            case 3: {
                cron = "* 12 " + this.cronSystem(28, this.numberOfTimes, true) + " * ?";
                break;
            }
            case 4: {
                cron = "* 12 1 " + this.cronSystem(12, this.numberOfTimes, true) + " ?";
                break;
            }
        }
        return cron;
    }

    private String cronForOneTime() {
        String cron = null;
        switch (this.numberOfTimesMoment) {
            case 0: {
                cron = this.minits + " * * * ?";
                break;
            }
            case 1: {
                cron = this.minits + " " + this.hours + " * * ?";
                break;
            }
            case 2: {
                cron = this.minits + " " + this.hours + " ? * " + this.dayOfWeek;
                break;
            }
            case 3: {
                cron = this.minits + " " + this.hours + " " + (this.dayOfMonth + 1) + " * ?";
                break;
            }
            case 4: {
                cron = this.minits + " " + this.hours + " " + (this.dayOfMonth + 1) + " " + (this.theMonth + 1) + " ?";
                break;
            }
        }
        return cron;
    }

    private String cronSystem(int nb, int numberOfTimes, boolean startFromOne) {
        int multiplicateur = nb / numberOfTimes;
        StringBuilder temp = new StringBuilder();
        for (int i = 1; i < numberOfTimes + 1; ++i) {
            if (startFromOne) {
                temp.append(multiplicateur * i).append(",");
                continue;
            }
            temp.append(multiplicateur * i - 1).append(",");
        }
        temp.deleteCharAt(temp.length() - 1);
        return temp.toString();
    }
}

