/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.UserValidator;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class UserValidatorProvider
extends ValidatorProvider {
    private final ConfigurationParameters config;
    private final RootProvider rootProvider;
    private final TreeProvider treeProvider;
    private MembershipProvider membershipProvider;

    UserValidatorProvider(@NotNull ConfigurationParameters config, @NotNull RootProvider rootProvider, @NotNull TreeProvider treeProvider) {
        this.config = config;
        this.rootProvider = rootProvider;
        this.treeProvider = treeProvider;
    }

    @NotNull
    public Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        this.membershipProvider = new MembershipProvider(this.rootProvider.createReadOnlyRoot(after), this.config);
        return new UserValidator(this.treeProvider.createReadOnlyTree(before), this.treeProvider.createReadOnlyTree(after), this);
    }

    @NotNull
    ConfigurationParameters getConfig() {
        return this.config;
    }

    @NotNull
    MembershipProvider getMembershipProvider() {
        return this.membershipProvider;
    }
}

